/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataanalysis.ecoengine.transducers;

import java.util.List;
import org.gcube.contentmanagement.lexicalmatcher.utils.AnalysisLogger;
import org.gcube.contentmanagement.lexicalmatcher.utils.DatabaseFactory;
import org.gcube.dataanalysis.ecoengine.configuration.AlgorithmConfiguration;
import org.gcube.dataanalysis.ecoengine.configuration.INFRASTRUCTURE;
import org.gcube.dataanalysis.ecoengine.datatypes.StatisticalType;
import org.gcube.dataanalysis.ecoengine.interfaces.Transducerer;
import org.gcube.dataanalysis.ecoengine.utils.DatabaseUtils;
import org.gcube.dataanalysis.ecoengine.utils.ResourceFactory;
import org.hibernate.SessionFactory;

public class QueryExecutor
implements Transducerer {
    protected String query = "";
    protected String finalTableName = "";
    protected String finalTableLabel = "";
    protected float status = 0.0f;
    protected AlgorithmConfiguration config;
    protected static String finalTable = "Table_Name";
    protected static String finalTableLabel$ = "Table_Label";
    ResourceFactory resourceManager;

    @Override
    public List<StatisticalType> getInputParameters() {
        return null;
    }

    @Override
    public String getResourceLoad() {
        if (this.status > 0.0f && this.status < 100.0f) {
            return ResourceFactory.getResources(100.0f);
        }
        return ResourceFactory.getResources(0.0f);
    }

    @Override
    public String getResources() {
        if (this.resourceManager == null) {
            this.resourceManager = new ResourceFactory();
        }
        return this.resourceManager.getResourceLoad(1);
    }

    @Override
    public float getStatus() {
        return this.status;
    }

    @Override
    public INFRASTRUCTURE getInfrastructure() {
        return INFRASTRUCTURE.LOCAL;
    }

    @Override
    public StatisticalType getOutput() {
        return null;
    }

    @Override
    public void init() throws Exception {
    }

    @Override
    public void setConfiguration(AlgorithmConfiguration config) {
        this.config = config;
    }

    @Override
    public void shutdown() {
    }

    @Override
    public String getDescription() {
        return null;
    }

    @Override
    public void compute() throws Exception {
        SessionFactory dbconnection = null;
        try {
            AnalysisLogger.getLogger().trace((Object)"Initializing DB Connection");
            dbconnection = DatabaseUtils.initDBSession(this.config);
            AnalysisLogger.getLogger().trace((Object)("Deleting Previous Table " + DatabaseUtils.dropTableStatement(this.finalTableName)));
            try {
                DatabaseFactory.executeSQLUpdate(DatabaseUtils.dropTableStatement(this.finalTableName), dbconnection);
            }
            catch (Exception ee) {
                // empty catch block
            }
            this.status = 10.0f;
            AnalysisLogger.getLogger().trace((Object)"Deleted");
            AnalysisLogger.getLogger().trace((Object)("Executing query: " + this.query));
            DatabaseFactory.executeSQLUpdate(this.query, dbconnection);
            AnalysisLogger.getLogger().trace((Object)"Executed!");
        }
        catch (Exception e) {
            AnalysisLogger.getLogger().trace((Object)"ERROR:", (Throwable)e);
            throw e;
        }
        finally {
            if (dbconnection != null) {
                try {
                    dbconnection.close();
                }
                catch (Exception e2) {}
            }
            this.status = 100.0f;
            AnalysisLogger.getLogger().trace((Object)"Processing Finished and db closed");
        }
    }
}

