/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataanalysis.ecoengine.user;

import java.util.List;
import org.gcube.dataanalysis.ecoengine.configuration.AlgorithmConfiguration;
import org.gcube.dataanalysis.ecoengine.interfaces.ComputationalAgent;
import org.gcube.dataanalysis.ecoengine.processing.factories.GeneratorsFactory;

public class GeneratorT
implements Runnable {
    ComputationalAgent dg;

    public GeneratorT(ComputationalAgent dg) {
        this.dg = dg;
    }

    @Override
    public void run() {
        try {
            this.dg.compute();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void generate(AlgorithmConfiguration config) throws Exception {
        List<ComputationalAgent> generators = GeneratorsFactory.getGenerators(config);
        ComputationalAgent generator = generators.get(0);
        if (generator != null) {
            generator.init();
            GeneratorT tgs = new GeneratorT(generator);
            Thread t = new Thread(tgs);
            t.start();
            while (generator.getStatus() < 100.0f) {
                String resLoad = generator.getResourceLoad();
                String ress = generator.getResources();
                System.out.println("LOAD: " + resLoad);
                System.out.println("RESOURCES: " + ress);
                System.out.println("STATUS: " + generator.getStatus());
                Thread.sleep(1000L);
            }
        } else {
            System.out.println("Generator Algorithm Not Supported");
        }
    }

    public static AlgorithmConfiguration getGenerationConfig(int numberOfResources, String algorithmName, String envelopeTable, String preprocessedTable, String speciesName, String userName, String csquareTable, String finalDistributionTable, String configPath) {
        AlgorithmConfiguration config = new AlgorithmConfiguration();
        config.setConfigPath(configPath);
        config.setPersistencePath(configPath);
        config.setNumberOfResources(numberOfResources);
        config.setModel(algorithmName);
        config.setParam("EnvelopeTable", envelopeTable);
        config.setParam("SpeciesName", speciesName);
        config.setParam("CsquarecodesTable", csquareTable);
        config.setParam("DistributionTable", finalDistributionTable);
        config.setParam("CreateTable", "true");
        config.setParam("UserName", userName);
        return config;
    }
}

