/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataanalysis.ecoengine.utils;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import sun.reflect.ConstructorAccessor;
import sun.reflect.FieldAccessor;
import sun.reflect.ReflectionFactory;

public class DynamicEnum {
    private ReflectionFactory reflectionFactory = ReflectionFactory.getReflectionFactory();

    private void setFailsafeFieldValue(Field field, Object target, Object value) throws NoSuchFieldException, IllegalAccessException {
        field.setAccessible(true);
        Field modifiersField = Field.class.getDeclaredField("modifiers");
        modifiersField.setAccessible(true);
        int modifiers = modifiersField.getInt(field);
        modifiersField.setInt(field, modifiers &= 0xFFFFFFEF);
        FieldAccessor fa = this.reflectionFactory.newFieldAccessor(field, false);
        fa.set(target, value);
    }

    private void blankField(Class<?> enumClass, String fieldName) throws NoSuchFieldException, IllegalAccessException {
        Field[] fieldArray = Class.class.getDeclaredFields();
        int n = fieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            Field field = fieldArray[n2];
            if (field.getName().contains(fieldName)) {
                AccessibleObject.setAccessible(new Field[]{field}, true);
                this.setFailsafeFieldValue(field, enumClass, null);
                break;
            }
            ++n2;
        }
    }

    private void cleanEnumCache(Class<?> enumClass) throws NoSuchFieldException, IllegalAccessException {
        this.blankField(enumClass, "enumConstantDirectory");
        this.blankField(enumClass, "enumConstants");
    }

    private ConstructorAccessor getConstructorAccessor(Class<?> enumClass, Class<?>[] additionalParameterTypes) throws NoSuchMethodException {
        Class[] parameterTypes = new Class[additionalParameterTypes.length + 2];
        parameterTypes[0] = String.class;
        parameterTypes[1] = Integer.TYPE;
        System.arraycopy(additionalParameterTypes, 0, parameterTypes, 2, additionalParameterTypes.length);
        return this.reflectionFactory.newConstructorAccessor(enumClass.getDeclaredConstructor(parameterTypes));
    }

    private Object makeEnum(Class<?> enumClass, String value, int ordinal, Class<?>[] additionalTypes, Object[] additionalValues) throws Exception {
        Object[] parms = new Object[additionalValues.length + 2];
        parms[0] = value;
        parms[1] = ordinal;
        System.arraycopy(additionalValues, 0, parms, 2, additionalValues.length);
        return enumClass.cast(this.getConstructorAccessor(enumClass, additionalTypes).newInstance(parms));
    }

    public <T extends Enum<?>> void addEnum(Class<T> enumType, String enumName) {
        Field[] fields;
        if (!Enum.class.isAssignableFrom(enumType)) {
            throw new RuntimeException("class " + enumType + " is not an instance of Enum");
        }
        Field valuesField = null;
        Field[] fieldArray = fields = this.getFields();
        int n = fields.length;
        int n2 = 0;
        while (n2 < n) {
            Field field = fieldArray[n2];
            if (field.getName().contains("$VALUES")) {
                valuesField = field;
                break;
            }
            ++n2;
        }
        AccessibleObject.setAccessible(new Field[]{valuesField}, true);
        try {
            Enum[] previousValues = (Enum[])valuesField.get(enumType);
            ArrayList<Enum> values = new ArrayList<Enum>(Arrays.asList(previousValues));
            Enum newValue = (Enum)this.makeEnum(enumType, enumName, values.size(), new Class[0], new Object[0]);
            values.add(newValue);
            this.setFailsafeFieldValue(valuesField, null, values.toArray((Enum[])Array.newInstance(enumType, 0)));
            this.cleanEnumCache(enumType);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public Field[] getFields() {
        Field[] fields = DynamicEnumE.class.getDeclaredFields();
        return fields;
    }

    public static void main(String[] args) {
        DynamicEnum en = new DynamicEnum();
        en.addEnum(DynamicEnumE.class, "d");
        en.addEnum(DynamicEnumE.class, "e");
        en.addEnum(DynamicEnumE.class, "f");
        System.out.println(Arrays.deepToString((Object[])DynamicEnumE.values()));
    }

    public static enum DynamicEnumE {

    }
}

