/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataanalysis.ecoengine.models.cores.neuralnetworks.neurosolutions;

import java.io.Serializable;
import org.gcube.dataanalysis.ecoengine.models.cores.neuralnetworks.neurosolutions.Randomizer;
import org.gcube.dataanalysis.ecoengine.models.cores.neuralnetworks.neurosolutions.Synapse;

public class Neuron
implements Serializable {
    public int id;
    public double threshold;
    private double prevthreshold;
    public int layer;
    public double output;
    public char axonfamily;
    protected double momentumrate;
    protected double axonfuncflatness;
    protected double learningratecoefficient;
    public Neuron[] neuronsout;
    public Neuron[] neuronsin;
    public Synapse[] synapsesout;
    public Synapse[] synapsesin;
    protected double error;
    protected double cumulthresholddiff;

    public Neuron(int id) {
        this.id = id;
        this.layer = 0;
    }

    public Neuron(int id, int layer, double axonfuncflatness, char axonfamily, double momentumrate, double learningratecoefficient, Randomizer randomizer) {
        this.output = 0.0;
        this.axonfamily = axonfamily;
        this.prevthreshold = this.threshold = randomizer.Uniform(-1.0, 1.0);
        this.id = id;
        this.layer = layer;
        this.momentumrate = momentumrate;
        this.axonfuncflatness = axonfuncflatness;
        this.learningratecoefficient = learningratecoefficient;
        this.cumulthresholddiff = 0.0;
    }

    public void InsOuts(Neuron[] neuronsin, Neuron[] neuronsout, Synapse[] synapsesin, Synapse[] synapsesout) {
        this.neuronsin = neuronsin;
        this.neuronsout = neuronsout;
        this.synapsesin = synapsesin;
        this.synapsesout = synapsesout;
    }

    public void UpdateOutput() {
        double activation = 0.0;
        int i = 0;
        while (i < this.neuronsin.length) {
            activation += this.neuronsin[i].output * this.synapsesin[i].weight;
            ++i;
        }
        activation += -1.0 * this.threshold;
        switch (this.axonfamily) {
            case 'g': {
                this.output = 1.0 / (1.0 + Math.exp(-activation / this.axonfuncflatness));
                break;
            }
            case 't': {
                this.output = 2.0 / (1.0 + Math.exp(-activation / this.axonfuncflatness)) - 1.0;
                break;
            }
            case 'l': {
                this.output = activation;
            }
        }
    }

    public void OutputIncrementalTrain(double rate, double target) {
        this.error = (target - this.output) * this.Derivative();
        this.IncrementalUpdateWeights(rate);
    }

    public void HiddenIncrementalTrain(double rate) {
        double temp_diff = 0.0;
        int i = 0;
        while (i < this.neuronsout.length) {
            temp_diff += this.neuronsout[i].error * this.synapsesout[i].prevweight;
            ++i;
        }
        this.error = temp_diff * this.Derivative();
        this.IncrementalUpdateWeights(rate);
    }

    private void IncrementalUpdateWeights(double rate) {
        double temp_weight;
        int i = 0;
        while (i < this.synapsesin.length) {
            temp_weight = this.synapsesin[i].weight;
            this.synapsesin[i].weight += rate * this.learningratecoefficient * this.error * this.neuronsin[i].output + this.momentumrate * (this.synapsesin[i].weight - this.synapsesin[i].prevweight);
            this.synapsesin[i].prevweight = temp_weight;
            if (this.synapsesin[i].cumulweightdiff != 0.0) {
                this.synapsesin[i].cumulweightdiff = 0.0;
            }
            ++i;
        }
        temp_weight = this.threshold;
        this.threshold += rate * this.learningratecoefficient * this.error * -1.0 + this.momentumrate * (this.threshold - this.prevthreshold);
        this.prevthreshold = temp_weight;
        if (this.cumulthresholddiff != 0.0) {
            this.cumulthresholddiff = 0.0;
        }
    }

    public void OutputBatchTrain(double rate, double target) {
        this.error = (target - this.output) * this.Derivative();
        this.BatchCumulateWeights(rate);
    }

    public void HiddenBatchTrain(double rate) {
        double temp_diff = 0.0;
        int i = 0;
        while (i < this.neuronsout.length) {
            temp_diff += this.neuronsout[i].error * this.synapsesout[i].weight;
            ++i;
        }
        this.error = temp_diff * this.Derivative();
        this.BatchCumulateWeights(rate);
    }

    private void BatchCumulateWeights(double rate) {
        int i = 0;
        while (i < this.synapsesin.length) {
            this.synapsesin[i].cumulweightdiff += rate * this.learningratecoefficient * this.error * this.neuronsin[i].output;
            ++i;
        }
        this.cumulthresholddiff += rate * this.learningratecoefficient * this.error * -1.0;
    }

    public void BatchUpdateWeights(int noofepochs) {
        double temp_weight;
        int i = 0;
        while (i < this.synapsesin.length) {
            temp_weight = this.synapsesin[i].weight;
            this.synapsesin[i].weight += this.synapsesin[i].cumulweightdiff / (double)noofepochs + this.momentumrate * (this.synapsesin[i].weight - this.synapsesin[i].prevweight);
            this.synapsesin[i].prevweight = temp_weight;
            this.synapsesin[i].cumulweightdiff = 0.0;
            ++i;
        }
        temp_weight = this.threshold;
        this.threshold += this.cumulthresholddiff / (double)noofepochs + this.momentumrate * (this.threshold - this.prevthreshold);
        this.prevthreshold = temp_weight;
        this.cumulthresholddiff = 0.0;
    }

    public double Derivative() {
        double temp_derivative;
        switch (this.axonfamily) {
            case 'g': {
                temp_derivative = this.output * (1.0 - this.output) / this.axonfuncflatness;
                break;
            }
            case 't': {
                temp_derivative = (1.0 - Math.pow(this.output, 2.0)) / (2.0 * this.axonfuncflatness);
                break;
            }
            case 'l': {
                temp_derivative = 1.0;
                break;
            }
            default: {
                temp_derivative = 0.0;
            }
        }
        return temp_derivative;
    }
}

