/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataanalysis.ecoengine.clustering;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.set.SimpleExampleSet;
import com.rapidminer.example.table.DataRow;
import com.rapidminer.example.table.MemoryExampleTable;
import com.rapidminer.operator.IOContainer;
import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.preprocessing.outlier.LOFOutlierOperator;
import com.rapidminer.tools.OperatorService;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import org.gcube.contentmanagement.lexicalmatcher.utils.AnalysisLogger;
import org.gcube.dataanalysis.ecoengine.clustering.DBScan;
import org.gcube.dataanalysis.ecoengine.configuration.AlgorithmConfiguration;
import org.gcube.dataanalysis.ecoengine.datatypes.ColumnTypesList;
import org.gcube.dataanalysis.ecoengine.datatypes.DatabaseType;
import org.gcube.dataanalysis.ecoengine.datatypes.InputTable;
import org.gcube.dataanalysis.ecoengine.datatypes.PrimitiveType;
import org.gcube.dataanalysis.ecoengine.datatypes.ServiceType;
import org.gcube.dataanalysis.ecoengine.datatypes.StatisticalType;
import org.gcube.dataanalysis.ecoengine.datatypes.enumtypes.PrimitiveTypes;
import org.gcube.dataanalysis.ecoengine.datatypes.enumtypes.ServiceParameters;
import org.gcube.dataanalysis.ecoengine.datatypes.enumtypes.TableTemplates;
import org.gcube.dataanalysis.ecoengine.utils.DatabaseFactory;
import org.gcube.dataanalysis.ecoengine.utils.DatabaseUtils;
import org.gcube.dataanalysis.ecoengine.utils.DynamicEnum;
import org.gcube.dataanalysis.ecoengine.utils.ResourceFactory;

public class LOF
extends DBScan {
    String minimal_points_lower_bound = "1";
    String minimal_points_upper_bound = "10";
    String lof_threshold = "2";
    String distance_function = "euclidian distance";
    static String lofcolumn = "lof";
    static String lofcolumntype = "real";
    LOFenum enuFunctions = new LOFenum();
    ResourceFactory resourceManager;

    @Override
    public void init() throws Exception {
        this.status = 0.0f;
        if (this.config != null && this.initrapidminer) {
            this.config.initRapidMiner();
        }
        AnalysisLogger.getLogger().debug((Object)"Initialized Rapid Miner ");
        AnalysisLogger.getLogger().debug((Object)"Initializing Database Connection");
        this.dbHibConnection = DatabaseUtils.initDBSession(this.config);
        try {
            AnalysisLogger.getLogger().debug((Object)("dropping table " + this.OccurrencePointsClusterTable));
            String dropStatement = DatabaseUtils.dropTableStatement(this.OccurrencePointsClusterTable);
            AnalysisLogger.getLogger().debug((Object)("dropping table " + dropStatement));
            DatabaseFactory.executeSQLUpdate(dropStatement, this.dbHibConnection);
        }
        catch (Exception e) {
            AnalysisLogger.getLogger().debug((Object)("Could not drop table " + this.OccurrencePointsClusterTable));
        }
        AnalysisLogger.getLogger().debug((Object)("Creating table " + this.OccurrencePointsClusterTable));
        String[] features = this.FeaturesColumnNames.split(AlgorithmConfiguration.getListSeparator());
        String columns = "";
        int i = 0;
        while (i < features.length) {
            columns = String.valueOf(columns) + features[i] + " real";
            if (i < features.length - 1) {
                columns = String.valueOf(columns) + ",";
            }
            ++i;
        }
        String createStatement = "create table " + this.OccurrencePointsClusterTable + " ( " + columns + ")";
        AnalysisLogger.getLogger().debug((Object)("Statement: " + createStatement));
        DatabaseFactory.executeSQLUpdate(createStatement, this.dbHibConnection);
        AnalysisLogger.getLogger().debug((Object)"Adding Columns");
        DatabaseFactory.executeSQLUpdate(DatabaseUtils.addColumnStatement(this.OccurrencePointsClusterTable, lofcolumn, lofcolumntype), this.dbHibConnection);
        DatabaseFactory.executeSQLUpdate(DatabaseUtils.addColumnStatement(this.OccurrencePointsClusterTable, outliersColumn, outliersColumnType), this.dbHibConnection);
        AnalysisLogger.getLogger().debug((Object)"Getting Samples");
        this.getSamples();
        this.status = 10.0f;
    }

    @Override
    public void setConfiguration(AlgorithmConfiguration config) {
        if (config != null) {
            this.minimal_points_lower_bound = config.getParam("minimal_points_lower_bound");
            this.minimal_points_upper_bound = config.getParam("minimal_points_upper_bound");
            this.distance_function = config.getParam("distance_function");
            this.lof_threshold = config.getParam("lof_threshold");
            this.OccurrencePointsTable = config.getParam("PointsTable").toLowerCase();
            this.OccurrencePointsClusterLabel = config.getParam("PointsClusterLabel");
            this.OccurrencePointsClusterTable = config.getParam("PointsClusterTable").toLowerCase();
            this.FeaturesColumnNames = config.getParam("FeaturesColumnNames");
            this.config = config;
        }
    }

    @Override
    public void compute() throws Exception {
        try {
            if (this.config == null || this.minimal_points_lower_bound == null || this.minimal_points_upper_bound == null || this.distance_function == null) {
                throw new Exception("LOF: Error incomplete parameters");
            }
            this.status = 10.0f;
            AnalysisLogger.getLogger().debug((Object)"LOF: Settin up the cluster");
            LOFOutlierOperator clusterer = (LOFOutlierOperator)OperatorService.createOperator((String)"LOFOutlierDetection");
            clusterer.setParameter("minimal_points_lower_bound", this.minimal_points_lower_bound);
            clusterer.setParameter("minimal_points_upper_bound", this.minimal_points_upper_bound);
            clusterer.setParameter("distance_function", this.distance_function);
            IOContainer innerInput = new IOContainer(new IOObject[]{this.points});
            AnalysisLogger.getLogger().debug((Object)"LOF: Clustering...");
            long ti = System.currentTimeMillis();
            IOContainer output = clusterer.apply(innerInput);
            AnalysisLogger.getLogger().debug((Object)("LOF: ...ELAPSED CLUSTERING TIME: " + (System.currentTimeMillis() - ti)));
            AnalysisLogger.getLogger().debug((Object)"LOF: ...Clustering Finished");
            this.status = 70.0f;
            IOObject[] outputvector = output.getIOObjects();
            this.BuildClusterTable(outputvector);
        }
        finally {
            this.shutdown();
            this.status = 100.0f;
        }
    }

    @Override
    protected void BuildClusterTable(IOObject[] outputvector) throws Exception {
        StringBuffer bufferRows = new StringBuffer();
        SimpleExampleSet output = (SimpleExampleSet)outputvector[0];
        MemoryExampleTable met = (MemoryExampleTable)output.getExampleTable();
        int numofcolumns = met.getAttributeCount();
        int numofrows = met.size();
        double lofthr = 2.0;
        if (this.lof_threshold != null) {
            try {
                lofthr = Double.parseDouble(this.lof_threshold);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        AnalysisLogger.getLogger().debug((Object)("LOF: using lof threshold :" + lofthr));
        int i = 0;
        while (i < numofrows) {
            DataRow dr = met.getDataRow(i);
            Attribute outlierAtt = met.getAttribute(numofcolumns - 1);
            bufferRows.append("(");
            int j = 0;
            while (j < numofcolumns - 2) {
                Attribute att = met.getAttribute(j);
                bufferRows.append(String.valueOf(dr.get(att)) + ",");
                ++j;
            }
            double lofscore = dr.get(outlierAtt);
            if (lofscore > Double.MAX_VALUE) {
                lofscore = 3.4028234663852886E38;
            }
            boolean outlier = lofscore >= lofthr;
            bufferRows.append(String.valueOf(lofscore) + "," + outlier + ")");
            if (i < numofrows - 1) {
                bufferRows.append(",");
            }
            ++i;
        }
        AnalysisLogger.getLogger().debug((Object)"LOF: Finished in retrieving and building output to write");
        String columnsNames = String.valueOf(this.FeaturesColumnNames) + "," + lofcolumn + "," + outliersColumn;
        if (bufferRows.length() > 0) {
            AnalysisLogger.getLogger().debug((Object)"Writing into DB");
            DatabaseFactory.executeSQLUpdate(DatabaseUtils.insertFromBuffer(this.OccurrencePointsClusterTable, columnsNames, bufferRows), this.dbHibConnection);
            AnalysisLogger.getLogger().debug((Object)"Finished with writing into DB");
        } else {
            AnalysisLogger.getLogger().debug((Object)"Nothing to write in the buffer");
        }
        this.status = 100.0f;
        AnalysisLogger.getLogger().debug((Object)("Status: " + this.status));
    }

    @Override
    public List<StatisticalType> getInputParameters() {
        ArrayList<StatisticalType> parameters = new ArrayList<StatisticalType>();
        ArrayList<TableTemplates> templateOccs = new ArrayList<TableTemplates>();
        templateOccs.add(TableTemplates.GENERIC);
        InputTable p1 = new InputTable(templateOccs, "PointsTable", "Table containing points or observations. Max 4000 points", "pointstable");
        ColumnTypesList p2 = new ColumnTypesList("PointsTable", "FeaturesColumnNames", "column Names for the features", false);
        PrimitiveType p0 = new PrimitiveType(String.class.getName(), null, PrimitiveTypes.STRING, "PointsClusterLabel", "table name of the resulting distribution", "Cluster_");
        ServiceType p3 = new ServiceType(ServiceParameters.RANDOMSTRING, "PointsClusterTable", "table name of the distribution", "occcluster_");
        PrimitiveType p4 = new PrimitiveType(Integer.class.getName(), null, PrimitiveTypes.NUMBER, "minimal_points_lower_bound", "locality (usually called k): minimal number of nearest neighbors", "2");
        PrimitiveType p5 = new PrimitiveType(Integer.class.getName(), null, PrimitiveTypes.NUMBER, "minimal_points_upper_bound", "maximum number of nearest neighbors to take into account for outliers evaluation", "10");
        if (LOFenumType.values().length < 2) {
            this.enuFunctions.addEnum(LOFenumType.class, "euclidian distance");
            this.enuFunctions.addEnum(LOFenumType.class, "squared distance");
            this.enuFunctions.addEnum(LOFenumType.class, "cosine distance");
            this.enuFunctions.addEnum(LOFenumType.class, "inverted cosine distance");
            this.enuFunctions.addEnum(LOFenumType.class, "angle");
        }
        PrimitiveType p6 = new PrimitiveType(Enum.class.getName(), LOFenumType.values(), PrimitiveTypes.ENUMERATED, "distance_function", "the distance function to use in the calculation", "euclidian distance");
        PrimitiveType p7 = new PrimitiveType(Integer.class.getName(), null, PrimitiveTypes.NUMBER, "lof_threshold", "the LOF score threshold over which the point is an outlier (usually 2)", "2");
        parameters.add(p1);
        parameters.add(p2);
        parameters.add(p0);
        parameters.add(p3);
        parameters.add(p4);
        parameters.add(p5);
        parameters.add(p6);
        parameters.add(p7);
        DatabaseType.addDefaultDBPars(parameters);
        return parameters;
    }

    @Override
    public String getDescription() {
        return "Local Outlier Factor (LOF). A clustering algorithm for real valued vectors that relies on Local Outlier Factor algorithm, i.e. an algorithm for finding anomalous data points by measuring the local deviation of a given data point with respect to its neighbours. A Maximum of 4000 points is allowed.";
    }

    @Override
    public String getResourceLoad() {
        if (this.resourceManager == null) {
            this.resourceManager = new ResourceFactory();
        }
        return this.resourceManager.getResourceLoad(1);
    }

    @Override
    public String getResources() {
        return ResourceFactory.getResources(100.0f);
    }

    public static void main(String[] args) throws Exception {
        long t0 = System.currentTimeMillis();
        AlgorithmConfiguration config = new AlgorithmConfiguration();
        config.setConfigPath("./cfg/");
        config.setPersistencePath("./");
        config.setParam("PointsTable", "hcaf_d");
        config.setParam("FeaturesColumnNames", "depthmin" + AlgorithmConfiguration.getListSeparator() + "depthmax" + AlgorithmConfiguration.getListSeparator() + "depthmean" + AlgorithmConfiguration.getListSeparator() + "sstanmean" + AlgorithmConfiguration.getListSeparator() + "sstmnmax" + AlgorithmConfiguration.getListSeparator() + "sstmnmin" + AlgorithmConfiguration.getListSeparator() + "sbtanmean" + AlgorithmConfiguration.getListSeparator() + "salinitymean" + AlgorithmConfiguration.getListSeparator() + "salinitymax");
        config.setParam("PointsClusterTable", "occCluster_lof");
        config.setParam("minimal_points_lower_bound", "1");
        config.setParam("minimal_points_upper_bound", "100");
        config.setParam("distance_function", "euclidean distance");
        config.setParam("DatabaseUserName", "gcube");
        config.setParam("DatabasePassword", "d4science2");
        config.setParam("DatabaseURL", "jdbc:postgresql://146.48.87.169/testdb");
        config.setParam("DatabaseDriver", "org.postgresql.Driver");
        LOF cluster = new LOF();
        cluster.setConfiguration(config);
        cluster.init();
        cluster.compute();
        System.out.println("ELAPSED " + (System.currentTimeMillis() - t0));
    }

    class LOFenum
    extends DynamicEnum {
        LOFenum() {
        }

        @Override
        public Field[] getFields() {
            Field[] fields = LOFenumType.class.getDeclaredFields();
            return fields;
        }
    }

    static enum LOFenumType {

    }
}

