/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataanalysis.ecoengine.models.cores.neuralnetworks.neurosolutions;

import org.gcube.dataanalysis.ecoengine.models.cores.neuralnetworks.neurosolutions.LineReader;
import org.gcube.dataanalysis.ecoengine.models.cores.neuralnetworks.neurosolutions.Pattern;
import org.gcube.dataanalysis.ecoengine.models.cores.neuralnetworks.neurosolutions.Randomizer;

class PatternSet {
    Pattern[] patterns;
    Pattern[] trainingpatterns;
    Pattern[] crossvalpatterns;
    Pattern[] testpatterns;
    double[] crossvaldeviations;
    double[] testdeviations;
    private Randomizer randomizer;

    public PatternSet(String sourceFile, int noofinputs, int nooftargets, double ratiotraining, double ratiocrossval, double ratiotest, Randomizer randomizer) {
        int j;
        LineReader linereader = new LineReader(sourceFile);
        int counter = 0;
        while (linereader.NextLineSplitted()) {
            try {
                int i = 0;
                while (i < noofinputs + nooftargets) {
                    double temp_double = Double.parseDouble(linereader.column[i]);
                    ++i;
                }
                ++counter;
            }
            catch (NumberFormatException i) {
                // empty catch block
            }
        }
        linereader = null;
        this.patterns = new Pattern[counter];
        double[] temp_in = new double[noofinputs];
        double[] temp_tar = new double[nooftargets];
        linereader = new LineReader(sourceFile);
        counter = 0;
        while (linereader.NextLineSplitted()) {
            try {
                int i = 0;
                while (i < noofinputs) {
                    temp_in[i] = Double.parseDouble(linereader.column[i]);
                    ++i;
                }
                i = noofinputs;
                while (i < noofinputs + nooftargets) {
                    temp_tar[i - noofinputs] = Double.parseDouble(linereader.column[i]);
                    ++i;
                }
                this.patterns[counter++] = new Pattern(temp_in, temp_tar);
            }
            catch (NumberFormatException i) {
                // empty catch block
            }
        }
        linereader = null;
        this.trainingpatterns = new Pattern[(int)Math.round((double)this.patterns.length * ratiotraining)];
        this.crossvalpatterns = new Pattern[(int)Math.round((double)this.patterns.length * ratiocrossval)];
        this.testpatterns = new Pattern[this.patterns.length - this.trainingpatterns.length - this.crossvalpatterns.length];
        int patternsnotselected = this.patterns.length;
        int i = 0;
        while (i < this.trainingpatterns.length) {
            int patterntoselect = randomizer.random.nextInt(patternsnotselected);
            counter = 0;
            j = 0;
            while (j < this.patterns.length) {
                if (!this.patterns[j].selected) {
                    if (counter == patterntoselect) {
                        this.trainingpatterns[i] = this.patterns[j];
                        this.patterns[j].selected = true;
                        --patternsnotselected;
                        break;
                    }
                    ++counter;
                }
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < this.crossvalpatterns.length) {
            int patterntoselect = randomizer.random.nextInt(patternsnotselected);
            counter = 0;
            j = 0;
            while (j < this.patterns.length) {
                if (!this.patterns[j].selected) {
                    if (counter == patterntoselect) {
                        this.crossvalpatterns[i] = this.patterns[j];
                        this.patterns[j].selected = true;
                        --patternsnotselected;
                        break;
                    }
                    ++counter;
                }
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < this.testpatterns.length) {
            int patterntoselect = randomizer.random.nextInt(patternsnotselected);
            counter = 0;
            j = 0;
            while (j < this.patterns.length) {
                if (!this.patterns[j].selected) {
                    if (counter == patterntoselect) {
                        this.testpatterns[i] = this.patterns[j];
                        this.patterns[j].selected = true;
                        --patternsnotselected;
                        break;
                    }
                    ++counter;
                }
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < this.patterns.length) {
            this.patterns[i].selected = false;
            ++i;
        }
        double[] averages = new double[nooftargets];
        this.crossvaldeviations = new double[nooftargets];
        this.testdeviations = new double[nooftargets];
        int i2 = 0;
        while (i2 < nooftargets) {
            averages[i2] = 0.0;
            int j2 = 0;
            while (j2 < this.crossvalpatterns.length) {
                int n = i2;
                averages[n] = averages[n] + this.crossvalpatterns[j2].target[i2];
                ++j2;
            }
            int n = i2;
            averages[n] = averages[n] / (double)this.crossvalpatterns.length;
            this.crossvaldeviations[i2] = 0.0;
            j2 = 0;
            while (j2 < this.crossvalpatterns.length) {
                int n2 = i2;
                this.crossvaldeviations[n2] = this.crossvaldeviations[n2] + Math.abs(this.crossvalpatterns[j2].target[i2] - averages[i2]);
                ++j2;
            }
            this.crossvaldeviations[i2] = this.crossvaldeviations[i2] * 2.0 / (double)this.crossvalpatterns.length;
            averages[i2] = 0.0;
            j2 = 0;
            while (j2 < this.testpatterns.length) {
                int n3 = i2;
                averages[n3] = averages[n3] + this.testpatterns[j2].target[i2];
                ++j2;
            }
            int n4 = i2;
            averages[n4] = averages[n4] / (double)this.testpatterns.length;
            this.testdeviations[i2] = 0.0;
            j2 = 0;
            while (j2 < this.testpatterns.length) {
                int n5 = i2;
                this.testdeviations[n5] = this.testdeviations[n5] + Math.abs(this.testpatterns[j2].target[i2] - averages[i2]);
                ++j2;
            }
            this.testdeviations[i2] = this.testdeviations[i2] * 2.0 / (double)this.testpatterns.length;
            ++i2;
        }
    }
}

