/*
 * Decompiled with CFR 0.152.
 */
package marytts.signalproc.display;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.List;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import marytts.signalproc.analysis.CepstrumSpeechAnalyser;
import marytts.signalproc.analysis.FrameBasedAnalyser;
import marytts.signalproc.analysis.LpcAnalyser;
import marytts.signalproc.analysis.ShortTermLogSpectrumAnalyser;
import marytts.signalproc.display.FunctionGraph;
import marytts.signalproc.display.FunctionGraphCustom;
import marytts.signalproc.display.Phasogram;
import marytts.signalproc.display.SignalGraph;
import marytts.signalproc.filter.FIRFilter;
import marytts.signalproc.window.HammingWindow;
import marytts.signalproc.window.RectWindow;
import marytts.signalproc.window.Window;
import marytts.util.data.BufferedDoubleDataSource;
import marytts.util.data.DoubleDataSource;
import marytts.util.math.ArrayUtils;
import marytts.util.math.FFT;
import marytts.util.math.MathUtils;
import marytts.util.string.PrintfFormat;

public class SpectrogramCustom
extends FunctionGraphCustom {
    private static final long serialVersionUID = 1L;
    public static final int DEFAULT_WINDOWSIZE = 65;
    public static final int DEFAULT_WINDOW = 1;
    public static final int DEFAULT_WINDOWSHIFT = 32;
    public static final int DEFAULT_FFTSIZE = 256;
    protected static final double PREEMPHASIS = 6.0;
    protected static final double DYNAMIC_RANGE = 40.0;
    protected static final double FREQ_MAX = 8000.0;
    protected double[] signal;
    protected int samplingRate;
    protected Window window;
    protected int windowShift;
    protected int fftSize;
    protected GraphAtCursor[] graphsAtCursor = new GraphAtCursor[]{new SpectrumAtCursor(), new PhasogramAtCursor(), new LPCAtCursor(), new CepstrumAtCursor()};
    public List<double[]> spectra;
    protected double spectra_max = 0.0;
    protected double spectra_min = 0.0;
    protected double deltaF = 0.0;
    public int spectra_indexmax = 0;
    private static int nextDependentWindowX;
    private static int nextDependentWindowY;

    public SpectrogramCustom(double[] signal, int samplingRate) {
        this(signal, samplingRate, 640, 480);
    }

    public SpectrogramCustom(double[] signal, int samplingRate, int width, int height) {
        this(signal, samplingRate, Window.get((int)1, (int)65), 32, 256, width, height);
    }

    public SpectrogramCustom(double[] signal, int samplingRate, Window window, int windowShift, int fftSize, int width, int height) {
        this.initialise(signal, samplingRate, window, windowShift, fftSize, width, height);
    }

    public SpectrogramCustom(double[][] spectrum, int samplingRate, int windowShift) {
        this.spectra = new ArrayList<double[]>();
        int i = 0;
        while (i < spectrum.length) {
            this.spectra.add(spectrum[i]);
            ++i;
        }
        this.samplingRate = samplingRate;
        this.fftSize = spectrum[0].length;
        this.dataseries = this.spectra;
        this.ymin = 0.0;
        this.ymax = this.fftSize;
        this.repaint();
        this.initialiseDependentWindows();
    }

    protected void initialise(double[] aSignal, int aSamplingRate, Window aWindow, int aWindowShift, int aFftSize, int width, int height) {
        this.signal = aSignal;
        this.samplingRate = aSamplingRate;
        this.window = aWindow;
        this.windowShift = aWindowShift;
        this.fftSize = aFftSize;
        super.initialise(width, height, 0.0, (double)aWindowShift / (double)aSamplingRate, new double[10]);
        this.update();
        this.initialiseDependentWindows();
    }

    protected void update() {
        ShortTermLogSpectrumAnalyser spectrumAnalyser = new ShortTermLogSpectrumAnalyser((DoubleDataSource)new BufferedDoubleDataSource(this.signal), this.fftSize, this.window, this.windowShift, this.samplingRate);
        this.spectra = new ArrayList<double[]>();
        this.deltaF = spectrumAnalyser.getFrequencyResolution();
        long startTime = System.currentTimeMillis();
        this.spectra_max = Double.NaN;
        this.spectra_min = Double.NaN;
        FrameBasedAnalyser.FrameAnalysisResult[] results = spectrumAnalyser.analyseAllFrames();
        int i = 0;
        while (i < results.length) {
            double[] spectrum = (double[])results[i].get();
            this.spectra.add(spectrum);
            int j = 0;
            while (j < spectrum.length) {
                double freqPreemphasis = 6.0 / Math.log(2.0) * Math.log((double)(j + 1) * this.deltaF / 1000.0);
                int n = j;
                spectrum[n] = spectrum[n] + freqPreemphasis;
                if (Double.isNaN(this.spectra_min) || spectrum[j] < this.spectra_min) {
                    this.spectra_min = spectrum[j];
                }
                if (Double.isNaN(this.spectra_max) || spectrum[j] > this.spectra_max) {
                    this.spectra_max = spectrum[j];
                }
                ++j;
            }
            ++i;
        }
        long endTime = System.currentTimeMillis();
        System.err.println("Computed " + this.spectra.size() + " spectra in " + (endTime - startTime) + " ms.");
        this.spectra_indexmax = (int)(8000.0 / this.deltaF);
        if (this.spectra_indexmax > this.fftSize / 2) {
            this.spectra_indexmax = this.fftSize / 2;
        }
        super.updateData(0.0, (double)this.windowShift / (double)this.samplingRate, new double[this.spectra.size()]);
        this.ymin = 0.0;
        this.ymax = (double)this.spectra_indexmax * this.deltaF;
        this.repaint();
    }

    protected void initialiseDependentWindows() {
        this.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
                int imageX = e.getX() - SpectrogramCustom.this.paddingLeft;
                double x = SpectrogramCustom.this.imageX2X(imageX);
                int i = 0;
                while (i < SpectrogramCustom.this.graphsAtCursor.length) {
                    if (SpectrogramCustom.this.graphsAtCursor[i].show) {
                        SpectrogramCustom.this.graphsAtCursor[i].update(x);
                    }
                    ++i;
                }
            }

            @Override
            public void mousePressed(MouseEvent e) {
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }
        });
    }

    @Override
    protected void drawData(Graphics2D g, int image_fromX, int image_toX, int image_refX, int image_refY, int startY, int image_height, double[] data, Color currentGraphColor, int currentGraphStyle, int currentDotStyle) {
        int index_fromX = this.imageX2indexX(image_fromX);
        int index_toX = this.imageX2indexX(image_toX);
        int i = index_fromX;
        while (i < index_toX) {
            int spectrumWidth = this.indexX2imageX(1);
            if (spectrumWidth == 0) {
                spectrumWidth = 1;
            }
            this.drawSpectrum(g, this.spectra.get(i), image_refX + this.indexX2imageX(i), spectrumWidth, image_refY, image_height);
            ++i;
        }
    }

    protected void drawSpectrum(Graphics2D g, double[] spectrum, int image_X, int image_width, int image_refY, int image_height) {
        int rect_height;
        double yScaleFactor = (double)image_height / (double)this.spectra_indexmax;
        if (image_width < 2) {
            image_width = 2;
        }
        if ((rect_height = (int)Math.ceil(yScaleFactor)) < 2) {
            rect_height = 2;
        }
        int i = 0;
        while (i < this.spectra_indexmax) {
            int color = spectrum.length <= i || Double.isNaN(spectrum[i]) || spectrum[i] < this.spectra_max - 40.0 ? 255 : (int)(255.0 * (this.spectra_max - spectrum[i]) / 40.0);
            g.setColor(new Color(color, color, color));
            g.fillRect(image_X, image_refY - (int)((double)i * yScaleFactor), image_width, rect_height);
            ++i;
        }
    }

    public double[] getSpectrumAtTime(double t) {
        int index = (int)((t - this.x0) / this.xStep);
        if (index < 0 || index >= this.spectra.size()) {
            return null;
        }
        return this.spectra.get(index);
    }

    @Override
    protected String getLabel(double x, double y) {
        int precisionX = -((int)(Math.log(this.getXRange()) / Math.log(10.0))) + 2;
        if (precisionX < 0) {
            precisionX = 0;
        }
        int indexX = this.X2indexX(x);
        double[] spectrum = this.spectra.get(indexX);
        int precisionY = -((int)(Math.log(this.getYRange()) / Math.log(10.0))) + 2;
        if (precisionY < 0) {
            precisionY = 0;
        }
        double E = spectrum[this.Y2indexY(y)];
        int precisionE = 1;
        return "E(" + new PrintfFormat("%." + precisionX + "f").sprintf(x) + "," + new PrintfFormat("%." + precisionY + "f").sprintf(y) + ")=" + new PrintfFormat("%." + precisionE + "f").sprintf(E);
    }

    protected int imageY2indexY(int imageY) {
        double y = this.imageY2Y(imageY);
        return this.Y2indexY(y);
    }

    protected int Y2indexY(double y) {
        assert (this.ymin == 0.0);
        return (int)((double)this.spectra_indexmax * y / this.ymax);
    }

    @Override
    protected JPanel getControls() {
        return null;
    }

    protected JPanel getControls1() {
        JPanel controls = new JPanel();
        controls.setLayout(new BoxLayout(controls, 1));
        JLabel fftLabel = new JLabel("FFT size:");
        fftLabel.setAlignmentX(0.5f);
        controls.add(fftLabel);
        int min = 5;
        int max = 13;
        int deflt = (int)(Math.log(this.fftSize) / Math.log(2.0));
        JSlider fftSizeSlider = new JSlider(1, min, max, deflt);
        fftSizeSlider.setAlignmentX(0.5f);
        fftSizeSlider.setMajorTickSpacing(1);
        fftSizeSlider.setPaintTicks(true);
        fftSizeSlider.setSnapToTicks(true);
        Hashtable<Integer, JLabel> labelTable = new Hashtable<Integer, JLabel>();
        int i = min;
        while (i <= max) {
            int twoPowI = 1 << i;
            labelTable.put(new Integer(i), new JLabel(String.valueOf(twoPowI)));
            ++i;
        }
        fftSizeSlider.setLabelTable(labelTable);
        fftSizeSlider.setPaintLabels(true);
        fftSizeSlider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent ce) {
                int logfftSize;
                int newFftSize;
                JSlider source = (JSlider)ce.getSource();
                if (!source.getValueIsAdjusting() && (newFftSize = 1 << (logfftSize = source.getValue())) != SpectrogramCustom.this.fftSize) {
                    SpectrogramCustom.this.fftSize = newFftSize;
                    SpectrogramCustom.this.window = Window.get((int)SpectrogramCustom.this.window.type(), (int)(newFftSize / 4 + 1));
                    SpectrogramCustom.this.update();
                }
            }
        });
        controls.add(fftSizeSlider);
        JLabel windowTypeLabel = new JLabel("Window type:");
        windowTypeLabel.setAlignmentX(0.5f);
        controls.add(windowTypeLabel);
        int[] windowTypes = Window.getAvailableTypes();
        Window[] windows = new Window[windowTypes.length];
        int selected = 0;
        int i2 = 0;
        while (i2 < windowTypes.length) {
            windows[i2] = Window.get((int)windowTypes[i2], (int)1);
            if (windowTypes[i2] == this.window.type()) {
                selected = i2;
            }
            ++i2;
        }
        JComboBox<Window> windowList = new JComboBox<Window>(windows);
        windowList.setAlignmentX(0.5f);
        windowList.setSelectedIndex(selected);
        windowList.setMaximumSize(windowList.getPreferredSize());
        windowList.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JComboBox cb = (JComboBox)e.getSource();
                int newWindowType = ((Window)cb.getSelectedItem()).type();
                if (newWindowType != SpectrogramCustom.this.window.type()) {
                    SpectrogramCustom.this.window = Window.get((int)newWindowType, (int)SpectrogramCustom.this.window.getLength());
                }
            }
        });
        controls.add(windowList);
        int i3 = 0;
        while (i3 < this.graphsAtCursor.length) {
            controls.add(this.graphsAtCursor[i3].getControls());
            ++i3;
        }
        return controls;
    }

    public static void main(String[] args) throws Exception {
        int i = 0;
        while (i < args.length) {
            AudioInputStream audioInputStream = AudioSystem.getAudioInputStream(new File(args[i]));
            ++i;
        }
    }

    protected void setDependentWindowLocation(JFrame jf) {
        if (nextDependentWindowX == 0 && nextDependentWindowY == 0) {
            nextDependentWindowX = this.getTopLevelAncestor().getWidth();
        }
        jf.setLocationRelativeTo((Component)((Object)this));
        jf.setLocation(nextDependentWindowX, nextDependentWindowY);
        nextDependentWindowY += jf.getHeight();
    }

    public class CepstrumAtCursor
    extends GraphAtCursor {
        protected int cepstrumCutoff;
        protected FunctionGraph cepstrumSpectrumAtCursor;

        public CepstrumAtCursor() {
            this.cepstrumCutoff = 50;
            this.cepstrumSpectrumAtCursor = null;
        }

        @Override
        public void update(double x) {
            double[] lowCepstrum;
            if (Double.isNaN(x)) {
                return;
            }
            int centerIndex = (int)(x * (double)SpectrogramCustom.this.samplingRate);
            assert (centerIndex >= 0 && centerIndex < SpectrogramCustom.this.signal.length);
            int windowLength = 1024;
            int leftIndex = centerIndex - windowLength / 2;
            if (leftIndex < 0) {
                leftIndex = 0;
            }
            double[] signalExcerpt = new double[2 * windowLength];
            new HammingWindow(windowLength).apply(SpectrogramCustom.this.signal, leftIndex, signalExcerpt, 0);
            double[] realCepstrum = CepstrumSpeechAnalyser.realCepstrum((double[])signalExcerpt);
            if (this.graph == null) {
                this.graph = new FunctionGraph(300, 200, 0.0, (double)SpectrogramCustom.this.samplingRate, realCepstrum);
            } else {
                this.graph.updateData(0.0, (double)SpectrogramCustom.this.samplingRate, realCepstrum);
            }
            super.updateGraph(this.graph, "Cepstrum at " + new PrintfFormat("%.3f").sprintf(x) + " s");
            double[] real = lowCepstrum = CepstrumSpeechAnalyser.filterLowPass((double[])realCepstrum, (int)this.cepstrumCutoff);
            double[] imag = new double[real.length];
            FFT.transform((double[])real, (double[])imag, (boolean)false);
            double[] cepstrumSpectrum = ArrayUtils.subarray((double[])real, (int)0, (int)(real.length / 2));
            if (this.cepstrumSpectrumAtCursor == null) {
                this.cepstrumSpectrumAtCursor = new FunctionGraph(300, 200, 0.0, (double)(SpectrogramCustom.this.samplingRate / real.length), cepstrumSpectrum);
            } else {
                this.cepstrumSpectrumAtCursor.updateData(0.0, (double)(SpectrogramCustom.this.samplingRate / real.length), cepstrumSpectrum);
            }
            super.updateGraph(this.cepstrumSpectrumAtCursor, "Cepstrum spectrum (cutoff " + this.cepstrumCutoff + ") at " + new PrintfFormat("%.3f").sprintf(x) + " s");
        }

        @Override
        protected JPanel createControls() {
            JPanel controls = new JPanel();
            controls.setLayout(new BoxLayout(controls, 1));
            JCheckBox checkCepstrum = new JCheckBox("Show Cepstrum");
            checkCepstrum.setAlignmentX(0.5f);
            checkCepstrum.setSelected(this.show);
            checkCepstrum.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    if (e.getStateChange() == 2) {
                        CepstrumAtCursor.this.show = false;
                        if (CepstrumAtCursor.this.graph != null) {
                            CepstrumAtCursor.this.graph.getTopLevelAncestor().setVisible(false);
                        }
                        if (CepstrumAtCursor.this.cepstrumSpectrumAtCursor != null) {
                            CepstrumAtCursor.this.cepstrumSpectrumAtCursor.getTopLevelAncestor().setVisible(false);
                        }
                    } else if (e.getStateChange() == 1) {
                        CepstrumAtCursor.this.show = true;
                        CepstrumAtCursor.this.update(((CepstrumAtCursor)CepstrumAtCursor.this).SpectrogramCustom.this.positionCursor.x);
                        if (CepstrumAtCursor.this.graph != null) {
                            CepstrumAtCursor.this.graph.getTopLevelAncestor().setVisible(true);
                        }
                        if (CepstrumAtCursor.this.cepstrumSpectrumAtCursor != null) {
                            CepstrumAtCursor.this.cepstrumSpectrumAtCursor.getTopLevelAncestor().setVisible(true);
                        }
                    }
                }
            });
            controls.add(checkCepstrum);
            JLabel cepstrumLabel = new JLabel("Cepstrum cutoff:");
            cepstrumLabel.setAlignmentX(0.5f);
            controls.add(cepstrumLabel);
            int min = 1;
            int max = 256;
            JSlider cepstrumSlider = new JSlider(0, min, max, this.cepstrumCutoff);
            cepstrumSlider.setAlignmentX(0.5f);
            cepstrumSlider.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent ce) {
                    JSlider source = (JSlider)ce.getSource();
                    if (!source.getValueIsAdjusting()) {
                        CepstrumAtCursor.this.cepstrumCutoff = source.getValue();
                        System.err.println("Adjusted cepstrum cutoff to " + CepstrumAtCursor.this.cepstrumCutoff);
                        if (CepstrumAtCursor.this.show) {
                            CepstrumAtCursor.this.update(((CepstrumAtCursor)CepstrumAtCursor.this).SpectrogramCustom.this.positionCursor.x);
                        }
                    }
                }
            });
            controls.add(cepstrumSlider);
            return controls;
        }
    }

    public abstract class GraphAtCursor {
        private JPanel controls;
        protected FunctionGraph graph;
        protected boolean show = false;

        public abstract void update(double var1);

        public JPanel getControls() {
            if (this.controls == null) {
                this.controls = this.createControls();
            }
            return this.controls;
        }

        protected abstract JPanel createControls();

        protected void updateGraph(FunctionGraph someGraph, String title) {
            if (someGraph.getParent() == null) {
                JFrame jf = someGraph.showInJFrame(title, 400, 250, false, false);
                SpectrogramCustom.this.setDependentWindowLocation(jf);
            } else {
                JFrame jf = (JFrame)SwingUtilities.getWindowAncestor((Component)someGraph);
                jf.setTitle(title);
                jf.setVisible(true);
                someGraph.repaint();
            }
        }
    }

    public class LPCAtCursor
    extends GraphAtCursor {
        protected int lpcOrder = 50;
        protected SignalGraph lpcResidueAtCursor = null;

        @Override
        public void update(double x) {
            if (Double.isNaN(x)) {
                return;
            }
            int centerIndex = (int)(x * (double)SpectrogramCustom.this.samplingRate);
            assert (centerIndex >= 0 && centerIndex < SpectrogramCustom.this.signal.length);
            int windowLength = 1024;
            int leftIndex = centerIndex - windowLength / 2;
            if (leftIndex < 0) {
                leftIndex = 0;
            }
            double[] signalExcerpt = new HammingWindow(windowLength).apply(SpectrogramCustom.this.signal, leftIndex);
            LpcAnalyser.LpCoeffs lpc = LpcAnalyser.calcLPC((double[])signalExcerpt, (int)this.lpcOrder);
            double[] coeffs = lpc.getOneMinusA();
            double g_db = 2.0 * MathUtils.db((double)lpc.getGain());
            double[] fftCoeffs = new double[windowLength];
            System.arraycopy(coeffs, 0, fftCoeffs, 0, coeffs.length);
            double[] lpcSpectrum = FFT.computeLogPowerSpectrum((double[])fftCoeffs);
            int i = 0;
            while (i < lpcSpectrum.length) {
                lpcSpectrum[i] = -lpcSpectrum[i] + g_db;
                ++i;
            }
            if (this.graph == null) {
                this.graph = new FunctionGraph(300, 200, 0.0, (double)(SpectrogramCustom.this.samplingRate / windowLength), lpcSpectrum);
            } else {
                this.graph.updateData(0.0, (double)(SpectrogramCustom.this.samplingRate / windowLength), lpcSpectrum);
            }
            this.updateGraph(this.graph, "LPC spectrum (order " + this.lpcOrder + ") at " + new PrintfFormat("%.3f").sprintf(x) + " s");
            FIRFilter whiteningFilter = new FIRFilter(coeffs);
            double[] signalExcerpt2 = new RectWindow(this.lpcOrder + windowLength).apply(SpectrogramCustom.this.signal, leftIndex - this.lpcOrder);
            double[] residue = whiteningFilter.apply(signalExcerpt2);
            double[] usableSignal = ArrayUtils.subarray((double[])signalExcerpt2, (int)this.lpcOrder, (int)windowLength);
            double[] usableResidue = ArrayUtils.subarray((double[])residue, (int)this.lpcOrder, (int)windowLength);
            double predictionGain = MathUtils.db((double)(MathUtils.sum((double[])MathUtils.multiply((double[])usableSignal, (double[])usableSignal)) / MathUtils.sum((double[])MathUtils.multiply((double[])usableResidue, (double[])usableResidue))));
            System.err.println("LPC prediction gain: " + predictionGain + " dB");
            if (this.lpcResidueAtCursor == null) {
                this.lpcResidueAtCursor = new SignalGraph(usableResidue, SpectrogramCustom.this.samplingRate, 300, 200);
            } else {
                this.lpcResidueAtCursor.update(usableResidue, SpectrogramCustom.this.samplingRate);
            }
            super.updateGraph((FunctionGraph)this.lpcResidueAtCursor, "LPC residue at " + new PrintfFormat("%.3f").sprintf(x) + " s");
        }

        @Override
        protected JPanel createControls() {
            JPanel controls = new JPanel();
            controls.setLayout(new BoxLayout(controls, 1));
            JCheckBox checkLPC = new JCheckBox("Show LPC");
            checkLPC.setAlignmentX(0.5f);
            checkLPC.setSelected(this.show);
            checkLPC.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    if (e.getStateChange() == 2) {
                        LPCAtCursor.this.show = false;
                        if (LPCAtCursor.this.graph != null) {
                            LPCAtCursor.this.graph.getTopLevelAncestor().setVisible(false);
                        }
                        if (LPCAtCursor.this.lpcResidueAtCursor != null) {
                            LPCAtCursor.this.lpcResidueAtCursor.getTopLevelAncestor().setVisible(false);
                        }
                    } else if (e.getStateChange() == 1) {
                        LPCAtCursor.this.show = true;
                        LPCAtCursor.this.update(((LPCAtCursor)LPCAtCursor.this).SpectrogramCustom.this.positionCursor.x);
                        if (LPCAtCursor.this.graph != null) {
                            LPCAtCursor.this.graph.getTopLevelAncestor().setVisible(true);
                        }
                        if (LPCAtCursor.this.lpcResidueAtCursor != null) {
                            LPCAtCursor.this.lpcResidueAtCursor.getTopLevelAncestor().setVisible(true);
                        }
                    }
                }
            });
            controls.add(checkLPC);
            JLabel lpcLabel = new JLabel("LPC order:");
            lpcLabel.setAlignmentX(0.5f);
            controls.add(lpcLabel);
            int min = 1;
            int max = 100;
            JSlider lpcSlider = new JSlider(0, min, max, this.lpcOrder);
            lpcSlider.setAlignmentX(0.5f);
            lpcSlider.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent ce) {
                    JSlider source = (JSlider)ce.getSource();
                    if (!source.getValueIsAdjusting()) {
                        LPCAtCursor.this.lpcOrder = source.getValue();
                        System.err.println("Adjusted lpc order to " + LPCAtCursor.this.lpcOrder);
                        if (LPCAtCursor.this.show) {
                            LPCAtCursor.this.update(((LPCAtCursor)LPCAtCursor.this).SpectrogramCustom.this.positionCursor.x);
                        }
                    }
                }
            });
            controls.add(lpcSlider);
            return controls;
        }
    }

    public class PhasogramAtCursor
    extends GraphAtCursor {
        @Override
        public void update(double x) {
            int len;
            double[] signalExcerpt;
            if (Double.isNaN(x)) {
                return;
            }
            int centerIndex = (int)(x * (double)SpectrogramCustom.this.samplingRate);
            assert (centerIndex >= 0 && centerIndex < SpectrogramCustom.this.signal.length);
            int halfWindowLength = SpectrogramCustom.this.samplingRate / 200;
            if (this.graph == null) {
                signalExcerpt = new double[2 * halfWindowLength + 2048];
            } else {
                assert (this.graph instanceof Phasogram);
                signalExcerpt = ((Phasogram)this.graph).signal;
            }
            int leftIndex = centerIndex - halfWindowLength;
            if (leftIndex < 0) {
                leftIndex = 0;
            }
            if (leftIndex + (len = signalExcerpt.length) >= SpectrogramCustom.this.signal.length) {
                len = SpectrogramCustom.this.signal.length - leftIndex;
            }
            System.arraycopy(SpectrogramCustom.this.signal, leftIndex, signalExcerpt, 0, len);
            if (len < signalExcerpt.length) {
                Arrays.fill(signalExcerpt, len, signalExcerpt.length, 0.0);
            }
            if (this.graph == null) {
                this.graph = new Phasogram(signalExcerpt, SpectrogramCustom.this.samplingRate, 300, 200);
            } else {
                ((Phasogram)this.graph).update();
            }
            super.updateGraph(this.graph, "Phasogram at " + new PrintfFormat("%.3f").sprintf(x) + " s");
        }

        @Override
        protected JPanel createControls() {
            JPanel controls = new JPanel();
            JCheckBox checkPhasogram = new JCheckBox("Show phasogram");
            checkPhasogram.setAlignmentX(0.5f);
            checkPhasogram.setSelected(this.show);
            checkPhasogram.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    if (e.getStateChange() == 2) {
                        PhasogramAtCursor.this.show = false;
                        if (PhasogramAtCursor.this.graph != null) {
                            PhasogramAtCursor.this.graph.getTopLevelAncestor().setVisible(false);
                        }
                    } else if (e.getStateChange() == 1) {
                        PhasogramAtCursor.this.show = true;
                        PhasogramAtCursor.this.update(((PhasogramAtCursor)PhasogramAtCursor.this).SpectrogramCustom.this.positionCursor.x);
                        if (PhasogramAtCursor.this.graph != null) {
                            PhasogramAtCursor.this.graph.getTopLevelAncestor().setVisible(true);
                        }
                    }
                }
            });
            controls.add(checkPhasogram);
            return controls;
        }
    }

    public class SpectrumAtCursor
    extends GraphAtCursor {
        @Override
        public void update(double x) {
            if (Double.isNaN(x)) {
                return;
            }
            int centerIndex = (int)(x * (double)SpectrogramCustom.this.samplingRate);
            assert (centerIndex >= 0 && centerIndex < SpectrogramCustom.this.signal.length);
            int windowLength = 1024;
            int leftIndex = centerIndex - windowLength / 2;
            if (leftIndex < 0) {
                leftIndex = 0;
            }
            double[] signalExcerpt = new HammingWindow(windowLength).apply(SpectrogramCustom.this.signal, leftIndex);
            double[] spectrum = FFT.computeLogPowerSpectrum((double[])signalExcerpt);
            if (this.graph == null) {
                this.graph = new FunctionGraph(300, 200, 0.0, (double)(SpectrogramCustom.this.samplingRate / windowLength), spectrum);
            } else {
                this.graph.updateData(0.0, (double)(SpectrogramCustom.this.samplingRate / windowLength), spectrum);
            }
            super.updateGraph(this.graph, "Spectrum at " + new PrintfFormat("%.3f").sprintf(x) + " s");
        }

        @Override
        protected JPanel createControls() {
            JPanel controls = new JPanel();
            JCheckBox checkSpectrum = new JCheckBox("Show spectrum");
            checkSpectrum.setAlignmentX(0.5f);
            checkSpectrum.setSelected(this.show);
            checkSpectrum.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    if (e.getStateChange() == 2) {
                        SpectrumAtCursor.this.show = false;
                        if (SpectrumAtCursor.this.graph != null) {
                            SpectrumAtCursor.this.graph.getTopLevelAncestor().setVisible(false);
                        }
                    } else if (e.getStateChange() == 1) {
                        SpectrumAtCursor.this.show = true;
                        SpectrumAtCursor.this.update(((SpectrumAtCursor)SpectrumAtCursor.this).SpectrogramCustom.this.positionCursor.x);
                        if (SpectrumAtCursor.this.graph != null) {
                            SpectrumAtCursor.this.graph.getTopLevelAncestor().setVisible(true);
                        }
                    }
                }
            });
            controls.add(checkSpectrum);
            return controls;
        }
    }
}

