/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataanalysis.ecoengine.signals.ssa;

import Jama.EigenvalueDecomposition;
import Jama.Matrix;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.gcube.contentmanagement.lexicalmatcher.utils.AnalysisLogger;
import org.gcube.dataanalysis.ecoengine.signals.ssa.SSADataset;
import org.gcube.dataanalysis.ecoengine.signals.ssa.SSAGroupList;
import org.gcube.dataanalysis.ecoengine.signals.ssa.SSAUnselectList;

public class SingularSpectrumAnalysis {
    public static void inclosure(SSADataset data) {
        int L = data.getL();
        int K = data.getTimeSeries().size() - L + 1;
        double[][] inclosureMatrix = new double[L][K];
        int i = 1;
        while (i <= K) {
            int num = 0;
            int j = i - 1;
            while (j <= i + L - 2) {
                inclosureMatrix[num][i - 1] = data.getTimeSeries().get(j);
                ++num;
                ++j;
            }
            ++i;
        }
        data.setInclosureMatrix(inclosureMatrix);
    }

    public static void singularDecomposition(SSADataset data) {
        double[][] inclosureMatrix = data.getInclosureMatrix();
        double[][] transp = SingularSpectrumAnalysis.transpositionMatrix(inclosureMatrix);
        Matrix S = new Matrix(inclosureMatrix).times(new Matrix(transp));
        EigenvalueDecomposition decomposition = new EigenvalueDecomposition(S);
        Matrix eigenvalue = decomposition.getD();
        Matrix eigenvec = decomposition.getV();
        ArrayList<Double> eigenvalueList = new ArrayList<Double>();
        int i = 0;
        while (i < eigenvalue.getRowDimension()) {
            int j = 0;
            while (j < eigenvalue.getRowDimension()) {
                if (i == j) {
                    eigenvalueList.add(eigenvalue.get(i, j));
                }
                ++j;
            }
            ++i;
        }
        Comparator comparator = Collections.reverseOrder();
        Collections.sort(eigenvalueList, comparator);
        data.setEigenValueList(eigenvalueList);
        double sumValueList = 0.0;
        int i2 = 0;
        while (i2 < data.getEigenValueList().size()) {
            sumValueList += data.getEigenValueList().get(i2).doubleValue();
            ++i2;
        }
        ArrayList<Double> percentList = new ArrayList<Double>();
        ArrayList<Double> accruePercentList = new ArrayList<Double>();
        double accruePercent = 0.0;
        int i3 = 0;
        while (i3 < data.getEigenValueList().size()) {
            percentList.add(data.getEigenValueList().get(i3) / sumValueList * 100.0);
            accruePercentList.add(accruePercent += ((Double)percentList.get(i3)).doubleValue());
            ++i3;
        }
        data.setAccruePercentList(accruePercentList);
        data.setPercentList(percentList);
        int size = eigenvec.getColumnDimension();
        Matrix[] V = new Matrix[size];
        Matrix[] U = new Matrix[size];
        Matrix[] X = new Matrix[size];
        ArrayList listSeries = new ArrayList();
        int j = 0;
        while (j < eigenvec.getColumnDimension()) {
            double[][] uVec = new double[size][1];
            ArrayList<Double> series = new ArrayList<Double>();
            int k = 0;
            while (k < eigenvec.getRowDimension()) {
                uVec[k][0] = eigenvec.get(k, eigenvec.getColumnDimension() - j - 1);
                series.add(uVec[k][0]);
                ++k;
            }
            listSeries.add(series);
            U[j] = new Matrix(uVec);
            V[j] = new Matrix(transp).times(U[j]);
            ++j;
        }
        data.setEigenVectors(listSeries);
        int i4 = 0;
        while (i4 < V.length) {
            int j2 = 0;
            while (j2 < V[i4].getRowDimension()) {
                int k = 0;
                while (k < V[i4].getColumnDimension()) {
                    double val = V[i4].get(j2, k) / Math.sqrt((Double)eigenvalueList.get(i4));
                    V[i4].set(j2, k, val);
                    ++k;
                }
                ++j2;
            }
            ++i4;
        }
        data.setV(V);
        i4 = 0;
        while (i4 < X.length) {
            X[i4] = U[i4].times(V[i4].transpose());
            int j3 = 0;
            while (j3 < X[i4].getRowDimension()) {
                int k = 0;
                while (k < X[i4].getColumnDimension()) {
                    double val = X[i4].get(j3, k) * Math.sqrt((Double)eigenvalueList.get(i4));
                    X[i4].set(j3, k, val);
                    ++k;
                }
                ++j3;
            }
            ++i4;
        }
        data.setX(X);
    }

    public static void grouping(List<SSAGroupList> model, SSADataset data) {
        Matrix[] grouX = new Matrix[model.size()];
        int i = 0;
        while (i < model.size()) {
            SSAGroupList obj = model.get(i);
            int j = 0;
            while (j < obj.getGroups().size()) {
                SSAUnselectList unselect = (SSAUnselectList)obj.getGroups().get(j);
                grouX[i] = j == 0 ? data.getX()[unselect.getIndex()] : grouX[i].plus(data.getX()[unselect.getIndex()]);
                ++j;
            }
            ++i;
        }
        data.setGroupX(grouX);
    }

    public static void diagonalAveraging(SSADataset data) {
        ArrayList list = new ArrayList();
        int i = 0;
        while (i < data.getGroupX().length) {
            int K;
            int L;
            if (data.getGroupX()[i].getRowDimension() < data.getGroupX()[i].getColumnDimension()) {
                L = data.getGroupX()[i].getRowDimension();
                K = data.getGroupX()[i].getColumnDimension();
            } else {
                K = data.getGroupX()[i].getRowDimension();
                L = data.getGroupX()[i].getColumnDimension();
            }
            int N = data.getGroupX()[i].getRowDimension() + data.getGroupX()[i].getColumnDimension() - 1;
            ArrayList<Double> series = new ArrayList<Double>();
            int k = 0;
            while (k <= N - 1) {
                int m;
                double element = 0.0;
                if (k >= 0 && k < L - 1) {
                    m = 0;
                    while (m <= k) {
                        if (data.getGroupX()[i].getRowDimension() <= data.getGroupX()[i].getColumnDimension()) {
                            element += data.getGroupX()[i].get(m, k - m);
                        } else if (data.getGroupX()[i].getRowDimension() > data.getGroupX()[i].getColumnDimension()) {
                            element += data.getGroupX()[i].get(k - m, m);
                        }
                        ++m;
                    }
                    series.add(element *= 1.0 / (double)(k + 1));
                }
                if (k >= L - 1 && k < K - 1) {
                    m = 0;
                    while (m <= L - 2) {
                        if (data.getGroupX()[i].getRowDimension() <= data.getGroupX()[i].getColumnDimension()) {
                            element += data.getGroupX()[i].get(m, k - m);
                        } else if (data.getGroupX()[i].getRowDimension() > data.getGroupX()[i].getColumnDimension()) {
                            element += data.getGroupX()[i].get(k - m, m);
                        }
                        ++m;
                    }
                    series.add(element *= 1.0 / (double)L);
                }
                if (k >= K - 1 && k < N) {
                    m = k - K + 1;
                    while (m <= N - K) {
                        if (data.getGroupX()[i].getRowDimension() <= data.getGroupX()[i].getColumnDimension()) {
                            element += data.getGroupX()[i].get(m, k - m);
                        } else if (data.getGroupX()[i].getRowDimension() > data.getGroupX()[i].getColumnDimension()) {
                            element += data.getGroupX()[i].get(k - m, m);
                        }
                        ++m;
                    }
                    series.add(element *= 1.0 / (double)(N - k));
                }
                ++k;
            }
            list.add(series);
            ++i;
        }
        ArrayList<Double> reconstructionList = new ArrayList<Double>();
        int j = 0;
        while (j < ((List)list.get(0)).size()) {
            double sum = 0.0;
            int i2 = 0;
            while (i2 < list.size()) {
                sum += ((Double)((List)list.get(i2)).get(j)).doubleValue();
                ++i2;
            }
            reconstructionList.add(sum);
            ++j;
        }
        data.setReconstructionList(reconstructionList);
    }

    private static double[][] transpositionMatrix(double[][] matrix) {
        AnalysisLogger.getLogger().debug((Object)("SSA->Building a matrix with dimensions: " + matrix[0].length + " X " + matrix.length));
        double[][] transpMatrix = new double[matrix[0].length][matrix.length];
        int i = 0;
        while (i < matrix.length) {
            int j = 0;
            while (j < matrix[i].length) {
                transpMatrix[j][i] = matrix[i][j];
                ++j;
            }
            ++i;
        }
        return transpMatrix;
    }

    public static void setMovingAverage(SSADataset data) {
        ArrayList<Double> SMA = new ArrayList<Double>();
        int m = data.getTimeSeries().size() - data.getL() + 1;
        int i = 0;
        while (i < data.getL()) {
            double sum = 0.0;
            double avg = 0.0;
            int j = i;
            while (j < m + i) {
                sum += data.getTimeSeries().get(j).doubleValue();
                ++j;
            }
            avg = sum / (double)m;
            SMA.add(avg);
            data.setSMA(SMA);
            ++i;
        }
    }

    public static void averagedCovariance(SSADataset data) {
        double K = data.getTimeSeries().size() - data.getL() + 1;
        ArrayList<Double> covarianceList = new ArrayList<Double>();
        double[][] transp = SingularSpectrumAnalysis.transpositionMatrix(data.getInclosureMatrix());
        Matrix S = new Matrix(data.getInclosureMatrix()).times(new Matrix(transp));
        S = S.times(1.0 / K);
        int size = S.getColumnDimension();
        int N = size + size - 1;
        int k = 0;
        while (k < N) {
            if (k % 2 == 0) {
                int m;
                int n;
                double avg;
                if (k >= 0 && k < size) {
                    avg = 0.0;
                    n = 0;
                    m = 0;
                    while (m <= k) {
                        avg += S.get(m, size - 1 - (k - m));
                        ++n;
                        ++m;
                    }
                    covarianceList.add(avg /= (double)n);
                }
                if (k >= size && k < N) {
                    avg = 0.0;
                    n = 0;
                    m = k - size + 1;
                    while (m <= N - size) {
                        avg += S.get(m, size - 1 - (k - m));
                        ++n;
                        ++m;
                    }
                    covarianceList.add(avg /= (double)n);
                }
            }
            ++k;
        }
        data.setCov(covarianceList);
    }

    public static void functionEigenValue(SSADataset data) {
        ArrayList<Double> lgList = new ArrayList<Double>();
        ArrayList<Double> sqrtList = new ArrayList<Double>();
        int i = 0;
        while (i < data.getEigenValueList().size()) {
            lgList.add(Math.log(data.getEigenValueList().get(i)));
            sqrtList.add(Math.sqrt(data.getEigenValueList().get(i)));
            ++i;
        }
        data.setLgEigenValue(lgList);
        data.setSqrtEigenValue(sqrtList);
    }

    public static void forecast(SSADataset data, int nPointsToForecast, boolean reconstructedSignal) {
        int nTotalEigenV;
        if (nPointsToForecast == 0) {
            data.setForecastList(data.getReconstructionList());
            return;
        }
        int bestEigenVectors = nTotalEigenV = data.getPercentList().size();
        int i = 0;
        while (i < nTotalEigenV) {
            double currentperc = data.getPercentList().get(i);
            if (currentperc < data.getPercThreshold()) {
                bestEigenVectors = i + 1;
                break;
            }
            ++i;
        }
        List eigenvectors = data.getEigenVectors().subList(0, bestEigenVectors);
        int L = data.getL();
        int lastcoordinate = L - 1;
        AnalysisLogger.getLogger().debug((Object)("SSA: value for L: " + L));
        int nEigenVectors = eigenvectors.size();
        AnalysisLogger.getLogger().debug((Object)("Number of Selected Eigenvectors For Reconstruction: " + nEigenVectors));
        double[] p = new double[nEigenVectors];
        int i2 = 0;
        while (i2 < nEigenVectors) {
            p[i2] = (Double)((List)eigenvectors.get(i2)).get(lastcoordinate);
            ++i2;
        }
        double[][] P = new double[nEigenVectors][L - 1];
        int i3 = 0;
        while (i3 < nEigenVectors) {
            List evec = (List)eigenvectors.get(i3);
            int j = 0;
            while (j < L - 1) {
                P[i3][j] = (Double)evec.get(j);
                ++j;
            }
            ++i3;
        }
        double ni_sqr = 0.0;
        int i4 = 0;
        while (i4 < nEigenVectors) {
            ni_sqr += p[i4] * p[i4];
            ++i4;
        }
        double[] R = new double[L - 1];
        int j = 0;
        while (j < L - 1) {
            double rj = 0.0;
            int i5 = 0;
            while (i5 < nEigenVectors) {
                rj += p[i5] * P[i5][j];
                ++i5;
            }
            R[j] = rj / (1.0 - ni_sqr);
            ++j;
        }
        int M = nPointsToForecast;
        ArrayList<Double> y = new ArrayList<Double>();
        int signalSize = data.getTimeSeries().size();
        int j2 = 0;
        while (j2 < signalSize + M) {
            if (j2 < signalSize) {
                if (reconstructedSignal) {
                    y.add(j2, data.getReconstructionList().get(j2));
                } else {
                    y.add(j2, data.getTimeSeries().get(j2));
                }
            } else {
                double sumprec = 0.0;
                int g = 0;
                while (g < L - 1) {
                    double ag = R[L - 2 - g];
                    double yj_g = (Double)y.get(j2 - g - 1);
                    sumprec += ag * yj_g;
                    ++g;
                }
                y.add(j2, sumprec);
            }
            ++j2;
        }
        AnalysisLogger.getLogger().debug((Object)("Length of the original signal: " + signalSize + " Length of the reconstructed signal: " + y.size()));
        data.setForecastList(y);
    }
}

