/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataanalysis.ecoengine.processing.factories;

import java.util.ArrayList;
import java.util.List;
import org.gcube.dataanalysis.ecoengine.configuration.AlgorithmConfiguration;
import org.gcube.dataanalysis.ecoengine.datatypes.StatisticalType;
import org.gcube.dataanalysis.ecoengine.interfaces.ComputationalAgent;
import org.gcube.dataanalysis.ecoengine.interfaces.Transducerer;
import org.gcube.dataanalysis.ecoengine.processing.factories.DynamicTransducerersFactory;
import org.gcube.dataanalysis.ecoengine.processing.factories.GeneratorsFactory;
import org.gcube.dataanalysis.ecoengine.processing.factories.ProcessorsFactory;

public class TransducerersFactory {
    public static Transducerer getTransducerer(AlgorithmConfiguration config) throws Exception {
        ComputationalAgent ca = ProcessorsFactory.getProcessor(config, String.valueOf(config.getConfigPath()) + AlgorithmConfiguration.transducererFile);
        if (ca != null) {
            ca.setConfiguration(config);
            return (Transducerer)ca;
        }
        return DynamicTransducerersFactory.getTransducerer(config);
    }

    public static List<String> getAllTransducerers(AlgorithmConfiguration config) throws Exception {
        List<String> trans = ProcessorsFactory.getClasses(String.valueOf(config.getConfigPath()) + AlgorithmConfiguration.transducererFile);
        List<String> dtrans = DynamicTransducerersFactory.getTransducerersNames(config);
        trans.addAll(dtrans);
        return trans;
    }

    public static List<StatisticalType> getTransducerParameters(AlgorithmConfiguration config, String algorithmName) throws Exception {
        List<StatisticalType> inputs = ProcessorsFactory.getParameters(String.valueOf(config.getConfigPath()) + AlgorithmConfiguration.transducererFile, algorithmName);
        if (inputs != null) {
            return inputs;
        }
        inputs = DynamicTransducerersFactory.getTransducerer(config).getInputParameters();
        return inputs;
    }

    public static String getDescription(AlgorithmConfiguration config, String algorithmName) throws Exception {
        String input = ProcessorsFactory.getDescription(String.valueOf(config.getConfigPath()) + AlgorithmConfiguration.transducererFile, algorithmName);
        if (input != null) {
            return input;
        }
        input = DynamicTransducerersFactory.getTransducerer(config).getDescription();
        return input;
    }

    public static List<ComputationalAgent> getTransducerers(AlgorithmConfiguration config) throws Exception {
        ArrayList<ComputationalAgent> trans = new ArrayList<ComputationalAgent>();
        trans.add(TransducerersFactory.getTransducerer(config));
        ProcessorsFactory.addAgent2List(trans, GeneratorsFactory.getGenerator(config));
        Transducerer dynamicTransducer = DynamicTransducerersFactory.getTransducerer(config);
        if (dynamicTransducer != null) {
            trans.add(dynamicTransducer);
        }
        return trans;
    }
}

