/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataanalysis.ecoengine.evaluation;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import org.gcube.contentmanagement.graphtools.utils.MathFunctions;
import org.gcube.contentmanagement.lexicalmatcher.utils.AnalysisLogger;
import org.gcube.dataanalysis.ecoengine.datatypes.ColumnType;
import org.gcube.dataanalysis.ecoengine.datatypes.DatabaseType;
import org.gcube.dataanalysis.ecoengine.datatypes.InputTable;
import org.gcube.dataanalysis.ecoengine.datatypes.PrimitiveType;
import org.gcube.dataanalysis.ecoengine.datatypes.StatisticalType;
import org.gcube.dataanalysis.ecoengine.datatypes.enumtypes.PrimitiveTypes;
import org.gcube.dataanalysis.ecoengine.datatypes.enumtypes.TableTemplates;
import org.gcube.dataanalysis.ecoengine.interfaces.DataAnalysis;
import org.gcube.dataanalysis.ecoengine.utils.DatabaseFactory;

public class DiscrepancyAnalysis
extends DataAnalysis {
    static String discrepancyQuery = "select * from (select distinct a.%1$s as csquareone,b.%2$s as csquaretwo,a.%3$s as firstprob,b.%4$s as secondprob from (select %1$s , avg(%3$s) as %3$s from (select distinct * from %5$s order by %1$s limit %7$s) as aa group by %1$s) as a left join (select %2$s , avg(%4$s) as %4$s from (select distinct * from %6$s order by %2$s limit %7$s) as aa group by %2$s) as b on a.%1$s=b.%2$s) as sel where firstprob<>secondprob";
    static String getNumberOfElementsQuery = "select count(*) from %1$s";
    private static int minElements = 100;
    private static int maxElements = 30000;
    float threshold = 0.1f;
    String configPath = "./cfg/";
    List<Float> errors;
    double mean;
    double variance;
    int numberoferrors;
    int numberofvectors;
    float maxerror;
    String maxdiscrepancyPoint;
    private LinkedHashMap<String, String> output;
    long numHigher = 0L;
    long numLower = 0L;

    @Override
    public List<StatisticalType> getInputParameters() {
        ArrayList<StatisticalType> parameters = new ArrayList<StatisticalType>();
        ArrayList<TableTemplates> templates = new ArrayList<TableTemplates>();
        templates.add(TableTemplates.HSPEC);
        templates.add(TableTemplates.TRAININGSET);
        templates.add(TableTemplates.TESTSET);
        InputTable p1 = new InputTable(templates, "FirstTable", "First Table");
        InputTable p2 = new InputTable(templates, "SecondTable", "Second Table");
        ColumnType p3 = new ColumnType("FirstTable", "FirstTableCsquareColumn", "the csquares column name in the first table", "csquarecode", false);
        ColumnType p4 = new ColumnType("SecondTable", "SecondTableCsquareColumn", "the csquares column name in the second table", "csquarecode", false);
        ColumnType p5 = new ColumnType("FirstTable", "FirstTableProbabilityColumn", "the probability column in the first table", "probability", false);
        ColumnType p13 = new ColumnType("SecondTable", "SecondTableProbabilityColumn", "the probability column in the second table", "probability", false);
        PrimitiveType p6 = new PrimitiveType(Float.class.getName(), null, PrimitiveTypes.NUMBER, "ComparisonThreshold", "the comparison threshold", "0.1");
        PrimitiveType p7 = new PrimitiveType(Integer.class.getName(), null, PrimitiveTypes.NUMBER, "MaxSamples", "the comparison threshold", "10000");
        parameters.add(p1);
        parameters.add(p2);
        parameters.add(p3);
        parameters.add(p4);
        parameters.add(p5);
        parameters.add(p13);
        parameters.add(p6);
        parameters.add(p7);
        DatabaseType.addDefaultDBPars(parameters);
        return parameters;
    }

    @Override
    public LinkedHashMap<String, String> analyze() throws Exception {
        String FirstTableCsquareColumn = this.config.getParam("FirstTableCsquareColumn");
        String SecondTableCsquareColumn = this.config.getParam("SecondTableCsquareColumn");
        String FirstTableProbabilityColumn = this.config.getParam("FirstTableProbabilityColumn");
        String SecondTableProbabilityColumn = this.config.getParam("SecondTableProbabilityColumn");
        String FirstTable = this.config.getParam("FirstTable");
        String SecondTable = this.config.getParam("SecondTable");
        String maxSamples = this.config.getParam("MaxSamples");
        int maxCompElements = maxElements;
        if (maxSamples != null && maxSamples.length() > 0) {
            int maxx = Integer.parseInt(maxSamples);
            maxCompElements = maxx != 0 ? maxx : Integer.MAX_VALUE;
        }
        List<Object> takeNPoints = DatabaseFactory.executeSQLQuery(String.format(getNumberOfElementsQuery, FirstTable), this.connection);
        List<Object> takeMPoints = DatabaseFactory.executeSQLQuery(String.format(getNumberOfElementsQuery, SecondTable), this.connection);
        int nPoints = Integer.parseInt("" + takeNPoints.get(0));
        int mPoints = Integer.parseInt("" + takeMPoints.get(0));
        this.numberofvectors = Math.max(nPoints, mPoints);
        if (FirstTable.equals(SecondTable)) {
            this.output = new LinkedHashMap();
            this.output.put("MEAN", "0.0");
            this.output.put("VARIANCE", "0.0");
            this.output.put("NUMBER_OF_ERRORS", "0");
            this.output.put("NUMBER_OF_COMPARISONS", "" + this.numberofvectors);
            this.output.put("ACCURACY", "100.0");
            this.output.put("MAXIMUM_ERROR", "-");
            this.output.put("MAXIMUM_ERROR_POINT", "-");
            return this.output;
        }
        int nelements = nPoints;
        AnalysisLogger.getLogger().trace((Object)("Number Of Elements to take: " + nelements));
        String query = String.format(discrepancyQuery, FirstTableCsquareColumn, SecondTableCsquareColumn, FirstTableProbabilityColumn, SecondTableProbabilityColumn, FirstTable, SecondTable, "" + nelements);
        AnalysisLogger.getLogger().debug((Object)("Discrepancy Calculation - Query to perform :" + query));
        List<Object> takePoints = DatabaseFactory.executeSQLQuery(query, this.connection);
        this.processedRecords = 0;
        if (takePoints != null) {
            this.processedRecords = takePoints.size();
        }
        this.threshold = Float.parseFloat(this.config.getParam("ComparisonThreshold"));
        this.analyzeCompareList(takePoints);
        this.calcDiscrepancy();
        this.output = new LinkedHashMap();
        this.output.put("MEAN", "" + MathFunctions.roundDecimal(this.mean, 2));
        this.output.put("VARIANCE", "" + MathFunctions.roundDecimal(this.variance, 2));
        this.output.put("NUMBER_OF_ERRORS", "" + this.numberoferrors);
        this.output.put("NUMBER_OF_COMPARISONS", "" + nelements);
        float accuracy = 100.0f;
        if (this.processedRecords > 0) {
            accuracy = (1.0f - (float)this.numberoferrors / (float)nelements) * 100.0f;
        }
        this.output.put("ACCURACY", "" + MathFunctions.roundDecimal(accuracy, 2));
        this.output.put("MAXIMUM_ERROR", "" + MathFunctions.roundDecimal(this.maxerror, 2));
        this.output.put("MAXIMUM_ERROR_POINT", "" + this.maxdiscrepancyPoint);
        if (this.numLower > this.numHigher) {
            this.output.put("TREND", "CONTRACTION");
        } else if (this.numLower < this.numHigher) {
            this.output.put("TREND", "EXPANSION");
        } else {
            this.output.put("TREND", "STATIONARY");
        }
        return this.output;
    }

    void calcDiscrepancy() {
        double[] err = new double[this.errors.size()];
        int i = 0;
        for (Float e : this.errors) {
            err[i] = e.floatValue();
            ++i;
        }
        this.mean = 0.0;
        this.variance = 0.0;
        if (err.length > 0) {
            this.mean = MathFunctions.mean(err);
            this.variance = com.rapidminer.tools.math.MathFunctions.variance((double[])err, (double)Double.NEGATIVE_INFINITY);
        }
    }

    public void analyzeCompareList(List<Object> points) {
        this.errors = new ArrayList<Float>();
        if (points != null) {
            this.maxerror = 0.0f;
            for (Object vector : points) {
                float discrepancy;
                Object[] elements = (Object[])vector;
                String csquare = (String)elements[0];
                float probabilityPoint1 = 0.0f;
                if (elements[2] != null) {
                    probabilityPoint1 = Float.parseFloat("" + elements[2]);
                }
                float probabilityPoint2 = 0.0f;
                if (elements[3] != null) {
                    probabilityPoint2 = Float.parseFloat("" + elements[3]);
                }
                if (!((discrepancy = Math.abs(probabilityPoint2 - probabilityPoint1)) > this.threshold)) continue;
                this.errors.add(Float.valueOf(Math.abs(probabilityPoint2 - probabilityPoint1)));
                ++this.numberoferrors;
                if (discrepancy > this.maxerror) {
                    this.maxerror = discrepancy;
                    this.maxdiscrepancyPoint = csquare;
                }
                if (probabilityPoint2 > probabilityPoint1) {
                    ++this.numHigher;
                    continue;
                }
                if (!(probabilityPoint2 < probabilityPoint1)) continue;
                ++this.numLower;
            }
        }
    }

    @Override
    public String getDescription() {
        return "Discrepancy Analysis bewteen two HSPEC distributions";
    }
}

