/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataanalysis.ecoengine.transducers;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.gcube.contentmanagement.graphtools.utils.DateGuesser;
import org.gcube.contentmanagement.lexicalmatcher.utils.AnalysisLogger;
import org.gcube.contentmanagement.lexicalmatcher.utils.DatabaseFactory;
import org.gcube.contentmanagement.lexicalmatcher.utils.DistanceCalculator;
import org.gcube.dataanalysis.ecoengine.configuration.AlgorithmConfiguration;
import org.gcube.dataanalysis.ecoengine.configuration.INFRASTRUCTURE;
import org.gcube.dataanalysis.ecoengine.datatypes.ColumnType;
import org.gcube.dataanalysis.ecoengine.datatypes.DatabaseType;
import org.gcube.dataanalysis.ecoengine.datatypes.InputTable;
import org.gcube.dataanalysis.ecoengine.datatypes.OutputTable;
import org.gcube.dataanalysis.ecoengine.datatypes.PrimitiveType;
import org.gcube.dataanalysis.ecoengine.datatypes.ServiceType;
import org.gcube.dataanalysis.ecoengine.datatypes.StatisticalType;
import org.gcube.dataanalysis.ecoengine.datatypes.enumtypes.PrimitiveTypes;
import org.gcube.dataanalysis.ecoengine.datatypes.enumtypes.ServiceParameters;
import org.gcube.dataanalysis.ecoengine.datatypes.enumtypes.TableTemplates;
import org.gcube.dataanalysis.ecoengine.interfaces.Transducerer;
import org.gcube.dataanalysis.ecoengine.test.regression.Regressor;
import org.gcube.dataanalysis.ecoengine.utils.DatabaseUtils;
import org.gcube.dataanalysis.ecoengine.utils.ResourceFactory;
import org.hibernate.SessionFactory;

public class OccurrencePointsMerger
implements Transducerer {
    protected static String finalTableNameL = "final_Table_Name";
    protected static String longitudeColumn = "longitudeColumn";
    protected static String latitudeColumn = "latitudeColumn";
    protected static String recordedByColumn = "recordedByColumn";
    protected static String scientificNameColumn = "scientificNameColumn";
    protected static String eventDateColumn = "eventDateColumn";
    protected static String lastModificationColumn = "lastModificationColumn";
    protected static String rightTableNameF = "rightTableName";
    protected static String leftTableNameF = "leftTableName";
    protected static String finalTableNameF = "finalTableName";
    protected static String spatialTolerance = "spatialTolerance";
    protected static String confidence = "confidence";
    protected static String sqlDateFormat = "MM/DD/YYYY HH24:MI:SS";
    protected static String javaDateFormat = "MM/dd/yyyy HH:mm:ss";
    protected static String tableNameF = "OccurrencePointsTableName";
    protected List<OccurrenceRecord> records_left;
    protected List<OccurrenceRecord> records_right;
    protected AlgorithmConfiguration config;
    protected String lonFld;
    protected String latFld;
    protected String recordedByFld;
    protected String scientificNameFld;
    protected String eventDatFld;
    protected String modifDatFld;
    protected String leftTableName;
    protected String rightTableName;
    protected String finalTableName;
    protected String finalTableLabel;
    protected float spatialToleranceValue;
    protected float confidenceValue;
    protected StringBuffer columns;
    protected List<OccurrenceRecord> objectstoinsert;
    protected List<OccurrenceRecord> objectstodelete;
    protected List<Object> columnsNames;
    protected SessionFactory dbconnection;
    protected float status;
    protected boolean firstbest = true;
    boolean displaydateconvert = true;
    ResourceFactory resourceManager;
    public List<Object> leftRows;
    public List<Object> rightRows;

    public static String convert2conventionalFormat(Calendar date) {
        if (date == null) {
            return "";
        }
        SimpleDateFormat formatter = new SimpleDateFormat(javaDateFormat);
        String formattedDate = formatter.format(new Date(date.getTimeInMillis()));
        return formattedDate;
    }

    public OccurrenceRecord row2OccurrenceRecord(Object[] row) {
        OccurrenceRecord record = new OccurrenceRecord();
        int index = 0;
        for (Object name : this.columnsNames) {
            String name$ = "" + name;
            String value$ = null;
            if (row[index] != null) {
                value$ = "" + row[index];
            }
            if (name$.equalsIgnoreCase(this.lonFld)) {
                record.x = Double.parseDouble(value$);
                record.x$ = value$;
            } else if (name$.equalsIgnoreCase(this.latFld)) {
                record.y = Double.parseDouble(value$);
                record.y$ = value$;
            } else if (name$.equalsIgnoreCase(this.recordedByFld)) {
                record.recordedby = value$;
            } else if (name$.equalsIgnoreCase(this.scientificNameFld)) {
                record.scientificName = value$;
            } else if (name$.equalsIgnoreCase(this.eventDatFld)) {
                if (value$ == null || value$.length() == 0) {
                    record.eventdate = null;
                } else {
                    record.eventdate = DateGuesser.convertDate(value$);
                    if (this.displaydateconvert) {
                        AnalysisLogger.getLogger().info((Object)("From " + value$ + "->" + OccurrencePointsMerger.convert2conventionalFormat(record.eventdate) + " pattern " + DateGuesser.getPattern(value$)));
                        this.displaydateconvert = false;
                    }
                }
            } else if (name$.equalsIgnoreCase(this.modifDatFld)) {
                record.modifdate = DateGuesser.convertDate(value$);
            } else {
                record.otherValues.add(value$);
            }
            ++index;
        }
        return record;
    }

    protected String takeEssential(OccurrenceRecord record) {
        OccurrenceRecord record2 = new OccurrenceRecord();
        record2.scientificName = record.scientificName;
        record2.recordedby = record.recordedby;
        record2.eventdate = record.eventdate;
        record2.modifdate = record.modifdate;
        record2.x = record.x;
        record2.y = record.y;
        record2.x$ = record.x$;
        record2.y$ = record.y$;
        return this.occurrenceRecord2String(record2);
    }

    public String occurrenceRecord2String(OccurrenceRecord record) {
        StringBuffer buffer = new StringBuffer();
        int index = 0;
        int k = 0;
        int nNames = this.columnsNames.size();
        for (Object name : this.columnsNames) {
            String dat;
            String name$ = "" + name;
            String value$ = "NULL";
            if (name$.equalsIgnoreCase(this.lonFld)) {
                value$ = "'" + record.x$ + "'";
            } else if (name$.equalsIgnoreCase(this.latFld)) {
                value$ = "'" + record.y$ + "'";
            } else if (name$.equalsIgnoreCase(this.recordedByFld)) {
                if (record.recordedby != null) {
                    value$ = "'" + record.recordedby.replace("'", "") + "'";
                }
            } else if (name$.equalsIgnoreCase(this.scientificNameFld)) {
                if (record.scientificName != null) {
                    value$ = "'" + record.scientificName.replace("'", "") + "'";
                }
            } else if (name$.equalsIgnoreCase(this.eventDatFld)) {
                if (record.eventdate != null) {
                    dat = OccurrencePointsMerger.convert2conventionalFormat(record.eventdate);
                    value$ = dat != null && dat.length() > 0 ? "'" + OccurrencePointsMerger.convert2conventionalFormat(record.eventdate) + "'" : "NULL";
                }
            } else if (name$.equalsIgnoreCase(this.modifDatFld)) {
                if (record.modifdate != null) {
                    dat = OccurrencePointsMerger.convert2conventionalFormat(record.modifdate);
                    value$ = dat != null && dat.length() > 0 ? "'" + OccurrencePointsMerger.convert2conventionalFormat(record.modifdate) + "'" : "NULL";
                }
            } else if (record.otherValues != null && record.otherValues.size() > 0) {
                String v = record.otherValues.get(k);
                if (v != null && v.length() > 0) {
                    value$ = "'" + v.replace("'", "") + "'";
                }
                ++k;
            }
            if (value$.equals("'null'")) {
                value$ = "NULL";
            }
            buffer.append(value$);
            if (index < nNames - 1) {
                buffer.append(",");
            }
            ++index;
        }
        return buffer.toString();
    }

    @Override
    public List<StatisticalType> getInputParameters() {
        ArrayList<TableTemplates> templatesOccurrence = new ArrayList<TableTemplates>();
        templatesOccurrence.add(TableTemplates.OCCURRENCE_SPECIES);
        PrimitiveType p0 = new PrimitiveType(String.class.getName(), null, PrimitiveTypes.STRING, finalTableNameL, "the name of the produced table", "Occ_");
        InputTable p1 = new InputTable(templatesOccurrence, leftTableNameF, "the First table containing the occurrence points", "");
        InputTable p2 = new InputTable(templatesOccurrence, rightTableNameF, "the Second table containing the occurrence points", "");
        ColumnType p3 = new ColumnType(leftTableNameF, longitudeColumn, "column with longitude values", "decimallongitude", false);
        ColumnType p4 = new ColumnType(leftTableNameF, latitudeColumn, "column with latitude values", "decimallatitude", false);
        ColumnType p5 = new ColumnType(leftTableNameF, recordedByColumn, "column with RecordedBy values", "recordedby", false);
        ColumnType p6 = new ColumnType(leftTableNameF, scientificNameColumn, "column with Scientific Names", "scientificname", false);
        ColumnType p7 = new ColumnType(leftTableNameF, eventDateColumn, "column with EventDate values", "eventdate", false);
        ColumnType p8 = new ColumnType(leftTableNameF, lastModificationColumn, "column with Modified values", "modified", false);
        ServiceType p9 = new ServiceType(ServiceParameters.RANDOMSTRING, finalTableNameF, "name of the resulting table", "processedOccurrences_");
        PrimitiveType p10 = new PrimitiveType(Float.class.getName(), null, PrimitiveTypes.NUMBER, spatialTolerance, "the tolerance in degree for assessing that two points could be the same", "0.5");
        PrimitiveType p11 = new PrimitiveType(Float.class.getName(), null, PrimitiveTypes.NUMBER, confidence, "the overall acceptance similarity threshold over which two points are the same - from 0 to 100", "80");
        ArrayList<StatisticalType> inputs = new ArrayList<StatisticalType>();
        inputs.add(p0);
        inputs.add(p1);
        inputs.add(p2);
        inputs.add(p3);
        inputs.add(p4);
        inputs.add(p5);
        inputs.add(p6);
        inputs.add(p7);
        inputs.add(p8);
        inputs.add(p9);
        inputs.add(p10);
        inputs.add(p11);
        DatabaseType.addDefaultDBPars(inputs);
        return inputs;
    }

    @Override
    public String getResources() {
        if (this.status > 0.0f && this.status < 100.0f) {
            return ResourceFactory.getResources(100.0f);
        }
        return ResourceFactory.getResources(0.0f);
    }

    @Override
    public String getResourceLoad() {
        if (this.resourceManager == null) {
            this.resourceManager = new ResourceFactory();
        }
        return this.resourceManager.getResourceLoad(1);
    }

    @Override
    public float getStatus() {
        return this.status;
    }

    @Override
    public INFRASTRUCTURE getInfrastructure() {
        return INFRASTRUCTURE.LOCAL;
    }

    @Override
    public StatisticalType getOutput() {
        ArrayList<TableTemplates> templatesOccurrence = new ArrayList<TableTemplates>();
        templatesOccurrence.add(TableTemplates.OCCURRENCE_SPECIES);
        OutputTable p = new OutputTable(templatesOccurrence, this.finalTableLabel, this.finalTableName, "The output table containing the processed points");
        return p;
    }

    @Override
    public void init() throws Exception {
        this.lonFld = this.config.getParam(longitudeColumn);
        this.latFld = this.config.getParam(latitudeColumn);
        this.recordedByFld = this.config.getParam(recordedByColumn);
        this.scientificNameFld = this.config.getParam(scientificNameColumn);
        this.eventDatFld = this.config.getParam(eventDateColumn);
        this.modifDatFld = this.config.getParam(lastModificationColumn);
        this.leftTableName = this.config.getParam(leftTableNameF);
        this.rightTableName = this.config.getParam(rightTableNameF);
        this.finalTableName = this.config.getParam(finalTableNameF);
        this.finalTableLabel = this.config.getParam(finalTableNameL);
        this.spatialToleranceValue = Float.parseFloat(this.config.getParam(spatialTolerance));
        this.confidenceValue = Float.parseFloat(this.config.getParam(confidence));
        this.config.setParam(tableNameF, this.finalTableName);
        this.objectstoinsert = new ArrayList<OccurrenceRecord>();
        this.objectstodelete = new ArrayList<OccurrenceRecord>();
        this.status = 0.0f;
    }

    @Override
    public void setConfiguration(AlgorithmConfiguration config) {
        this.config = config;
    }

    @Override
    public String getDescription() {
        return "Between two Ocurrence Sets, enrichs the Left Set with the elements of the Right Set that are not in the Left Set. Updates the elements of the Left Set with more recent elements in the Right Set. If one element in the Left Set corresponds to several recent elements in the Right Set, these will be all substituted to the element of the Left Set.";
    }

    protected float probabilityStrings(String first, String second) {
        if (first == null || second == null) {
            return 1.0f;
        }
        return (float)new DistanceCalculator().CD(false, first, second);
    }

    protected float probabilityDates(Calendar first, Calendar second) {
        if (first == null || second == null) {
            return 1.0f;
        }
        if (first.compareTo(second) == 0) {
            return 1.0f;
        }
        return 0.0f;
    }

    protected float extProb(OccurrenceRecord right, OccurrenceRecord left) {
        float probability = 0.0f;
        float distance = (float)Math.sqrt(Math.abs(left.x - right.x) + Math.abs(left.y - right.y));
        if (distance > this.spatialToleranceValue) {
            probability = -1.0f;
        } else {
            float pSpecies = this.probabilityStrings(right.scientificName, left.scientificName);
            float pRecordedBy = this.probabilityStrings(right.recordedby, left.recordedby);
            float pDates = this.probabilityDates(right.eventdate, left.eventdate);
            probability = pSpecies * pRecordedBy * pDates;
        }
        return probability * 100.0f;
    }

    protected void manageHighProbability(float probability, OccurrenceRecord leftOcc, OccurrenceRecord rightOcc) {
        if (leftOcc.modifdate != null && rightOcc.modifdate != null && leftOcc.modifdate.before(rightOcc.modifdate) || leftOcc.modifdate == null && rightOcc.modifdate != null) {
            this.objectstodelete.add(leftOcc);
            this.objectstoinsert.add(rightOcc);
        }
    }

    protected void manageLowProbability(float probability, OccurrenceRecord leftOcc, OccurrenceRecord rightOcc) {
        this.objectstoinsert.add(rightOcc);
    }

    protected void persist() throws Exception {
        int todel = this.objectstodelete.size();
        int counter = 0;
        StringBuffer buffer = new StringBuffer();
        AnalysisLogger.getLogger().info((Object)("Deleting " + todel + " objects"));
        if (todel > 0) {
            for (OccurrenceRecord record : this.objectstodelete) {
                buffer.append("(");
                String rec = null;
                if (record.recordedby != null && record.recordedby.length() > 0) {
                    rec = String.valueOf(this.recordedByFld) + "='" + record.recordedby.replace("'", "") + "'";
                    buffer.append(rec);
                }
                String sci = null;
                if (record.scientificName != null && record.scientificName.length() > 0) {
                    if (rec != null) {
                        buffer.append(" AND ");
                    }
                    sci = String.valueOf(this.scientificNameFld) + "='" + record.scientificName.replace("'", "") + "'";
                    buffer.append(sci);
                }
                if (rec != null || sci != null) {
                    buffer.append(" AND ");
                }
                String x = null;
                if (record.x$ != null && record.x$.length() > 0) {
                    x = String.valueOf(this.lonFld) + "='" + record.x$ + "'";
                }
                String y = null;
                if (record.y$ != null && record.y$.length() > 0) {
                    y = String.valueOf(this.latFld) + "='" + record.y$ + "'";
                }
                if (x != null && y != null) {
                    buffer.append(String.valueOf(x) + " AND " + y);
                }
                String event = null;
                String modified = null;
                if (record.eventdate != null) {
                    event = String.valueOf(this.eventDatFld) + "=to_timestamp('" + OccurrencePointsMerger.convert2conventionalFormat(record.eventdate) + "','" + sqlDateFormat + "')";
                }
                if (record.modifdate != null) {
                    modified = String.valueOf(this.modifDatFld) + "=to_timestamp('" + OccurrencePointsMerger.convert2conventionalFormat(record.modifdate) + "','" + sqlDateFormat + "')";
                }
                if (event != null) {
                    buffer.append(" AND " + event);
                }
                if (modified != null) {
                    buffer.append(" AND " + modified);
                }
                buffer.append(")");
                if (counter > 0 && counter % 500 == 0) {
                    String updateQ = DatabaseUtils.deleteFromBuffer(this.finalTableName, buffer);
                    DatabaseFactory.executeSQLUpdate(updateQ, this.dbconnection);
                    AnalysisLogger.getLogger().info((Object)"Partial Objects deleted");
                    buffer = new StringBuffer();
                } else if (counter < todel - 1) {
                    buffer.append(" OR ");
                }
                ++counter;
            }
            String updateQ = DatabaseUtils.deleteFromBuffer(this.finalTableName, buffer);
            DatabaseFactory.executeSQLUpdate(updateQ, this.dbconnection);
            AnalysisLogger.getLogger().info((Object)"All Objects deleted");
        }
        buffer = new StringBuffer();
        ArrayList<String> insertedStrings = new ArrayList<String>();
        int toins = this.objectstoinsert.size();
        AnalysisLogger.getLogger().info((Object)("Inserting " + toins + " objects"));
        counter = 0;
        if (toins > 0) {
            for (OccurrenceRecord record : this.objectstoinsert) {
                String toInsert = this.occurrenceRecord2String(record);
                String toInsertEssentials = this.takeEssential(record);
                if (insertedStrings.contains(toInsertEssentials)) continue;
                buffer.append("(");
                insertedStrings.add(toInsertEssentials);
                buffer.append(toInsert);
                buffer.append(")");
                if (counter > 0 && counter % 500 == 0) {
                    this.insertBuffer(buffer);
                    AnalysisLogger.getLogger().info((Object)"Partial Objects inserted");
                    buffer = new StringBuffer();
                } else {
                    buffer.append(",");
                }
                ++counter;
            }
            this.insertBuffer(buffer);
            AnalysisLogger.getLogger().info((Object)"Objects inserted");
            AnalysisLogger.getLogger().info((Object)("Inserted " + counter + " objects"));
        }
        this.objectstoinsert = null;
        this.objectstodelete = null;
        insertedStrings = null;
        this.objectstoinsert = new ArrayList<OccurrenceRecord>();
        this.objectstodelete = new ArrayList<OccurrenceRecord>();
        System.gc();
    }

    protected void insertBuffer(StringBuffer buffer) throws Exception {
        String subBuffer = buffer.substring(0, buffer.length() - 1);
        String updateQ = "SET datestyle = \"ISO, MDY\"; " + DatabaseUtils.insertFromString(this.finalTableName, this.columns.toString(), subBuffer);
        AnalysisLogger.getLogger().debug((Object)("Update:\n" + updateQ));
        DatabaseFactory.executeSQLUpdate(updateQ, this.dbconnection);
    }

    protected void prepareFinalTable() throws Exception {
        DatabaseFactory.executeSQLUpdate(DatabaseUtils.duplicateTableStatement(this.leftTableName, this.finalTableName), this.dbconnection);
    }

    public void extractColumnNames() throws Exception {
        this.columnsNames = DatabaseFactory.executeSQLQuery(DatabaseUtils.getColumnsNamesStatement(this.rightTableName), this.dbconnection);
        int nCols = this.columnsNames.size();
        this.columns = new StringBuffer();
        int i = 0;
        while (i < nCols) {
            this.columns.append("\"" + this.columnsNames.get(i) + "\"");
            if (i < nCols - 1) {
                this.columns.append(",");
            }
            ++i;
        }
    }

    public void initDB(boolean buildTable) throws Exception {
        AnalysisLogger.getLogger().info((Object)"Initializing DB Connection");
        this.dbconnection = DatabaseUtils.initDBSession(this.config);
        AnalysisLogger.getLogger().info((Object)"Taking Table Description");
        this.extractColumnNames();
        if (buildTable) {
            AnalysisLogger.getLogger().info((Object)("Taken Table Description: " + this.columns));
            AnalysisLogger.getLogger().info((Object)("Creating final table: " + this.finalTableName));
            try {
                DatabaseFactory.executeSQLUpdate(DatabaseUtils.dropTableStatement(this.finalTableName), this.dbconnection);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.prepareFinalTable();
        }
    }

    @Override
    public void shutdown() {
        if (this.dbconnection != null) {
            try {
                this.dbconnection.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public int getNumLeftObjects() {
        if (this.leftRows != null) {
            return this.leftRows.size();
        }
        return 0;
    }

    public int getNumRightObjects() {
        if (this.rightRows != null) {
            return this.rightRows.size();
        }
        return 0;
    }

    public void takeFullRanges() {
        AnalysisLogger.getLogger().info((Object)("Taking elements from left table: " + this.leftTableName));
        this.leftRows = DatabaseFactory.executeSQLQuery(DatabaseUtils.getColumnsElementsStatement(this.leftTableName, this.columns.toString(), ""), this.dbconnection);
        AnalysisLogger.getLogger().info((Object)("Taking elements from right table: " + this.rightTableName));
        this.rightRows = DatabaseFactory.executeSQLQuery(DatabaseUtils.getColumnsElementsStatement(this.rightTableName, this.columns.toString(), ""), this.dbconnection);
    }

    public void takeRange(int offsetLeft, int numLeft, int offsetRight, int numRight) {
        AnalysisLogger.getLogger().info((Object)("Taking elements from left table: " + this.leftTableName));
        this.leftRows = DatabaseFactory.executeSQLQuery(DatabaseUtils.getColumnsElementsStatement(this.leftTableName, this.columns.toString(), "offset " + offsetLeft + " limit " + numLeft), this.dbconnection);
        AnalysisLogger.getLogger().info((Object)("Taking elements from right table: " + this.rightTableName));
        this.rightRows = DatabaseFactory.executeSQLQuery(DatabaseUtils.getColumnsElementsStatement(this.rightTableName, this.columns.toString(), "offset " + offsetRight + " limit " + numRight), this.dbconnection);
    }

    public void computeRange() throws Exception {
        try {
            try {
                AnalysisLogger.getLogger().info((Object)("Processing " + this.leftTableName + " vs " + this.rightTableName));
                this.status = 10.0f;
                int rightCounter = 0;
                int similaritiesCounter = 0;
                int allrightrows = this.rightRows.size();
                if (allrightrows > 0 && this.getNumLeftObjects() > 0) {
                    for (Object rRow : this.rightRows) {
                        OccurrenceRecord rightOcc = this.row2OccurrenceRecord((Object[])rRow);
                        int k = 0;
                        boolean found = false;
                        float p = 0.0f;
                        OccurrenceRecord bestleftOcc = null;
                        for (Object lRow : this.leftRows) {
                            OccurrenceRecord leftOcc = null;
                            leftOcc = this.row2OccurrenceRecord((Object[])lRow);
                            p = this.extProb(leftOcc, rightOcc);
                            if (p >= this.confidenceValue) {
                                bestleftOcc = leftOcc;
                                found = true;
                                ++similaritiesCounter;
                                AnalysisLogger.getLogger().info((Object)("Found a similarity with P=" + p + " between (" + "\"" + leftOcc.scientificName + "\"" + ",\"" + leftOcc.x + "\"" + "," + "\"" + leftOcc.y + "\"" + "," + "\"" + leftOcc.recordedby + "\"" + "," + "\"" + OccurrencePointsMerger.convert2conventionalFormat(leftOcc.eventdate) + "\"" + ") VS " + "(" + "\"" + rightOcc.scientificName + "\"" + "," + "\"" + rightOcc.x + "\"" + "," + "\"" + rightOcc.y + "\"" + "," + "\"" + rightOcc.recordedby + "\"" + "," + "\"" + OccurrencePointsMerger.convert2conventionalFormat(rightOcc.eventdate) + "\"" + ")"));
                                if (this.firstbest) break;
                                this.manageHighProbability(p, bestleftOcc, rightOcc);
                            }
                            ++k;
                        }
                        ++rightCounter;
                        if (this.firstbest) {
                            if (found) {
                                this.manageHighProbability(p, bestleftOcc, rightOcc);
                            } else {
                                this.manageLowProbability(p, bestleftOcc, rightOcc);
                            }
                        } else if (!found) {
                            this.manageLowProbability(p, bestleftOcc, rightOcc);
                        }
                        this.status = Math.min(90.0f, 10.0f + 80.0f * (float)rightCounter / (float)allrightrows);
                        if (rightCounter % 500 != 0) continue;
                        AnalysisLogger.getLogger().info((Object)("Persisting ... " + rightCounter + " over " + allrightrows));
                        this.persist();
                    }
                }
                AnalysisLogger.getLogger().info((Object)("Found " + similaritiesCounter + " similarities on " + rightCounter + " elements"));
                this.status = 90.0f;
                this.persist();
            }
            catch (Exception e) {
                System.err.println("Error in computation");
                e.printStackTrace();
                AnalysisLogger.getLogger().info((Object)e);
                throw e;
            }
        }
        finally {
            this.shutdown();
            this.status = 100.0f;
            AnalysisLogger.getLogger().info((Object)"Occ Points Processing Finished and db closed");
        }
    }

    @Override
    public void compute() throws Exception {
        this.initDB(true);
        this.takeFullRanges();
        this.computeRange();
        this.postProcess();
    }

    public void postProcess() throws Exception {
    }

    public static void main(String[] args) throws Exception {
        AlgorithmConfiguration config = Regressor.getConfig();
        config.setNumberOfResources(1);
        config.setParam(longitudeColumn, "decimallongitude");
        config.setParam(latitudeColumn, "decimallatitude");
        config.setParam(recordedByColumn, "recordedby");
        config.setParam(scientificNameColumn, "scientificname");
        config.setParam(eventDateColumn, "eventdate");
        config.setParam(lastModificationColumn, "modified");
        config.setParam(rightTableNameF, "whitesharkoccurrences2");
        config.setParam(leftTableNameF, "whitesharkoccurrences1");
        config.setParam(finalTableNameF, "whitesharkoccurrencesmerged");
        config.setParam(spatialTolerance, "0.5");
        config.setParam(confidence, "0.8");
        OccurrencePointsMerger occm = new OccurrencePointsMerger();
        occm.setConfiguration(config);
        occm.init();
        occm.compute();
    }

    protected class OccurrenceRecord {
        public String scientificName;
        public String recordedby;
        public Calendar eventdate;
        public Calendar modifdate;
        public double x;
        public double y;
        public String x$;
        public String y$;
        public List<String> otherValues = new ArrayList<String>();
    }
}

