/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataanalysis.ecoengine.test.regression;

import java.util.List;
import org.gcube.dataanalysis.ecoengine.configuration.AlgorithmConfiguration;
import org.gcube.dataanalysis.ecoengine.interfaces.ComputationalAgent;
import org.gcube.dataanalysis.ecoengine.processing.factories.EvaluatorsFactory;
import org.gcube.dataanalysis.ecoengine.test.regression.Regressor;

public class RegressionTestEvaluators {
    public static void main(String[] args) throws Exception {
        List<ComputationalAgent> evaluators = EvaluatorsFactory.getEvaluators(RegressionTestEvaluators.testConfig1());
        evaluators.get(0).init();
        Regressor.process(evaluators.get(0));
        evaluators = null;
        System.out.println("\n**********-------************\n");
        evaluators = EvaluatorsFactory.getEvaluators(RegressionTestEvaluators.testConfig2());
        evaluators.get(0).init();
        Regressor.process(evaluators.get(0));
        evaluators = null;
    }

    private static AlgorithmConfiguration testConfig1() {
        AlgorithmConfiguration config = Regressor.getConfig();
        config.setNumberOfResources(1);
        config.setAgent("DISCREPANCY_ANALYSIS");
        config.setParam("FirstTable", "hspec_native_baskingshark_aquamaps");
        config.setParam("SecondTable", "hspec_suitable_nn_Fis22747");
        config.setParam("FirstTableCsquareColumn", "csquarecode");
        config.setParam("SecondTableCsquareColumn", "csquarecode");
        config.setParam("FirstTableProbabilityColumn", "probability");
        config.setParam("SecondTableProbabilityColumn", "probability");
        config.setParam("ComparisonThreshold", "0.1");
        return config;
    }

    private static AlgorithmConfiguration testConfig2() {
        AlgorithmConfiguration config = Regressor.getConfig();
        config.setNumberOfResources(1);
        config.setNumberOfResources(1);
        config.setAgent("QUALITY_ANALYSIS");
        config.setParam("PositiveCasesTable", "presence_data_baskingshark");
        config.setParam("NegativeCasesTable", "absence_data_baskingshark2");
        config.setParam("PositiveCasesTableKeyColumn", "csquarecode");
        config.setParam("NegativeCasesTableKeyColumn", "csquarecode");
        config.setParam("DistributionTable", "hspec_native_baskingshark_aquamaps");
        config.setParam("DistributionTableKeyColumn", "csquarecode");
        config.setParam("DistributionTableProbabilityColumn", "probability");
        config.setParam("PositiveThreshold", "0.5");
        config.setParam("NegativeThreshold", "0.5");
        return config;
    }
}

