package org.gcube.dataanalysis.ecoengine.test.checks;

import java.util.List;

import org.gcube.contentmanagement.lexicalmatcher.utils.AnalysisLogger;
import org.gcube.dataanalysis.ecoengine.configuration.AlgorithmConfiguration;
import org.gcube.dataanalysis.ecoengine.interfaces.Transducerer;
import org.gcube.dataanalysis.ecoengine.processing.factories.TransducerersFactory;

public class TestTransducer {
	/**
	 * example of parallel processing on a single machine the procedure will generate a new table for a distribution on suitable species
	 * 
	 */

	public static void main(String[] args) throws Exception {

		System.out.println("TEST 1");
		List<Transducerer> trans = TransducerersFactory.getTransducerers(testConfigLocal());
		trans.get(0).init();
		transduce(trans.get(0));
		trans = null;

	}

	private static void transduce(Transducerer trans) throws Exception {

		if (trans != null) {
			TestTransducer tgs = new TestTransducer();
			ThreadCalculator tc = tgs.new ThreadCalculator(trans);
			Thread t = new Thread(tc);
			t.start();
			while (trans.getStatus() < 100) {

				System.out.println("STATUS: " + trans.getStatus());
				Thread.sleep(1000);
			}
		} else
			AnalysisLogger.getLogger().trace("Generator Algorithm Not Supported");

	}

	public class ThreadCalculator implements Runnable {
		Transducerer dg;

		public ThreadCalculator(Transducerer dg) {
			this.dg = dg;
		}

		public void run() {
			try {

				dg.compute();

			} catch (Exception e) {
			}
		}

	}

	private static AlgorithmConfiguration testConfigLocal() {

		AlgorithmConfiguration config = new AlgorithmConfiguration();
		config.setConfigPath("./cfg/");
		config.setPersistencePath("./");
		config.setNumberOfResources(1);
		config.setAgent("BIOCLIMATE_HSPEC");

		//config.setParam("HSPEC_TABLE_LIST", "hcaf_d, hcaf_d_2015_LINEAR_01338580273835,hcaf_d_2018_LINEAR_11338580276548,hcaf_d_2021_LINEAR_21338580279237,hcaf_d_2024_LINEAR_31338580282780,hcaf_d_2027_LINEAR_41338580283400,hcaf_d_2030_LINEAR_51338580284030,hcaf_d_2033_LINEAR_61338580284663,hcaf_d_2036_LINEAR_71338580285205,hcaf_d_2039_LINEAR_81338580285958,hcaf_d_2042_LINEAR_91338580286545,hcaf_d_2050");
		//config.setParam("HSPEC_TABLE_NAMES", "test,test,test,test,test,test,test,test,test,test,test,test");
		config.setParam("HSPEC_TABLE_LIST", "hspec_validation"+AlgorithmConfiguration.getListSeparator()+"hspec_validation2");
		config.setParam("HSPEC_TABLE_NAMES", "test"+AlgorithmConfiguration.getListSeparator()+"test");
		
		config.setParam("Threshold", "0.5");

		config.setParam("DatabaseUserName", "gcube");
		config.setParam("DatabasePassword", "d4science2");
		config.setParam("DatabaseURL", "jdbc:postgresql://localhost/testdb");
		config.setParam("DatabaseDriver", "org.postgresql.Driver");

		return config;
	}

}
