package org.gcube.dataanalysis.ecoengine.test.checks;

import java.util.List;

import org.gcube.contentmanagement.lexicalmatcher.utils.AnalysisLogger;
import org.gcube.dataanalysis.ecoengine.clustering.DBScan;
import org.gcube.dataanalysis.ecoengine.configuration.AlgorithmConfiguration;
import org.gcube.dataanalysis.ecoengine.interfaces.Clusterer;
import org.gcube.dataanalysis.ecoengine.interfaces.Transducerer;
import org.gcube.dataanalysis.ecoengine.processing.factories.ClusterersFactory;

public class TestClusterer {
	/**
	 * example of parallel processing on a single machine the procedure will generate a new table for a distribution on suitable species
	 * 
	 */

	public static void main(String[] args) throws Exception {

		System.out.println("TEST 1");
		List<Clusterer> clus = ClusterersFactory.getClusterers(testConfigLocal());
		clus .get(0).init();
		cluster(clus .get(0));
		clus = null;

	}

	private static void cluster(Clusterer clus) throws Exception {

		if (clus != null) {
			TestClusterer tgs = new TestClusterer();
			ThreadCalculator tc = tgs.new ThreadCalculator(clus);
			Thread t = new Thread(tc);
			t.start();
			while (clus.getStatus() < 100) {

				System.out.println("STATUS: " + clus.getStatus());
				Thread.sleep(1000);
			}
		} else
			AnalysisLogger.getLogger().trace("Generator Algorithm Not Supported");

	}

	public class ThreadCalculator implements Runnable {
		Clusterer dg;

		public ThreadCalculator(Clusterer dg) {
			this.dg = dg;
		}

		public void run() {
			try {

				dg.compute();

			} catch (Exception e) {
			}
		}

	}

	private static AlgorithmConfiguration testConfigLocal() {

		AlgorithmConfiguration config = new AlgorithmConfiguration();
		config.setConfigPath("./cfg/");
		config.setPersistencePath("./");
		config.setParam("OccurrencePointsTable","occurrence_species_id5397d3c4_a7eb_4227_adb4_d9d7d36e8b21");
		config.setParam("FeaturesColumnNames","recordedby#basisofrecord#locality");
		config.setParam("OccurrencePointsClusterTable","occCluster_gp");
		config.setParam("epsilon","10");
		config.setParam("min_points","1");

		config.setConfigPath("./cfg/");
		config.setPersistencePath("./");
		config.setNumberOfResources(1);
		config.setAgent("DBSCAN");
		
		config.setParam("DatabaseUserName","utente");
		config.setParam("DatabasePassword","d4science");
		config.setParam("DatabaseURL","jdbc:postgresql://dbtest.next.research-infrastructures.eu/testdb");
		config.setParam("DatabaseDriver","org.postgresql.Driver");
		
		return config;
	}

}
