/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.contentmanagement.lexicalmatcher.analysis.guesser.data;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CategoryScoresOld {
    private static Logger logger = LoggerFactory.getLogger(CategoryScoresOld.class);
    private HashMap<String, BigDecimal> columnsScore;
    private BigDecimal maximumElements;

    public CategoryScoresOld(BigInteger maxelements) {
        this.maximumElements = new BigDecimal(maxelements);
        this.columnsScore = new HashMap();
    }

    public void setMaximumElements(BigDecimal MaximumElements) {
        this.maximumElements = MaximumElements;
    }

    public void incrementScore(String columnName, float increment) {
        BigDecimal score = this.columnsScore.get(columnName);
        BigDecimal reciproc = BigDecimal.valueOf(increment);
        score = score == null ? reciproc : score.add(reciproc);
        this.columnsScore.put(columnName, score);
    }

    public double getScore(String columnName) {
        double score = 0.0;
        try {
            BigDecimal percentage = this.columnsScore.get(columnName);
            try {
                if (percentage == null) {
                    percentage = BigDecimal.ZERO;
                }
                logger.trace("getScore -> Score for " + columnName + ": " + percentage + " vs " + this.maximumElements);
                percentage = percentage.divide(this.maximumElements, 2, 1);
            }
            catch (ArithmeticException e) {
                percentage = BigDecimal.ZERO;
                e.printStackTrace();
            }
            score = percentage.doubleValue();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return score;
    }

    public String findBest() {
        String bestCol = null;
        BigDecimal bestscore = BigDecimal.valueOf(-1L);
        for (String column : this.columnsScore.keySet()) {
            BigDecimal score = BigDecimal.ZERO;
            try {
                score = this.columnsScore.get(column);
            }
            catch (Exception e) {
                logger.error("ERROR in getting SCORE ", (Throwable)e);
            }
            if (bestscore.compareTo(score) >= 0) continue;
            bestscore = score;
            bestCol = column;
        }
        return bestCol;
    }

    public ArrayList<String> findBestList() {
        ArrayList<String> bestCols = new ArrayList<String>();
        for (String column : this.columnsScore.keySet()) {
            int size;
            BigDecimal score = BigDecimal.ZERO;
            try {
                score = this.columnsScore.get(column);
            }
            catch (Exception e) {
                logger.error("ERROR in getting SCORE ", (Throwable)e);
            }
            int index = size = bestCols.size();
            for (int i = 0; i < size; ++i) {
                if (this.columnsScore.get(bestCols.get(i)).compareTo(score) > 0) continue;
                index = i;
                break;
            }
            bestCols.add(index, column);
        }
        return bestCols;
    }
}

