/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataanalysis.ecoengine.signals.ssa;

import java.util.ArrayList;
import java.util.List;
import org.gcube.dataanalysis.ecoengine.signals.ssa.SSADataset;
import org.gcube.dataanalysis.ecoengine.signals.ssa.SSAGroupList;
import org.gcube.dataanalysis.ecoengine.signals.ssa.SSAUnselectList;
import org.gcube.dataanalysis.ecoengine.signals.ssa.SingularSpectrumAnalysis;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SSAWorkflow {
    private static Logger logger = LoggerFactory.getLogger(SSAWorkflow.class);

    public static SSADataset applyCompleteWorkflow(List<Double> timeseries, int analysisWindowLength, float eigenValuesPercentageThreshold, int nPointsToForecast, boolean reportReconstructedSignal) {
        SSADataset data = new SSADataset();
        data.setTimeSeries(timeseries);
        data.setL(analysisWindowLength);
        data.setPercThreshold(eigenValuesPercentageThreshold);
        SingularSpectrumAnalysis.inclosure(data);
        System.gc();
        SingularSpectrumAnalysis.singularDecomposition(data);
        System.gc();
        SingularSpectrumAnalysis.setMovingAverage(data);
        System.gc();
        SingularSpectrumAnalysis.averagedCovariance(data);
        System.gc();
        SingularSpectrumAnalysis.functionEigenValue(data);
        ArrayList<SSAGroupList> groupsModel = new ArrayList<SSAGroupList>();
        ArrayList<SSAUnselectList> groups = new ArrayList<SSAUnselectList>();
        logger.debug("Listing All the Eigenvalues");
        for (int i = 0; i < data.getPercentList().size(); ++i) {
            double currentperc = data.getPercentList().get(i);
            logger.debug("Eigenvalue: Number: " + i + " Percentage: " + currentperc);
            if (!(currentperc > (double)eigenValuesPercentageThreshold)) continue;
            groups.add(new SSAUnselectList(i, currentperc));
        }
        groupsModel.add(new SSAGroupList(groups));
        SingularSpectrumAnalysis.grouping(groupsModel, data);
        SingularSpectrumAnalysis.diagonalAveraging(data);
        double[] signal = new double[data.getTimeSeries().size()];
        for (int i = 0; i < data.getTimeSeries().size(); ++i) {
            signal[i] = data.getTimeSeries().get(i);
        }
        SingularSpectrumAnalysis.forecast(data, nPointsToForecast, reportReconstructedSignal);
        double[] rsignal = new double[data.getForecastList().size()];
        for (int i = 0; i < data.getForecastList().size(); ++i) {
            rsignal[i] = data.getForecastList().get(i);
        }
        data.setReconstructedSignal(rsignal);
        data.setForecastSignal(rsignal);
        logger.debug("SSA workflow DONE");
        return data;
    }
}

