/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataanalysis.ecoengine.transducers;

import java.util.ArrayList;
import java.util.List;
import org.gcube.dataanalysis.ecoengine.configuration.AlgorithmConfiguration;
import org.gcube.dataanalysis.ecoengine.datatypes.DatabaseType;
import org.gcube.dataanalysis.ecoengine.datatypes.PrimitiveTypesList;
import org.gcube.dataanalysis.ecoengine.datatypes.StatisticalType;
import org.gcube.dataanalysis.ecoengine.datatypes.TablesList;
import org.gcube.dataanalysis.ecoengine.datatypes.enumtypes.PrimitiveTypes;
import org.gcube.dataanalysis.ecoengine.datatypes.enumtypes.TableTemplates;
import org.gcube.dataanalysis.ecoengine.evaluation.bioclimate.BioClimateAnalysis;
import org.gcube.dataanalysis.ecoengine.transducers.BioClimateHSPECTransducer;

public class BioClimateHSPENTransducer
extends BioClimateHSPECTransducer {
    private String[] envelopeTables;
    private String[] envelopeTablesNames;

    @Override
    public void init() throws Exception {
        this.bioClimate = new BioClimateAnalysis(this.config.getConfigPath(), this.config.getPersistencePath(), this.config.getParam("DatabaseURL"), this.config.getParam("DatabaseUserName"), this.config.getParam("DatabasePassword"), false);
        this.envelopeTables = this.config.getParam("HSPEN_Table_List").split(AlgorithmConfiguration.getListSeparator());
        this.envelopeTablesNames = this.config.getParam("HSPEN_Table_Names").split(AlgorithmConfiguration.getListSeparator());
    }

    @Override
    public String getDescription() {
        return "A transducer algorithm that generates a table containing species envelops (HSPEN) in time, i.e. models capturing species tolerance with respect to environmental parameters, used by the AquaMaps approach. Evaluates the climatic changes impact on the variation of the salinity values in several ranges of a set of species envelopes";
    }

    @Override
    public List<StatisticalType> getInputParameters() {
        ArrayList<StatisticalType> parameters = new ArrayList<StatisticalType>();
        ArrayList<TableTemplates> templateHspec = new ArrayList<TableTemplates>();
        templateHspec.add(TableTemplates.HSPEN);
        TablesList p7 = new TablesList(templateHspec, "HSPEN_Table_List", "list of HSPEN tables containing the species for which the salinity will be analyzed", false);
        PrimitiveTypesList p8 = new PrimitiveTypesList(String.class.getName(), PrimitiveTypes.STRING, "HSPEN_Table_Names", "list of HSPEN table names to be used as labels", false);
        parameters.add(p7);
        parameters.add(p8);
        DatabaseType.addDefaultDBPars(parameters);
        return parameters;
    }

    @Override
    public void compute() throws Exception {
        this.status = 0.1f;
        try {
            this.bioClimate.speciesEvolutionAnalysis(this.envelopeTables, this.envelopeTablesNames, BioClimateAnalysis.salinityMinFeature, BioClimateAnalysis.salinityDefaultRange);
            this.producedImages = this.bioClimate.getProducedImages();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        finally {
            this.status = 100.0f;
        }
    }
}

