/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.contentmanagement.graphtools.plotting.graphs;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.FilteredImageSource;
import java.awt.image.ReplicateScaleFilter;
import javax.swing.JPanel;
import org.gcube.contentmanagement.graphtools.plotting.graphs.ColorMap;

public class SpectrumPlot2
extends JPanel {
    private BufferedImage spectrogram = null;
    private Image scaledSpectrogram = null;
    private float zoom = 1.0f;
    private float vzoom = 1.0f;
    private double offsetFactor;
    private double[][] data;
    public int width;
    public int height;
    private ColorMap cmap = ColorMap.getJet(64);
    private double minVal;
    private double maxVal;

    public SpectrumPlot2(double[][] dat) {
        this.data = dat;
        this.width = dat.length;
        this.height = dat[0].length;
        this.computeSpectrogram();
    }

    private void computeSpectrogram() {
        try {
            this.maxVal = 0.0;
            this.minVal = 2.147483647E9;
            for (int x = 0; x < this.width; ++x) {
                for (int y = 0; y < this.height; ++y) {
                    if (this.data[x][y] > this.maxVal) {
                        this.maxVal = this.data[x][y];
                    }
                    if (!(this.data[x][y] < this.minVal)) continue;
                    this.minVal = this.data[x][y];
                }
            }
            double minIntensity = Math.abs(this.minVal);
            double maxIntensity = this.maxVal + minIntensity;
            int maxYIndex = this.height - 1;
            Dimension d = new Dimension(this.width, this.height);
            this.setMinimumSize(d);
            this.setMaximumSize(d);
            this.setPreferredSize(d);
            this.spectrogram = new BufferedImage(this.width, this.height, 1);
            double scaleFactor = (63.0 + this.offsetFactor) / maxIntensity;
            for (int i = 0; i < this.width; ++i) {
                for (int j = maxYIndex; j >= 0; --j) {
                    int grey = (int)((this.data[i][j] + minIntensity) * scaleFactor - this.offsetFactor);
                    this.spectrogram.setRGB(i, maxYIndex - j, this.cmap.getColor(grey));
                }
            }
            ReplicateScaleFilter scaleFilter = new ReplicateScaleFilter((int)(this.zoom * (float)this.width), (int)(this.vzoom * (float)this.height));
            this.scaledSpectrogram = this.createImage(new FilteredImageSource(this.spectrogram.getSource(), scaleFilter));
            Dimension sz = this.getSize();
            this.repaint(0L, 0, 0, sz.width - 1, sz.height - 1);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setOffsetFactor(double offsetFactor) {
        this.offsetFactor = offsetFactor;
        this.computeSpectrogram();
    }

    public void vzoomSet(float vzoom) {
        this.vzoom = vzoom;
        this.zoom();
    }

    public void hzoomSet(float zoom) {
        this.zoomSet(zoom);
    }

    protected void zoomSet(float zoom) {
        this.zoom = zoom;
        this.zoom();
    }

    public void zoom() {
        if (this.spectrogram != null) {
            int width = this.spectrogram.getWidth();
            int height = this.spectrogram.getHeight();
            width = (int)(this.zoom * (float)width);
            height = (int)(this.vzoom * (float)height);
            ReplicateScaleFilter scaleFilter = new ReplicateScaleFilter(width, height);
            this.scaledSpectrogram = this.createImage(new FilteredImageSource(this.spectrogram.getSource(), scaleFilter));
            this.setPreferredSize(new Dimension(width, height));
            this.revalidate();
            this.repaint();
        }
    }

    public float getVZoom() {
        return this.vzoom;
    }

    public float getHZoom() {
        return this.zoom;
    }

    public SpectrumPlot2 getColorBar() {
        int barWidth = 20;
        double[][] cb = new double[barWidth][this.cmap.size];
        for (int x = 0; x < cb.length; ++x) {
            for (int y = 0; y < cb[x].length; ++y) {
                cb[x][y] = y;
            }
        }
        return new SpectrumPlot2(cb);
    }

    public double getData(int x, int y) {
        return this.data[x][y];
    }

    public int getDataWidth() {
        return this.width;
    }

    public int getDataHeight() {
        return this.height;
    }

    @Override
    public void paint(Graphics g) {
        Dimension sz = this.getSize();
        g.setColor(Color.WHITE);
        g.fillRect(0, 0, sz.width - 1, sz.height - 1);
        if (this.spectrogram != null) {
            g.drawImage(this.scaledSpectrogram, 0, 0, null);
        }
    }
}

