/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.contentmanagement.graphtools.data.conversions;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.gcube.contentmanagement.graphtools.abstracts.SamplesTable;
import org.gcube.contentmanagement.graphtools.utils.MathFunctions;
import org.gcube.portlets.user.timeseries.charts.support.types.GraphData;
import org.gcube.portlets.user.timeseries.charts.support.types.GraphGroups;
import org.gcube.portlets.user.timeseries.charts.support.types.Point;
import org.gcube.portlets.user.timeseries.charts.support.types.ValueEntry;

public class GraphConverter2D {
    public static final String SPIKE = "STATIONARY";
    private static double threshold = 0.001;

    private static Point<? extends Number, ? extends Number> searchPoint(Point<? extends Number, ? extends Number> x, List<Point<? extends Number, ? extends Number>> samples) {
        Point<? extends Number, ? extends Number> novelpoint = null;
        for (Point<? extends Number, ? extends Number> point : samples) {
            if (!point.getLabel().equals(x.getLabel())) continue;
            novelpoint = point;
            break;
        }
        return novelpoint;
    }

    public static List<Point<? extends Number, ? extends Number>> reduceDimension(List<Point<? extends Number, ? extends Number>> samples) {
        ArrayList<Point<? extends Number, ? extends Number>> novelSamples = new ArrayList<Point<? extends Number, ? extends Number>>();
        int novelCounter = 0;
        try {
            for (Point<? extends Number, ? extends Number> pointsample : samples) {
                Point<Number, Number> novelPoint = GraphConverter2D.searchPoint(pointsample, novelSamples);
                int index = 0;
                ValueEntry<? extends Number> pointValue = null;
                if (novelCounter > 0) {
                    pointValue = pointsample.getEntries().get(0);
                    List<ValueEntry<? extends Number>> referencevalues = novelSamples.get(0).getEntries();
                    int i = 0;
                    index = referencevalues.size();
                    for (ValueEntry<? extends Number> val : referencevalues) {
                        if (val.getLabel().equals(pointValue.getLabel())) {
                            index = i;
                            break;
                        }
                        ++i;
                    }
                }
                if (novelPoint == null) {
                    ValueEntry<Number> ve = new ValueEntry<Number>(pointsample.getEntries().get(0).getLabel(), pointsample.getEntries().get(0).getValue());
                    novelPoint = new Point(pointsample.getLabel(), pointsample.getValue());
                    int numofcolumns = index;
                    if (novelCounter > 0) {
                        numofcolumns = novelSamples.get(0).getEntries().size();
                    }
                    for (int j = 0; j < numofcolumns; ++j) {
                        novelPoint.getEntries().add(j, new ValueEntry<Double>(novelSamples.get(0).getEntries().get(j).getLabel(), 0.0));
                    }
                    if (index >= novelPoint.getEntries().size()) {
                        novelPoint.getEntries().add(index, ve);
                    } else {
                        novelPoint.getEntries().set(index, ve);
                    }
                    novelSamples.add(novelPoint);
                    ++novelCounter;
                    continue;
                }
                if (index >= novelPoint.getEntries().size()) {
                    novelPoint.getEntries().add(index, pointValue);
                    continue;
                }
                novelPoint.getEntries().set(index, pointValue);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return novelSamples;
    }

    public static List<Point<? extends Number, ? extends Number>> convert(SamplesTable sampleTable) {
        ArrayList<Point<? extends Number, ? extends Number>> pointsList = new ArrayList<Point<? extends Number, ? extends Number>>();
        try {
            int rows = sampleTable.getNumOfDataRows();
            for (int rowIndex = 0; rowIndex < rows; ++rowIndex) {
                String label = sampleTable.getClassification(rowIndex);
                int commaIndex = label.indexOf(";");
                String xlabel = label;
                String ylabel = "";
                if (commaIndex > 0) {
                    xlabel = label.substring(0, commaIndex);
                    ylabel = label.substring(commaIndex + 1);
                }
                double x = sampleTable.getValue(rowIndex, 0);
                double y = sampleTable.getValue(rowIndex, 1);
                ValueEntry<Double> ve = new ValueEntry<Double>(ylabel, y);
                Point p = new Point(xlabel, x, ve);
                pointsList.add(p);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return pointsList;
    }

    public static List<Point<? extends Number, ? extends Number>> deleteHeaders(List<Point<? extends Number, ? extends Number>> samples) {
        int size = samples.size();
        for (int i = 0; i < size; ++i) {
            Point<? extends Number, ? extends Number> p = samples.get(i);
            if (!p.getLabel().equals("header")) continue;
            samples.remove(i);
            --size;
            --i;
        }
        return samples;
    }

    public static List<Point<? extends Number, ? extends Number>> transformTable(SamplesTable sampleTable) {
        List<Point<? extends Number, ? extends Number>> singlegraph = GraphConverter2D.convert(sampleTable);
        singlegraph = GraphConverter2D.reduceDimension(singlegraph);
        singlegraph = GraphConverter2D.deleteHeaders(singlegraph);
        return singlegraph;
    }

    public static List<Point<? extends Number, ? extends Number>> reorder(List<Point<? extends Number, ? extends Number>> samples) {
        ArrayList<Point<? extends Number, ? extends Number>> orderedsamples = new ArrayList<Point<? extends Number, ? extends Number>>();
        for (Point<? extends Number, ? extends Number> p : samples) {
            Point ordP;
            int n = 0;
            Iterator iterator = orderedsamples.iterator();
            while (iterator.hasNext() && !(((Number)(ordP = (Point)iterator.next()).getValue()).doubleValue() > p.getValue().doubleValue())) {
                ++n;
            }
            orderedsamples.add(n, p);
        }
        int i = 0;
        for (Point point : orderedsamples) {
            try {
                point.setValue(Double.valueOf(i));
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++i;
        }
        return orderedsamples;
    }

    public static List<Point<? extends Number, ? extends Number>> filterXRange(List<Point<? extends Number, ? extends Number>> samples, String minX, String maxX) {
        ArrayList<Point<? extends Number, ? extends Number>> filteredsamples = new ArrayList<Point<? extends Number, ? extends Number>>();
        boolean copy = false;
        for (Point<? extends Number, ? extends Number> p : samples) {
            if (p.getLabel().equals(minX)) {
                copy = true;
            }
            if (copy) {
                filteredsamples.add(p);
            }
            if (!p.getLabel().equals(maxX)) continue;
            break;
        }
        return filteredsamples;
    }

    public static void anotateStationaryPoints(GraphGroups gg) {
        for (String key : gg.getGraphs().keySet()) {
            GraphData graph = gg.getGraphs().get(key);
            int trends = graph.getData().size();
            int yvalues = graph.getData().get(0).getEntries().size();
            for (int i = 0; i < trends; ++i) {
                double[] points = MathFunctions.points2Double(graph.getData(), i, yvalues);
                double[] derivative = MathFunctions.derivative(points);
                boolean[] spikes = MathFunctions.findSpikes(derivative, threshold);
                for (int k = 0; k < yvalues; ++k) {
                    if (!spikes[k]) continue;
                    String label = graph.getData().get(i).getEntries().get(k).getLabel();
                    String newLabel = label + ";" + SPIKE;
                    graph.getData().get(i).getEntries().get(k).setLabel(newLabel);
                }
            }
        }
    }

    public static void anotateStationaryPoints(GraphGroups gg, List<String> lables) {
        for (String key : gg.getGraphs().keySet()) {
            GraphData graph = gg.getGraphs().get(key);
            int trends = graph.getData().size();
            int yvalues = graph.getData().get(0).getEntries().size();
            int spikeslablessize = lables.size();
            for (int i = 0; i < trends; ++i) {
                double[] points = MathFunctions.points2Double(graph.getData(), i, yvalues);
                double[] derivative = MathFunctions.derivative(points);
                boolean[] spikes = MathFunctions.findSpikes(derivative, threshold);
                int spikecounter = 0;
                for (int k = 0; k < yvalues; ++k) {
                    if (!spikes[k]) continue;
                    String label = graph.getData().get(i).getEntries().get(k).getLabel();
                    String spikelable = SPIKE;
                    if (spikecounter < spikeslablessize) {
                        spikelable = lables.get(spikecounter);
                    }
                    String newLabel = label + ";" + spikelable;
                    graph.getData().get(i).getEntries().get(k).setLabel(newLabel);
                    ++spikecounter;
                }
            }
        }
    }

    public static void anotatePoints(GraphGroups gg, List<Integer> pointsIndexes, List<String> lables) {
        for (String key : gg.getGraphs().keySet()) {
            GraphData graph = gg.getGraphs().get(key);
            int trends = graph.getData().size();
            for (int i = 0; i < trends; ++i) {
                int progressive = 0;
                for (Integer index : pointsIndexes) {
                    String label = graph.getData().get(i).getEntries().get(index).getLabel();
                    String addinglabel = lables.get(progressive);
                    String newLabel = label;
                    if (addinglabel != null) {
                        newLabel = newLabel + ";" + addinglabel;
                    }
                    graph.getData().get(i).getEntries().get(index).setLabel(newLabel);
                    ++progressive;
                }
            }
        }
    }

    public static List<Point> getStationaryPoints(GraphData graph) throws Exception {
        ArrayList<Point> st = new ArrayList<Point>();
        Point<? extends Number, ? extends Number> p = graph.getData().get(0);
        st.add(new Point(p.getLabel(), p.getValue()));
        int yvalues = graph.getData().get(0).getEntries().size();
        double[] points = MathFunctions.points2Double(graph.getData(), 0, yvalues);
        double[] derivative = MathFunctions.derivative(points);
        boolean[] spikes = MathFunctions.findSpikes(derivative, threshold);
        for (int k = 0; k < yvalues; ++k) {
            if (!spikes[k]) continue;
            String label = graph.getData().get(0).getEntries().get(k).getLabel();
            Double val = points[k];
            ValueEntry<Double> v = new ValueEntry<Double>(label, val);
            ((Point)st.get(0)).addEntry(v);
        }
        return st;
    }

    public static List<String> getLablesFromPoints(Point points) throws Exception {
        ArrayList<String> lables = new ArrayList<String>();
        for (ValueEntry v : points.getEntries()) {
            lables.add(v.getLabel());
        }
        return lables;
    }

    public static List<String> getLabelsfromIndexes(List<Point<? extends Number, ? extends Number>> points, List<Integer> indexes) throws Exception {
        ArrayList<String> lables = new ArrayList<String>();
        int size = indexes.size();
        for (Integer index : indexes) {
            ValueEntry<? extends Number> v = points.get(0).getEntries().get(index);
            lables.add(v.getLabel());
        }
        return lables;
    }

    public static void sampleAnotationBySameFollower(List<Point<? extends Number, ? extends Number>> samples) throws Exception {
        String previousLabel = null;
        for (Point<? extends Number, ? extends Number> p : samples) {
            for (ValueEntry<? extends Number> v : p.getEntries()) {
                String label = v.getLabel();
                int indexcomma = label.indexOf(";");
                if (indexcomma < 0) continue;
                String labelcountry = label.substring(indexcomma + 1);
                if (previousLabel != null && labelcountry.equals(previousLabel)) {
                    label = label.substring(0, indexcomma);
                    v.setLabel(label);
                    continue;
                }
                previousLabel = labelcountry;
            }
        }
    }

    public static void sampleAnotationByRange(List<Point<? extends Number, ? extends Number>> samples, int range) throws Exception {
        if (range > 0) {
            for (Point<? extends Number, ? extends Number> p : samples) {
                int partialCounter = 0;
                for (ValueEntry<? extends Number> v : p.getEntries()) {
                    String label = v.getLabel();
                    int indexcomma = label.indexOf(";");
                    if (indexcomma >= 0) {
                        if (partialCounter <= range) {
                            String labelcountry = label.substring(indexcomma + 1);
                            label = label.substring(0, indexcomma);
                            v.setLabel(label);
                        } else {
                            partialCounter = 0;
                        }
                    }
                    ++partialCounter;
                }
            }
        }
    }
}

