/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataanalysis.ecoengine.evaluation;

import java.util.ArrayList;
import java.util.List;
import org.gcube.dataanalysis.ecoengine.datatypes.DatabaseType;
import org.gcube.dataanalysis.ecoengine.datatypes.InputTable;
import org.gcube.dataanalysis.ecoengine.datatypes.StatisticalType;
import org.gcube.dataanalysis.ecoengine.datatypes.enumtypes.TableTemplates;
import org.gcube.dataanalysis.ecoengine.evaluation.DiscrepancyAnalysis;

public class ClimateImpactAnalysis
extends DiscrepancyAnalysis {
    protected String SpeciesListTable = "ReferenceHSPEN";
    protected String LeftHSPEC = "LeftHSPEC";
    protected String RightHSPEC = "RightHSPEC";

    @Override
    public List<StatisticalType> getInputParameters() {
        ArrayList<TableTemplates> templatesHspen = new ArrayList<TableTemplates>();
        templatesHspen.add(TableTemplates.HSPEN);
        ArrayList<TableTemplates> templatesHspec = new ArrayList<TableTemplates>();
        templatesHspec.add(TableTemplates.HSPEC);
        InputTable hspec1 = new InputTable(templatesHspec, this.LeftHSPEC, "Left table containing a hspec distribution", "hspen");
        InputTable hspec2 = new InputTable(templatesHspec, this.RightHSPEC, "Right table containing a hspec distribution", "hspen");
        InputTable hspen = new InputTable(templatesHspen, this.SpeciesListTable, "Species List Table taken from envelopes", "hspen");
        ArrayList<StatisticalType> stlist = new ArrayList<StatisticalType>();
        stlist.add(hspec1);
        stlist.add(hspec2);
        stlist.add(hspen);
        DatabaseType.addDefaultDBPars(stlist);
        return stlist;
    }
}

