/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.contentmanagement.graphtools.core;

import com.rapidminer.RapidMiner;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.operator.preprocessing.sampling.AbsoluteSampling;
import com.rapidminer.tools.OperatorService;
import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.xml.DomDriver;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.gcube.contentmanagement.graphtools.abstracts.SamplesTable;
import org.gcube.contentmanagement.graphtools.core.filters.Filter;
import org.gcube.contentmanagement.graphtools.data.GraphSamplesTable;
import org.gcube.contentmanagement.graphtools.data.conversions.GraphConverter2D;
import org.gcube.contentmanagement.graphtools.data.databases.CommonDBExtractor;
import org.gcube.contentmanagement.lexicalmatcher.analysis.core.LexicalEngineConfiguration;
import org.gcube.contentmanagement.lexicalmatcher.utils.DatabaseFactory;
import org.gcube.portlets.user.timeseries.charts.support.types.GraphData;
import org.gcube.portlets.user.timeseries.charts.support.types.GraphGroups;
import org.gcube.portlets.user.timeseries.charts.support.types.Point;
import org.hibernate.SessionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StatisticsGenerator {
    private static Logger logger = LoggerFactory.getLogger(StatisticsGenerator.class);
    SessionFactory referenceDBSession;
    CommonDBExtractor extractor;
    private static final String LogFile = "ALog.properties";
    private static final String HibFile = "hibernate.cfg.xml";
    private static final String OperatorsFile = "operators.xml";
    private List<Filter> ColumnFilters;
    private Filter XRangeFilter;
    private Filter YRangeFilter;
    private XStream xStream;

    public void init(String cfgPath) throws Exception {
        this.init(cfgPath, null);
    }

    public SessionFactory getDBSession() {
        return this.referenceDBSession;
    }

    public void init(String cfgPath, LexicalEngineConfiguration config) throws Exception {
        this.referenceDBSession = config == null ? DatabaseFactory.initDBConnection(cfgPath + HibFile) : DatabaseFactory.initDBConnection(cfgPath + HibFile, config);
        this.ColumnFilters = new ArrayList<Filter>();
        this.extractor = new CommonDBExtractor(this.referenceDBSession);
        logger.info("StatisticsGenerator->initialization complete");
        System.setProperty("rapidminer.init.operators", cfgPath + OperatorsFile);
        this.xStream = new XStream((HierarchicalStreamDriver)new DomDriver());
        RapidMiner.init();
    }

    public void resetFilters() {
        this.ColumnFilters = new ArrayList<Filter>();
    }

    public void addColumnFilter(String column, String element, String operator) {
        this.ColumnFilters.add(new Filter(column, element, operator));
    }

    public void addColumnFilter(String column, String element) {
        this.ColumnFilters.add(new Filter(column, element));
    }

    public void addXRangeFilter(String xmin, String xmax) {
        this.XRangeFilter = new Filter(xmin, xmax);
    }

    public void addYRangeFilter(String ymin, String ymax) {
        this.YRangeFilter = new Filter(ymin, ymax);
    }

    public GraphGroups generateGraphs(int maxElements, String timeSeriesTable, String xDimension, String yDimension, String groupDimension, String speciesColumn, String ... filters) throws Exception {
        Map<String, SamplesTable> samplesMap = this.extractor.getMultiDimTemporalTables(this.ColumnFilters, this.YRangeFilter, timeSeriesTable, xDimension, groupDimension, yDimension, speciesColumn, filters);
        logger.info("StatisticsGenerator-> samplesMap has been generated");
        logger.trace(samplesMap.toString());
        AbsoluteSampling asop = (AbsoluteSampling)OperatorService.createOperator((String)"AbsoluteSampling");
        asop.setParameter("sample_size", "" + maxElements);
        asop.setParameter("local_random_seed", "-1");
        GraphGroups graphgroups = new GraphGroups();
        int i = 1;
        for (String key : samplesMap.keySet()) {
            GraphSamplesTable graphSamples;
            SamplesTable stable = samplesMap.get(key);
            List<Point<? extends Number, ? extends Number>> singlegraph = GraphConverter2D.transformTable(stable);
            if (this.XRangeFilter != null) {
                singlegraph = GraphConverter2D.filterXRange(singlegraph, this.XRangeFilter.getFirstElement(), this.XRangeFilter.getSecondElement());
            }
            if ((graphSamples = new GraphSamplesTable(singlegraph)).getNumOfDataRows() > maxElements) {
                ExampleSet es = graphSamples.generateExampleSet();
                es = asop.apply(es);
                graphSamples = new GraphSamplesTable();
                graphSamples.generateSampleTable(es);
                singlegraph = graphSamples.getGraph();
                logger.trace("Regeneration\n" + graphSamples.toString());
            }
            singlegraph = GraphConverter2D.reorder(singlegraph);
            logger.trace("Reordering\n" + singlegraph.toString());
            if (singlegraph == null || singlegraph.size() <= 0) continue;
            GraphData grd = new GraphData(singlegraph, true);
            graphSamples.calculateBounds();
            grd.setMaxY(graphSamples.maxY);
            grd.setMinY(graphSamples.minY);
            graphgroups.addGraph("Distribution for " + key, grd);
            logger.trace("StatisticsGenerator-> graphgroup " + i + " generated with key: " + key);
            ++i;
        }
        logger.info("StatisticsGenerator-> graphgroups have been generated");
        return graphgroups;
    }

    public String generateStringGraphs(int maxElements, String timeSeriesTable, String xDimension, String yDimension, String groupDimension, String speciesColumn, String ... filters) throws Exception {
        GraphGroups gg = this.generateGraphs(maxElements, timeSeriesTable, xDimension, yDimension, groupDimension, speciesColumn, filters);
        return this.xStream.toXML((Object)gg);
    }
}

