/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataanalysis.ecoengine.signals;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import org.gcube.contentmanagement.graphtools.utils.DateGuesser;
import org.gcube.dataanalysis.ecoengine.configuration.AlgorithmConfiguration;
import org.gcube.dataanalysis.ecoengine.signals.SignalProcessing;
import org.gcube.dataanalysis.ecoengine.utils.Operations;
import org.gcube.dataanalysis.ecoengine.utils.Tuple;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimeSeries {
    private static Logger logger = LoggerFactory.getLogger(TimeSeries.class);
    private double[] values;
    private Date[] times;
    private Date[] unsortedtimes;
    private String[] timeLabels;
    private long minimumtimegap = -1L;
    private String timepattern;
    AlgorithmConfiguration config;

    public TimeSeries(int timeLength, AlgorithmConfiguration config) {
        this.values = new double[timeLength];
        this.times = new Date[timeLength];
        this.unsortedtimes = new Date[timeLength];
        this.timeLabels = new String[timeLength];
        this.config = config;
    }

    public TimeSeries(double[] values, Date[] time, String[] timeLabels, AlgorithmConfiguration config) {
        this.values = values;
        this.times = time;
        this.unsortedtimes = Arrays.copyOf(time, time.length);
        this.timeLabels = timeLabels;
        this.config = config;
    }

    public void setValues(double[] values) {
        this.values = values;
    }

    public void setTime(Date[] time) {
        this.times = time;
    }

    public void setTimeLabels(String[] timeLabels) {
        this.timeLabels = timeLabels;
    }

    public double[] getValues() {
        return this.values;
    }

    public String[] getLabels() {
        return this.timeLabels;
    }

    public Date[] getTime() {
        return this.times;
    }

    public Date[] extendTime(int furtherPointsinTime) {
        Date[] time = new Date[this.times.length + furtherPointsinTime];
        for (int i = 0; i < this.times.length; ++i) {
            time[i] = this.times[i];
        }
        long lastDate = this.times[this.times.length - 1].getTime();
        for (int i = this.times.length; i < this.times.length + furtherPointsinTime; ++i) {
            time[i] = new Date(lastDate + (long)(i + 1 - this.times.length) * this.minimumtimegap);
        }
        return time;
    }

    public double[] getMillisecondsTimeline() {
        double[] secondstimes = new double[this.times.length];
        for (int i = 0; i < this.times.length; ++i) {
            long t = this.times[i].getTime();
            secondstimes[i] = t;
        }
        return secondstimes;
    }

    public long getMimimumTimeGapInMillisecs() {
        if (this.minimumtimegap > -1L) {
            return this.minimumtimegap;
        }
        long mintime = Long.MAX_VALUE;
        for (int i = 1; i < this.times.length; ++i) {
            long t0 = this.times[i - 1].getTime();
            long t1 = this.times[i].getTime();
            long timediff = Math.abs(t1 - t0);
            if (timediff >= mintime || timediff <= 0L) continue;
            mintime = timediff;
        }
        this.minimumtimegap = mintime;
        return mintime;
    }

    public void addElement(double value, Date date, String label, int index) {
        this.values[index] = value;
        this.times[index] = date;
        this.unsortedtimes[index] = date;
        this.timeLabels[index] = label;
    }

    public void sort() {
        Arrays.sort(this.times);
        double[] tempvalues = new double[this.values.length];
        String[] temptimeLabels = new String[this.timeLabels.length];
        List<Date> unsortedTimesList = Arrays.asList(this.unsortedtimes);
        int i = 0;
        for (Date time : this.times) {
            int index = unsortedTimesList.indexOf(time);
            tempvalues[i] = this.values[index];
            temptimeLabels[i] = this.timeLabels[index];
            ++i;
        }
        this.values = null;
        this.timeLabels = null;
        this.values = tempvalues;
        this.timeLabels = temptimeLabels;
        this.unsortedtimes = Arrays.copyOf(this.times, this.times.length);
    }

    public double getValue(int index) {
        return this.values[index];
    }

    public Date getDate(int index) {
        return this.times[index];
    }

    public String getTimeLabel(int index) {
        return this.timeLabels[index];
    }

    public static TimeSeries buildFromSignal(List<Tuple<String>> lines, AlgorithmConfiguration config) throws Exception {
        TimeSeries ts = new TimeSeries(lines.size(), config);
        int counter = 0;
        String timepattern = null;
        DateFormat sdf = null;
        for (Tuple<String> line : lines) {
            String timel = line.getElements().get(0);
            timel = timel.replace("time:", "");
            Double quantity = Double.parseDouble(line.getElements().get(1));
            Date time = null;
            if (counter == 0) {
                timepattern = DateGuesser.getPattern(timel);
                ts.setTimepattern(timepattern);
                logger.debug("Time pattern: " + timepattern);
                sdf = new SimpleDateFormat(timepattern, Locale.ENGLISH);
            }
            try {
                time = sdf.parse(timel);
            }
            catch (Exception e) {
                logger.debug("Error in parsing...adjusting " + timel);
                time = DateGuesser.convertDate(timel).getTime();
                logger.debug("Error in parsing...adjusting " + timel + " in " + time);
            }
            if (counter == 0) {
                logger.debug("Date detection: input " + timel + " output " + time);
            }
            ts.addElement(quantity, time, timel, counter);
            ++counter;
        }
        ts.sort();
        return ts;
    }

    public void convertToUniformSignal(double samplingrate) throws Exception {
        if (samplingrate <= 0.0) {
            if (this.minimumtimegap < 0L) {
                this.getMimimumTimeGapInMillisecs();
            }
            if (this.minimumtimegap > 0L) {
                samplingrate = 1.0 / (double)this.minimumtimegap;
            }
        }
        logger.debug("TimeSeries->Samplig rate: " + samplingrate + " minimum gap in time: " + this.minimumtimegap);
        if (samplingrate == 0.0) {
            return;
        }
        double[] timeline = this.getMillisecondsTimeline();
        logger.debug("TimeSeries->filling gaps");
        double[] newvalues = SignalProcessing.fillTimeSeries(this.values, timeline, samplingrate, this.config);
        if (newvalues.length != this.values.length) {
            logger.debug("TimeSeries->filling also time values");
            Date[] newtimeline = SignalProcessing.fillTimeLine(timeline, samplingrate, this.config);
            this.values = null;
            this.times = null;
            this.unsortedtimes = null;
            this.values = newvalues;
            this.times = newtimeline;
            this.unsortedtimes = newtimeline;
            this.timeLabels = new String[this.times.length];
        }
        logger.debug("TimeSeries->Returning values");
        this.timeLabels = new String[this.times.length];
        SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yyyy HH:mm", Locale.ROOT);
        for (int i = 0; i < this.times.length; ++i) {
            this.timeLabels[i] = sdf.format(this.times[i]);
        }
    }

    public void normalize() throws Exception {
        double max = Operations.getMax(this.values);
        for (int i = 0; i < this.values.length; ++i) {
            this.values[i] = this.values[i] / max;
        }
    }

    public String getTimepattern() {
        return this.timepattern;
    }

    public void setTimepattern(String timepattern) {
        this.timepattern = timepattern;
    }
}

