/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.contentmanagement.lexicalmatcher.utils;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.util.List;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilderFactory;
import org.gcube.contentmanagement.lexicalmatcher.analysis.core.LexicalEngineConfiguration;
import org.gcube.contentmanagement.lexicalmatcher.utils.FileTools;
import org.hibernate.SessionFactory;
import org.hibernate.cfg.Configuration;
import org.hibernate.classic.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatabaseFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(DatabaseFactory.class);

    public static SessionFactory initDBConnection(String configurationFile) throws Exception {
        String xml = FileTools.readXMLDoc(configurationFile);
        LOGGER.debug("initialising DB Connection with conf: {} ", (Object)xml);
        SessionFactory DBSessionFactory = null;
        Configuration cfg = new Configuration();
        cfg = cfg.configure(DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new ByteArrayInputStream(xml.getBytes())));
        DBSessionFactory = cfg.buildSessionFactory();
        return DBSessionFactory;
    }

    public static SessionFactory initDBConnection(String configurationFile, LexicalEngineConfiguration config) throws Exception {
        LOGGER.debug("init DB configuration from {}", (Object)configurationFile);
        if (config == null) {
            return DatabaseFactory.initDBConnection(configurationFile);
        }
        LOGGER.debug("config is not null !!");
        Configuration cfg = new Configuration();
        try (FileInputStream stream = new FileInputStream(new File(configurationFile));){
            cfg = cfg.configure(DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(stream));
        }
        if (config.getDatabaseDriver() != null && config.getDatabaseDriver().length() > 0) {
            cfg.setProperty("hibernate.connection.driver_class", config.getDatabaseDriver());
        } else {
            config.setDatabaseDriver(cfg.getProperty("hibernate.connection.driver_class"));
        }
        if (config.getDatabaseURL() != null && config.getDatabaseURL().length() > 0) {
            cfg.setProperty("hibernate.connection.url", config.getDatabaseURL());
        } else {
            config.setDatabaseURL(cfg.getProperty("hibernate.connection.url"));
        }
        if (config.getDatabaseUserName() != null && config.getDatabaseUserName().length() > 0) {
            cfg.setProperty("hibernate.connection.username", config.getDatabaseUserName());
        } else {
            config.setDatabaseUserName(cfg.getProperty("hibernate.connection.username"));
        }
        if (config.getDatabasePassword() != null && config.getDatabasePassword().length() > 0) {
            cfg.setProperty("hibernate.connection.password", config.getDatabasePassword());
        } else {
            config.setDatabasePassword(cfg.getProperty("hibernate.connection.password"));
        }
        if (config.getDatabaseDialect() != null && config.getDatabaseDialect().length() > 0) {
            cfg.setProperty("hibernate.dialect", config.getDatabaseDialect());
        } else {
            config.setDatabaseDialect(cfg.getProperty("hibernate.dialect"));
        }
        if (config.getDatabaseIdleConnectionTestPeriod() != null) {
            cfg.setProperty("hibernate.c3p0.idleConnectionTestPeriod", config.getDatabaseIdleConnectionTestPeriod());
        } else {
            config.setDatabaseIdleConnectionTestPeriod(cfg.getProperty("hibernate.c3p0.idleConnectionTestPeriod"));
        }
        if (config.getDatabaseAutomaticTestTable() != null) {
            cfg.setProperty("hibernate.c3p0.automaticTestTable", config.getDatabaseAutomaticTestTable());
        } else {
            config.setDatabaseAutomaticTestTable(cfg.getProperty("hibernate.c3p0.automaticTestTable"));
        }
        cfg.setProperty("hibernate.hbm2ddl.auto", "create");
        Properties props = cfg.getProperties();
        LOGGER.debug("properties for this connection are url: {}  user: {}", props.get("hibernate.connection.url"), (Object)props.getProperty("hibernate.connection.username"));
        SessionFactory DBSessionFactory = null;
        DBSessionFactory = cfg.buildSessionFactory();
        return DBSessionFactory;
    }

    public static List<Object> executeHQLQuery(String query, SessionFactory DBSessionFactory, boolean useSQL) {
        List obj = null;
        Session ss = null;
        try {
            ss = DBSessionFactory.getCurrentSession();
            ss.beginTransaction();
            Object qr = null;
            qr = useSQL ? ss.createSQLQuery(query) : ss.createQuery(query);
            List result = qr.list();
            ss.getTransaction().commit();
            if (result != null && result.size() != 0) {
                obj = result;
            }
        }
        catch (Throwable e) {
            LOGGER.error(String.format("Error while executing query: %1$s ", query), e);
            DatabaseFactory.rollback((org.hibernate.Session)ss);
        }
        return obj;
    }

    public static void executeHQLUpdate(String query, SessionFactory DBSessionFactory, boolean useSQL) throws Exception {
        Session ss = null;
        try {
            ss = DBSessionFactory.getCurrentSession();
            ss.beginTransaction();
            Object qr = null;
            qr = useSQL ? ss.createSQLQuery(query) : ss.createQuery(query);
            qr.executeUpdate();
            ss.getTransaction().commit();
        }
        catch (Throwable e) {
            DatabaseFactory.rollback((org.hibernate.Session)ss);
            LOGGER.error("ERROR IN UPDATE: ", e);
            throw e;
        }
    }

    public static void executeSQLUpdate(String query, SessionFactory DBSessionFactory) throws Exception {
        DatabaseFactory.executeHQLUpdate(query, DBSessionFactory, true);
    }

    public static List<Object> executeSQLQuery(String query, SessionFactory DBSessionFactory) {
        return DatabaseFactory.executeHQLQuery(query, DBSessionFactory, true);
    }

    public static void rollback(org.hibernate.Session ss) {
        try {
            if (ss != null && ss.getTransaction() != null) {
                ss.getTransaction().rollback();
            }
        }
        catch (Exception exception) {
        }
        finally {
            try {
                ss.close();
            }
            catch (Exception exception) {}
        }
    }

    public static void saveObject(Object obj, SessionFactory DBSessionFactory) throws Exception {
        if (DBSessionFactory != null) {
            Session ss = null;
            try {
                ss = DBSessionFactory.getCurrentSession();
                ss.beginTransaction();
                ss.saveOrUpdate(obj);
                ss.getTransaction().commit();
            }
            catch (Exception e) {
                DatabaseFactory.rollback((org.hibernate.Session)ss);
                throw e;
            }
        }
    }
}

