/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataanalysis.ecoengine.signals;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.table.MemoryExampleTable;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.JPanel;
import marytts.signalproc.display.SpectrogramCustom;
import marytts.signalproc.window.Window;
import org.gcube.contentmanagement.graphtools.data.BigSamplesTable;
import org.gcube.contentmanagement.graphtools.utils.MathFunctions;
import org.gcube.contentmanagement.lexicalmatcher.utils.AnalysisLogger;
import org.gcube.dataanalysis.ecoengine.signals.Delta;
import org.gcube.dataanalysis.ecoengine.signals.SignalProcessing;
import org.gcube.dataanalysis.ecoengine.transducers.TimeSeriesAnalysis;
import org.gcube.dataanalysis.ecoengine.utils.Operations;

public class SignalConverter {
    public double[] averagepower;
    ArrayList<Double>[] currentSpikesPowerSpectra;
    public int startStableTractIdx = -1;
    public int endStableTractIdx = -1;

    public static double[][] addDeltaDouble(double[][] features) throws Exception {
        int vectorL = features[0].length;
        double[][] delta = new double[features.length][features[0].length * 3];
        for (int k = 0; k < features.length; ++k) {
            for (int g = 0; g < vectorL; ++g) {
                delta[k][g] = features[k][g];
            }
        }
        Delta.calcDelta(delta, vectorL);
        Delta.calcDoubleDelta(delta, vectorL);
        return delta;
    }

    public static double centerFreq(int i, double samplingRate, double lowerFilterFreq, int numMelFilters) {
        double[] mel = new double[]{SignalConverter.freqToMel(lowerFilterFreq), SignalConverter.freqToMel(samplingRate / 2.0)};
        double temp = mel[0] + (mel[1] - mel[0]) / (double)(numMelFilters + 1) * (double)i;
        return SignalConverter.inverseMel(temp);
    }

    public static double[] cepCoefficients(double[] f, int numCepstra, int numFilters) {
        double[] cepc = new double[numCepstra];
        for (int i = 0; i < cepc.length; ++i) {
            for (int j = 1; j <= numFilters; ++j) {
                int n = i;
                cepc[n] = cepc[n] + f[j - 1] * Math.cos(Math.PI * (double)i / (double)numFilters * ((double)j - 0.5));
            }
        }
        return cepc;
    }

    public static BufferedImage createImage(JPanel panel, int w, int h) {
        BufferedImage bi = new BufferedImage(w, h, 1);
        Graphics2D g = bi.createGraphics();
        panel.paint(g);
        return bi;
    }

    public static double[][] cutSpectrum(double[][] spectrum, float minFreq, float maxfreq, int fftWindowSize, int samplingRate) {
        int minFrequencyIndex = SignalConverter.frequencyIndex(minFreq, fftWindowSize, samplingRate);
        int maxFrequencyIndex = SignalConverter.frequencyIndex(maxfreq, fftWindowSize, samplingRate);
        double[][] cutSpectrum = new double[spectrum.length][maxFrequencyIndex - minFrequencyIndex + 1];
        for (int i = 0; i < spectrum.length; ++i) {
            cutSpectrum[i] = Arrays.copyOfRange(spectrum[i], minFrequencyIndex, maxFrequencyIndex);
        }
        return cutSpectrum;
    }

    public static void exampleSet2Signal(double[] rebuiltSignal, ExampleSet es, Double fillerValueFormissingEntries) {
        MemoryExampleTable met = (MemoryExampleTable)es.getExampleTable();
        int numCol = met.getAttributeCount();
        int numRows = met.size();
        Attribute labelAtt = met.getAttribute(numCol - 1);
        for (int i = 0; i < numRows; ++i) {
            int index = (int)met.getDataRow(i).get(labelAtt);
            String label = labelAtt.getMapping().mapIndex(index);
            int id = Integer.parseInt(label);
            Example e = es.getExample(i);
            for (Attribute a : e.getAttributes()) {
                Double value = e.getValue(a);
                if (value.equals(Double.NaN) && !fillerValueFormissingEntries.equals(Double.NaN)) {
                    value = fillerValueFormissingEntries;
                }
                rebuiltSignal[id] = value;
            }
        }
    }

    public static void exampleSet2Signal(double[] rebuiltSignal, ExampleSet es) {
        SignalConverter.exampleSet2Signal(rebuiltSignal, es, null);
    }

    public static int[] fftBinIndices(double samplingRate, int frameSize, int numMelFilters, int numFequencies, float lowerFilterFreq, float upperFilterFreq) {
        int[] cbin = new int[numFequencies + 2];
        AnalysisLogger.getLogger().debug((Object)("New Filter banks: " + numFequencies));
        cbin[0] = (int)Math.round((double)lowerFilterFreq / samplingRate * (double)frameSize);
        cbin[cbin.length - 1] = SignalConverter.frequencyIndex(upperFilterFreq, frameSize, (float)samplingRate);
        AnalysisLogger.getLogger().debug((Object)("F0: " + lowerFilterFreq));
        for (int i = 1; i <= numFequencies; ++i) {
            double fc = SignalConverter.centerFreq(i, samplingRate, lowerFilterFreq, numMelFilters);
            AnalysisLogger.getLogger().debug((Object)("F" + i + ": " + fc));
            cbin[i] = (int)Math.round(fc / samplingRate * (double)frameSize);
        }
        AnalysisLogger.getLogger().debug((Object)("F" + (cbin.length - 1) + ": " + upperFilterFreq));
        return cbin;
    }

    public static int[] fftBinIndices(double samplingRate, int frameSize, int numMelFilters, float lowerFilterFreq) {
        int[] cbin = new int[numMelFilters + 2];
        cbin[0] = (int)Math.round((double)lowerFilterFreq / samplingRate * (double)frameSize);
        cbin[cbin.length - 1] = frameSize / 2;
        for (int i = 1; i <= numMelFilters; ++i) {
            double fc = SignalConverter.centerFreq(i, samplingRate, lowerFilterFreq, numMelFilters);
            cbin[i] = (int)Math.round(fc / samplingRate * (double)frameSize);
        }
        return cbin;
    }

    public static double freqToMel(double freq) {
        return 2595.0 * SignalConverter.log10(1.0 + freq / 700.0);
    }

    public static int frequencyIndex(float frequency, int fftSize, float samplingRate) {
        return Math.round(frequency * (float)fftSize / samplingRate);
    }

    public static double[] generateSinSignal(int signalLength, float timeShift, float frequency) {
        double[] samples = new double[signalLength];
        float time = 0.0f;
        for (int i = 0; i < samples.length; ++i) {
            samples[i] = (float)Math.sin(Math.PI * 2 * (double)frequency * (double)time);
            time += timeShift;
        }
        return samples;
    }

    public static double inverseMel(double x) {
        double temp = Math.pow(10.0, x / 2595.0) - 1.0;
        return 700.0 * temp;
    }

    public static double log10(double value) {
        return Math.log(value) / Math.log(10.0);
    }

    public static double[] melFilter(double[] bin, int[] cbin, int numMelFilters) {
        double[] temp = new double[numMelFilters + 2];
        for (int k = 1; k <= numMelFilters; ++k) {
            int i;
            double num1 = 0.0;
            double num2 = 0.0;
            for (i = cbin[k - 1]; i <= cbin[k]; ++i) {
                num1 += (double)((i - cbin[k - 1] + 1) / (cbin[k] - cbin[k - 1] + 1)) * bin[i];
            }
            for (i = cbin[k] + 1; i <= cbin[k + 1]; ++i) {
                num2 += (double)(1 - (i - cbin[k]) / (cbin[k + 1] - cbin[k] + 1)) * bin[i];
            }
            temp[k] = num1 + num2;
        }
        double[] fbank = new double[numMelFilters];
        for (int i = 0; i < numMelFilters; ++i) {
            fbank[i] = temp[i + 1];
        }
        return fbank;
    }

    public static int recalculateMaxMelFilters(double samplingRate, int numMelFilters, float lowerFilterFreq, float maxFilterFreq) {
        int bestIndex = 1;
        for (int i = 1; i <= numMelFilters; ++i) {
            double fc = SignalConverter.centerFreq(i, samplingRate, lowerFilterFreq, numMelFilters);
            AnalysisLogger.getLogger().debug((Object)("fc " + fc));
            if (!(fc > (double)maxFilterFreq)) continue;
            bestIndex = i;
            break;
        }
        return bestIndex - 1;
    }

    public static double sample2Time(int sample, int sampleRate) {
        return (double)sample / (double)sampleRate;
    }

    public static double[] signalTimeLine(int signalLength, double samplingRate) {
        double[] time = new double[signalLength];
        Arrays.fill(time, Double.NaN);
        for (int i = 0; i < signalLength; ++i) {
            time[i] = (double)i / samplingRate;
        }
        AnalysisLogger.getLogger().debug((Object)("time " + time[signalLength - 1] * samplingRate + " vs " + signalLength));
        return time;
    }

    public static float spectrumTime(float linearTime, float windowShiftTime) {
        return linearTime / windowShiftTime;
    }

    public static ExampleSet signal2ExampleSet(double[] signal) {
        BigSamplesTable samples = new BigSamplesTable();
        for (int k = 0; k < signal.length; ++k) {
            samples.addSampleRow("" + k, signal[k]);
        }
        AnalysisLogger.getLogger().debug((Object)"Example Set Created");
        return samples.generateExampleSet();
    }

    public static double[][] spectrogram(String name, double[] signal, int samplingRate, int windowshift, int frameslength, boolean display) throws Exception {
        SpectrogramCustom spec = new SpectrogramCustom(signal, samplingRate, Window.get((int)1, (int)frameslength), windowshift, frameslength, 640, 480);
        double[][] spectrum = (double[][])spec.spectra.toArray((T[])new double[spec.spectra.size()][]);
        if (display) {
            spec.showInJFrame(name, true, true);
        }
        return spectrum;
    }

    public static void displaySpectrogram(double[][] spectrum, double[] signal, String name, int samplingRate, int windowshift, int frameslength) throws Exception {
        SpectrogramCustom spec = new SpectrogramCustom(signal, samplingRate, Window.get((int)1, (int)frameslength), windowshift, frameslength, 640, 480);
        spec.spectra = new ArrayList<double[]>();
        for (int i = 0; i < spectrum.length; ++i) {
            spec.spectra.add(spectrum[i]);
        }
        spec.showInJFrame(name, true, true);
    }

    public static float spectrogramTimeFromIndex(int index, float windowShiftTime) {
        return (float)index * windowShiftTime;
    }

    public static int spectrogramIndex(float linearTime, float windowShiftTime) {
        return (int)(linearTime / windowShiftTime);
    }

    public static int time2Sample(double time, int sampleRate) {
        return (int)(time * (double)sampleRate);
    }

    public double[] takeMaxFrequenciesInSpectrogram(double[][] spectrogram, int samplingRate, int windowSamples, float minfreq) {
        double[] maxs = new double[spectrogram.length];
        this.averagepower = new double[spectrogram.length];
        int j = 0;
        if (TimeSeriesAnalysis.display) {
            for (int g = 0; g < spectrogram.length; ++g) {
                SignalProcessing.displaySignalWithGenericTime(spectrogram[g], 0.0f, 1.0f, "spectrum " + (g + 1));
            }
        }
        double tolerance = 0.05;
        for (double[] slice : spectrogram) {
            int bestidx = 0;
            double max = -1.7976931348623157E308;
            double min = Double.MAX_VALUE;
            boolean overfirstmin = false;
            for (int k = 1; k < slice.length; ++k) {
                double ele = slice[k];
                if (!overfirstmin && slice[k] > slice[k - 1]) {
                    AnalysisLogger.getLogger().debug((Object)("First minimum in spectrum is at idx " + k));
                    overfirstmin = true;
                }
                if (!overfirstmin) continue;
                if (ele > max + Math.abs(max) * tolerance) {
                    max = ele;
                    bestidx = k;
                }
                if (!(ele < min - Math.abs(min) * tolerance)) continue;
                min = ele;
            }
            int minFidx = SignalConverter.frequencyIndex(minfreq, windowSamples, samplingRate);
            maxs[j] = SignalConverter.spectrumIdx2Frequency(minFidx + bestidx, samplingRate, windowSamples);
            double mean = MathFunctions.mean(slice);
            AnalysisLogger.getLogger().debug((Object)("max freq in spec: " + maxs[j] + " index " + minFidx + bestidx));
            if (min == Double.MAX_VALUE) {
                min = max;
            }
            if (max == -1.7976931348623157E308) {
                this.averagepower[j] = 0.0;
            } else {
                mean -= min;
                this.averagepower[j] = (max -= min) == 0.0 ? 0.0 : Math.abs((max - mean) / max);
            }
            AnalysisLogger.getLogger().debug((Object)("max power : " + max + " min power: " + min + " mean " + mean + " power " + this.averagepower[j]));
            ++j;
        }
        return maxs;
    }

    public ArrayList<Double>[] takePeaksInSpectrogramFrames(double[][] spectrogram, int samplingRate, int windowSamples, float minfreq) {
        ArrayList[] maxs = new ArrayList[spectrogram.length];
        ArrayList[] powers = new ArrayList[spectrogram.length];
        if (TimeSeriesAnalysis.display) {
            for (int g = 0; g < spectrogram.length; ++g) {
                SignalProcessing.displaySignalWithGenericTime(spectrogram[g], 0.0f, 1.0f, "spectrum " + (g + 1));
            }
        }
        int minFidx = SignalConverter.frequencyIndex(minfreq, windowSamples, samplingRate);
        for (int j = 0; j < spectrogram.length; ++j) {
            double[] slice = spectrogram[j];
            double maxAmp = Operations.getMax(slice);
            double minAmp = Operations.getMin(slice);
            double refAmplitude = 0.0;
            refAmplitude = maxAmp != slice[0] ? slice[0] - minAmp : MathFunctions.mean(slice) - minAmp;
            ArrayList<Double> maxFreqs = new ArrayList<Double>();
            ArrayList<Double> localpowers = new ArrayList<Double>();
            double[] derivSlice = MathFunctions.derivative(slice);
            boolean[] spikes = MathFunctions.findMaxima(derivSlice, 0.001);
            for (int i = 0; i < spikes.length; ++i) {
                int g;
                if (!spikes[i]) continue;
                maxFreqs.add(Double.valueOf(SignalConverter.spectrumIdx2Frequency(minFidx + i, samplingRate, windowSamples)));
                int round = Math.max(slice.length / 10, 1);
                double roundmean = 0.0;
                for (g = 1; g <= round; ++g) {
                    if (i - g < 0) continue;
                    roundmean = roundmean + slice[i - g] - minAmp;
                }
                for (g = 1; g <= round; ++g) {
                    if (i + g >= slice.length) continue;
                    roundmean = roundmean + slice[i + g] - minAmp;
                }
                double power = (slice[i] - minAmp) / (roundmean /= 2.0 * (double)round);
                localpowers.add(power);
            }
            powers[j] = localpowers;
            maxs[j] = maxFreqs;
        }
        this.currentSpikesPowerSpectra = powers;
        return maxs;
    }

    public double[] takeLongestStableTract(double[] signal, double valuedifftoleranceperc) {
        int[] bestcouple;
        ArrayList<int[]> pairs = new ArrayList<int[]>();
        int idx1 = -1;
        int[] pair = null;
        for (int i = 1; i < signal.length; ++i) {
            if (idx1 == -1) {
                idx1 = 1;
                pair = new int[]{i - 1, i - 1};
            }
            if (Math.abs(signal[i] - signal[i - 1]) / Math.max(signal[i], signal[i - 1]) <= valuedifftoleranceperc) {
                pair[1] = i;
                continue;
            }
            idx1 = -1;
            pairs.add(pair);
        }
        if (idx1 > -1) {
            pairs.add(pair);
        }
        int best = 0;
        int maxsize = 0;
        int k = 0;
        for (int[] setcouple : pairs) {
            int diff = setcouple[1] - setcouple[0];
            if (diff > maxsize) {
                maxsize = diff;
                best = k;
            }
            ++k;
        }
        if (pairs.size() == 0) {
            pairs.add(new int[]{0, 1});
        }
        if ((bestcouple = (int[])pairs.get(best))[1] == bestcouple[0]) {
            bestcouple[1] = bestcouple[0] + 1;
        }
        double[] subsignal = new double[bestcouple[1] - bestcouple[0]];
        AnalysisLogger.getLogger().debug((Object)("Longest range: from " + bestcouple[0] + " to " + bestcouple[1]));
        this.startStableTractIdx = bestcouple[0];
        this.endStableTractIdx = bestcouple[1];
        int l = 0;
        for (int i = bestcouple[0]; i < bestcouple[1]; ++i) {
            subsignal[l] = signal[i];
            ++l;
        }
        return subsignal;
    }

    public static float spectrumIdx2Frequency(int idx, int samplingRate, int windowsSizeSamples) {
        return (float)idx * (float)samplingRate / (1.0f * (float)(windowsSizeSamples - 1));
    }

    public static int spectrumFreq2Idx(float freq, int samplingRate, int windowsSizeSamples) {
        return Math.round((float)(windowsSizeSamples - 1) * 1.0f * freq / (float)samplingRate);
    }
}

