/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataanalysis.geo.wps.factory;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.opengis.wps.x100.ProcessBriefType;
import org.gcube.contentmanagement.lexicalmatcher.utils.AnalysisLogger;
import org.gcube.dataanalysis.ecoengine.configuration.AlgorithmConfiguration;
import org.gcube.dataanalysis.ecoengine.interfaces.DynamicTransducer;
import org.gcube.dataanalysis.ecoengine.interfaces.Transducerer;
import org.gcube.dataanalysis.executor.util.InfraRetrieval;
import org.gcube.dataanalysis.geo.wps.client.WPSClient;
import org.gcube.dataanalysis.geo.wps.interfaces.WPSProcess;

public class DynamicWPSTransducerer
implements DynamicTransducer {
    static Map<String, Transducerer> transducerersP = null;
    static long t0 = System.currentTimeMillis();
    static long maxtime = 0x6DDD00L;

    public Map<String, Transducerer> getTransducers(AlgorithmConfiguration config) {
        if (transducerersP != null && !DynamicWPSTransducerer.isTooMuchTime()) {
            return transducerersP;
        }
        LinkedHashMap<String, Transducerer> transducerers = new LinkedHashMap<String, Transducerer>();
        List<String> wpsendpoints = DynamicWPSTransducerer.getWPSendpoints(config);
        try {
            for (String wpsendpoint : wpsendpoints) {
                try {
                    ProcessBriefType[] wpsProcesses;
                    WPSClient client = new WPSClient(wpsendpoint);
                    client.requestGetCapabilities();
                    ProcessBriefType[] processBriefTypeArray = wpsProcesses = client.getProcessesList();
                    int n = wpsProcesses.length;
                    int n2 = 0;
                    while (n2 < n) {
                        ProcessBriefType processInfo = processBriefTypeArray[n2];
                        WPSProcess process = new WPSProcess(wpsendpoint, processInfo.getIdentifier().getStringValue());
                        process.setConfiguration(config);
                        transducerers.put(processInfo.getTitle().getStringValue(), process);
                        ++n2;
                    }
                }
                catch (Throwable e) {
                    AnalysisLogger.getLogger().debug((Object)("Error in connecting to: " + wpsendpoint + " .. skipping connection"));
                    AnalysisLogger.getLogger().debug((Object)("Error is " + e.getLocalizedMessage()));
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            AnalysisLogger.getLogger().debug((Object)("Error in retrieving information by WPS Server: " + e.getLocalizedMessage()));
        }
        if (transducerers.size() > 0) {
            transducerersP = transducerers;
        }
        return transducerers;
    }

    public static boolean isTooMuchTime() {
        if (System.currentTimeMillis() - t0 > maxtime) {
            t0 = System.currentTimeMillis();
            return true;
        }
        return false;
    }

    public static List<String> getWPSendpoints(AlgorithmConfiguration config) {
        List<String> wps = new ArrayList();
        AnalysisLogger.setLogger((String)(String.valueOf(config.getConfigPath()) + AlgorithmConfiguration.defaultLoggerFile));
        wps = InfraRetrieval.retrieveAddresses((String)"WPS", (String)config.getGcubeScope(), (String)"StatisticalManager");
        if (wps != null && wps.size() > 0) {
            AnalysisLogger.getLogger().debug((Object)("WPS: found " + wps.size() + " wps instances"));
        }
        return wps;
    }
}

