/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataanalysis.geo.wps.interfaces;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.opengis.wps.x100.ComplexDataType;
import net.opengis.wps.x100.ExecuteResponseDocument;
import net.opengis.wps.x100.InputDescriptionType;
import net.opengis.wps.x100.OutputDataType;
import net.opengis.wps.x100.OutputDescriptionType;
import net.opengis.wps.x100.ProcessDescriptionType;
import net.opengis.wps.x100.SupportedComplexDataInputType;
import org.gcube.contentmanagement.lexicalmatcher.utils.AnalysisLogger;
import org.gcube.dataanalysis.ecoengine.configuration.AlgorithmConfiguration;
import org.gcube.dataanalysis.ecoengine.configuration.INFRASTRUCTURE;
import org.gcube.dataanalysis.ecoengine.datatypes.PrimitiveType;
import org.gcube.dataanalysis.ecoengine.datatypes.StatisticalType;
import org.gcube.dataanalysis.ecoengine.datatypes.enumtypes.PrimitiveTypes;
import org.gcube.dataanalysis.ecoengine.interfaces.Transducerer;
import org.gcube.dataanalysis.ecoengine.utils.ResourceFactory;
import org.gcube.dataanalysis.geo.wps.client.WPSClient;
import org.gcube.dataanalysis.geo.wps.factory.DynamicWPSTransducerer;
import org.n52.wps.client.ExecuteRequestBuilder;

public class WPSProcess
implements Transducerer {
    public String wpsurl;
    public String processid;
    public String title;
    public String processAbstract;
    private List<StatisticalType> inputTypes;
    private LinkedHashMap<String, StatisticalType> outputTypes;
    private InputDescriptionType[] wpsInputs;
    private OutputDescriptionType[] wpsOutputs;
    private ProcessDescriptionType processDescription;
    private WPSClient currentProcess;
    public static Map<String, WPSClient> inputsCache;
    protected ResourceFactory resourceManager;
    private AlgorithmConfiguration config;
    float status = 0.0f;

    public WPSProcess(String wpsurl, String processid) {
        this.wpsurl = wpsurl;
        this.processid = processid;
    }

    public void compute() throws Exception {
        this.status = 0.0f;
        try {
            OutputDataType[] outputData;
            WPSClient client;
            ExecuteRequestBuilder executeBuilder = new ExecuteRequestBuilder(this.processDescription);
            for (InputDescriptionType input : this.wpsInputs) {
                String value = this.config.getParam(input.getIdentifier().getStringValue());
                if (value == null || value.trim().length() <= 0) continue;
                String[] values = value.split(AlgorithmConfiguration.getListSeparator());
                if (values.length == 0) {
                    values = new String[]{value};
                }
                if (input.isSetLiteralData()) {
                    AnalysisLogger.getLogger().debug((Object)("Configuring Literal: " + input.getIdentifier().getStringValue() + " to: " + value));
                    for (String v : values) {
                        executeBuilder.addLiteralData(input.getIdentifier().getStringValue(), v);
                    }
                    continue;
                }
                if (input.isSetBoundingBoxData()) {
                    AnalysisLogger.getLogger().debug((Object)("Configuring Bounding Box: " + input.getIdentifier().getStringValue() + " to: " + value));
                    AnalysisLogger.getLogger().debug((Object)input);
                    for (String v : values) {
                        WPSClient.addBoundingBoxInput(executeBuilder, input.getIdentifier().getStringValue(), v);
                    }
                    continue;
                }
                AnalysisLogger.getLogger().debug((Object)("Configuring Complex: " + input.getIdentifier().getStringValue() + " to: " + value));
                SupportedComplexDataInputType complex = input.getComplexData();
                for (String v : values) {
                    executeBuilder.addComplexDataReference(input.getIdentifier().getStringValue(), v, complex.getDefault().getFormat().getSchema(), complex.getDefault().getFormat().getEncoding(), complex.getDefault().getFormat().getMimeType());
                }
            }
            this.currentProcess = client = new WPSClient(this.wpsurl);
            AnalysisLogger.getLogger().debug((Object)"Starting Process");
            ExecuteResponseDocument.ExecuteResponse.ProcessOutputs outs = client.executeProcess(executeBuilder, this.processDescription);
            AnalysisLogger.getLogger().debug((Object)"Process Executed");
            if (outs == null) {
                throw new Exception("Error during the execution of the WPS process: returned an empty document");
            }
            for (OutputDataType out : outputData = outs.getOutputArray()) {
                StatisticalType stype;
                String outputID = out.getIdentifier().getStringValue();
                String value = "";
                if (out.getData().isSetLiteralData()) {
                    value = out.getData().getLiteralData().getStringValue();
                    stype = this.outputTypes.get(outputID);
                    if (stype == null) continue;
                    ((PrimitiveType)stype).setContent((Object)value);
                    AnalysisLogger.getLogger().debug((Object)("Assigning value: " + value + " to output named: " + outputID));
                    continue;
                }
                if (out.getData().isSetComplexData()) {
                    if (out.getReference() != null) {
                        value = out.getReference().getHref();
                        stype = this.outputTypes.get(outputID);
                        if (stype != null) {
                            ((PrimitiveType)stype).setContent((Object)value);
                            AnalysisLogger.getLogger().debug((Object)("Assigning value: " + value + " to output named: " + outputID));
                        }
                    } else {
                        this.outputTypes.remove(outputID);
                    }
                    ComplexDataType cdt = out.getData().getComplexData();
                    List<String> urls = WPSClient.retrieveURLsFromWPSResponse(cdt);
                    int counter = 1;
                    for (String url : urls) {
                        AnalysisLogger.getLogger().debug((Object)("Adding OBJ:" + url));
                        this.outputTypes.put("OUT_" + counter, (StatisticalType)new PrimitiveType(String.class.getName(), (Object)url, PrimitiveTypes.STRING, "OUT", "", ""));
                        ++counter;
                    }
                    continue;
                }
                value = out.getData().getLiteralData().getStringValue();
            }
        }
        catch (Exception e) {
            String exceptiontext = WPSClient.getExceptionText(e.getLocalizedMessage());
            AnalysisLogger.getLogger().debug((Object)("WPSProcess->Returning Exception to the SM:" + exceptiontext));
            throw new Exception(exceptiontext);
        }
        finally {
            this.status = 100.0f;
        }
    }

    public void init() throws Exception {
        WPSClient wpsclient = null;
        if (inputsCache != null) {
            wpsclient = inputsCache.get(this.processid);
        } else {
            inputsCache = new HashMap<String, WPSClient>();
        }
        if (wpsclient == null) {
            try {
                wpsclient = new WPSClient(this.wpsurl);
                wpsclient.describeProcess(this.processid);
                inputsCache.put(this.processid, wpsclient);
            }
            catch (Exception e) {
                AnalysisLogger.getLogger().debug((Object)("Error in getting process description with ID: " + this.processid));
            }
        }
        this.inputTypes = wpsclient.getCurrentInputStatisticalTypes();
        this.outputTypes = wpsclient.getCurrentOutputStatisticalTypes();
        this.wpsInputs = wpsclient.getCurrentInputs();
        this.wpsOutputs = wpsclient.getCurrentOutputs();
        this.title = wpsclient.getCurrentProcessTitle();
        String wpsServiceIndication = this.wpsurl.substring("http://".length());
        int idxcolumn = wpsServiceIndication.indexOf(":");
        int idxslash = wpsServiceIndication.indexOf("/");
        int idx = -1;
        idx = idxcolumn > 0 && idxslash > 0 ? Math.min(idxslash, idxcolumn) : (idxcolumn > 0 ? idxcolumn : (idxslash > 0 ? idxslash : Math.min(5, wpsServiceIndication.length())));
        if (idx > 0) {
            wpsServiceIndication = wpsServiceIndication.substring(0, idx);
        }
        this.processAbstract = wpsServiceIndication + ": " + wpsclient.getCurrentProcessAbstract();
        AnalysisLogger.getLogger().debug((Object)("Process Abstract: " + this.processAbstract));
        this.processDescription = wpsclient.getProcessDescription();
        if (DynamicWPSTransducerer.isTooMuchTime()) {
            inputsCache = null;
            System.gc();
        }
    }

    public String getDescription() {
        return this.processAbstract;
    }

    public List<StatisticalType> getInputParameters() {
        return this.inputTypes;
    }

    public INFRASTRUCTURE getInfrastructure() {
        return INFRASTRUCTURE.EXTERNAL_WPS;
    }

    public StatisticalType getOutput() {
        PrimitiveType output = new PrimitiveType(HashMap.class.getName(), this.outputTypes, PrimitiveTypes.MAP, "Results", "Results");
        return output;
    }

    public String getResourceLoad() {
        if (this.resourceManager == null) {
            this.resourceManager = new ResourceFactory();
        }
        return this.resourceManager.getResourceLoad(1);
    }

    public String getResources() {
        return ResourceFactory.getResources((float[])new float[]{100.0f});
    }

    public float getStatus() {
        if (this.status == 100.0f) {
            return this.status;
        }
        if (this.currentProcess != null) {
            return Math.min(this.currentProcess.wpsstatus, 90.0f);
        }
        return this.status;
    }

    public void setConfiguration(AlgorithmConfiguration config) {
        this.config = config;
    }

    public void shutdown() {
    }
}

