/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataanalysis.executor.nodes.transducers.bionym.utils;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.List;
import org.gcube.contentmanagement.lexicalmatcher.utils.AnalysisLogger;
import org.gcube.dataanalysis.ecoengine.utils.Transformations;
import org.gcube.dataanalysis.executor.nodes.transducers.bionym.abstracts.MatcherInput;
import org.gcube.dataanalysis.executor.nodes.transducers.bionym.abstracts.MatcherOutput;
import org.gcube.dataanalysis.executor.nodes.transducers.bionym.abstracts.SingleEntry;

public class YasmeenFileTools {
    public static MatcherInput getYasmeenParserOutput(String sandboxFolder, String filename) throws Exception {
        File inf = new File(sandboxFolder, filename);
        BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(inf), "UTF-8"));
        String line = br.readLine();
        line = br.readLine();
        MatcherInput input = new MatcherInput();
        int i = 0;
        while (line != null) {
            List tokens = Transformations.parseCVSString((String)line, (String)";");
            if (tokens.size() > 0) {
                input.addEntry(i, (String)tokens.get(3), (String)tokens.get(7), (String)tokens.get(8), null);
            }
            line = br.readLine();
            ++i;
        }
        br.close();
        return input;
    }

    public static MatcherOutput getYasmeenMatcherOutput(String sandboxFolder, String filename) throws Exception {
        File inf = new File(sandboxFolder, filename);
        BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(inf), "UTF-8"));
        String line = br.readLine();
        line = br.readLine();
        MatcherOutput output = new MatcherOutput();
        int i = 0;
        while (line != null) {
            AnalysisLogger.getLogger().debug((Object)("Yasmeen Output line:" + line));
            List tokens = Transformations.parseCVSString((String)line, (String)";");
            if (tokens.size() > 0) {
                output.addEntry(i, (String)tokens.get(2), (String)tokens.get(7), (String)tokens.get(8), Double.parseDouble((String)tokens.get(9)), (String)tokens.get(10), (String)tokens.get(11), (String)tokens.get(12), (String)tokens.get(13), null);
            }
            line = br.readLine();
            ++i;
        }
        br.close();
        return output;
    }

    public static void writeYasmeenParserInput(String sandboxFolder, String filename, List<String> rawNames) throws Exception {
        File inf = new File(sandboxFolder, filename);
        if (inf.exists()) {
            inf.delete();
        }
        BufferedWriter bw = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(inf), "UTF-8"));
        for (String rawName : rawNames) {
            bw.append(rawName + "\n");
        }
        bw.close();
    }

    @Deprecated
    public static void writeYasmeenMatcherInput(String sandboxFolder, String filename, String parserName, MatcherInput input) throws Exception {
        File inFile = new File(sandboxFolder, filename);
        if (inFile.exists()) {
            inFile.delete();
        }
        BufferedWriter bw = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(inFile), "UTF-8"));
        bw.write("PARSER;INPUT_DATA;PARSED_SCIENTIFIC_NAME;PARSED_AUTHORITY\n");
        int nInputs = input.getEntriesNumber();
        for (int i = 0; i < nInputs; ++i) {
            SingleEntry se = input.getEntry(i);
            bw.write(parserName + ";\"" + se.originalName + "\";\"" + se.parsedScientificName + "\";\"" + se.parsedAuthorship + "\"");
        }
        bw.close();
    }

    public static void callYasmeen(String command) throws Exception {
        System.out.println("Executing: " + command);
        Process process = null;
        try {
            process = Runtime.getRuntime().exec(command);
            BufferedReader br = new BufferedReader(new InputStreamReader(process.getInputStream()));
            String line = br.readLine();
            System.out.println(line);
            while (line != null) {
                line = br.readLine();
                System.out.println(line);
            }
        }
        catch (Exception e) {
            System.out.println("Unable to execute the program");
            throw e;
        }
        finally {
            if (process != null) {
                process.destroy();
            }
        }
    }
}

