/*
 * Decompiled with CFR 0.152.
 */
package density;

import density.Grid;
import density.GridDimension;
import density.LazyGrid;
import density.Sample;
import density.Utils;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import javax.imageio.ImageIO;

public class WorldImageProducer
extends Canvas {
    public boolean gridnull = false;
    public BufferedImage img;
    public int scale;
    public int mode;
    public static final int LOG = 0;
    public static final int PLAIN = 1;
    public static final int CLASS = 2;
    public int[] classColor;
    public String[] className;
    public Grid grid;
    public boolean blackandwhite = false;
    public boolean redandyellow = false;
    public boolean dichromatic = false;
    public Color[] dichromaticColors = new Color[]{Color.red, Color.blue};
    public static boolean toggleSampleColor = true;
    public int background;
    public double breakpoint = -9999.0;
    public int[] pixels;
    public int minx = -1;
    public int maxx = -1;
    public int miny = -1;
    public int maxy = -1;
    public Sample[] samples = null;
    public Sample[] testsamples = null;
    public boolean visible = true;
    public boolean makeLegend = true;
    public boolean makeTimeline = false;
    public String initialTimeLabel;
    public String timeLabel;
    public int maxTimeIntervals;
    public int timeIndex;
    public static boolean setNumCategoriesByMax = false;
    public static boolean makeNorth = false;
    public static int defaultSampleRadius = 7;
    public static int adjustSampleRadius = 0;
    public static int numCategories = 14;
    public static double[] categories = null;
    public static int maxFracDigits = -1;
    public static double divisor = 2.0;
    public double minval = -1.0;
    public double maxval = -1.0;
    public int xOffset = -1;
    public int yOffset = -1;
    public static double xline = -1.0;
    public static double yline = -1.0;
    public int linerow;
    public int linecol;
    public int white = -1;
    public int black = Color.black.getRGB();
    public int sampleColor = this.white;
    public int testSampleColor = -7722014;
    public int sampleRadius = defaultSampleRadius;
    public double min = 0.0;
    public double max = 0.0;
    public int maxborder = 5;
    public int[][] bdist;
    public static boolean addTinyVals = true;

    double aspect(int x1, int x2, int y1, int y2) {
        return (double)(y2 - y1) / (double)(x2 - x1);
    }

    void setZoom(int x1, int x2, int y1, int y2) {
        this.minx = x1 >= x2 ? x2 : x1;
        this.maxx = x1 <= x2 ? x2 : x1;
        this.miny = y1 >= y2 ? y2 : y1;
        int n = this.maxy = y1 <= y2 ? y2 : y1;
        if (this.nozoom()) {
            return;
        }
        double target = this.aspect(0, this.getCols(), 0, this.getRows());
        if (this.aspect(this.minx, this.maxx, this.miny, this.maxy) < target) {
            this.maxy = this.miny + (int)(target * (double)(this.maxx - this.minx));
        } else {
            this.maxx = this.minx + (int)((double)(this.maxy - this.miny) / target);
        }
    }

    void zoomOut() {
        if (this.nozoom()) {
            return;
        }
        if (this.minx == 0 && this.maxx == this.getCols() && this.miny == 0 && this.maxy == this.getRows()) {
            return;
        }
        this.minx = 0;
        this.maxx = this.getCols();
        this.miny = 0;
        this.maxy = this.getRows();
        this.makeImage();
    }

    public void setClassNames(String s) {
        this.setClassNames(s.split(":"));
    }

    public void setClassNames(String[] s) {
        this.className = s;
        if (this.minval == -1.0) {
            this.minval = 0.0;
            this.maxval = this.className.length - 1;
            numCategories = this.className.length;
        } else {
            numCategories = (int)(this.maxval - this.minval + 1.0);
        }
        this.mode = 1;
    }

    int[] stringToColors(String s) {
        String[] colors = s.split(" ");
        int[] result = new int[colors.length];
        for (int i = 0; i < colors.length; ++i) {
            if (colors[i].indexOf("|") != -1) {
                String[] rgb = colors[i].split("\\|");
                int[] rgbi = new int[3];
                for (int j = 0; j < 3; ++j) {
                    rgbi[j] = Integer.parseInt(rgb[j]);
                }
                result[i] = new Color(rgbi[0], rgbi[1], rgbi[2]).getRGB();
                continue;
            }
            try {
                result[i] = Integer.decode(colors[i]);
                continue;
            }
            catch (NumberFormatException rgb) {
                try {
                    result[i] = ((Color)Class.forName("java.awt.Color").getField(colors[i]).get(null)).getRGB();
                    continue;
                }
                catch (Exception ee) {
                    throw new NumberFormatException("Invalid color: " + colors[i]);
                }
            }
        }
        return result;
    }

    public void setColorClasses(String s) {
        this.classColor = this.stringToColors(s);
        this.mode = 2;
    }

    static void setCategories(String s) {
        String[] cats = s.split(" ");
        categories = new double[cats.length];
        for (int i = 0; i < cats.length; ++i) {
            WorldImageProducer.categories[i] = Double.parseDouble(cats[i]);
        }
        numCategories = cats.length;
    }

    void setline() {
        this.linecol = -1;
        this.linerow = -1;
        if (xline != -1.0) {
            this.linerow = this.grid.getDimension().toRow(xline) * this.scale;
        }
        if (yline != -1.0) {
            this.linecol = this.grid.getDimension().toCol(yline) * this.scale;
        }
    }

    public void setMinval(double m) {
        this.minval = m;
    }

    public void setMaxval(double m) {
        this.maxval = m;
    }

    public void setMode(int i) {
        this.mode = i;
    }

    void setBreakpoint(double x) {
        this.breakpoint = x;
    }

    void setColorScheme(int i) {
        this.blackandwhite = i == 0;
    }

    public void setGrid(Grid grid, int minrows, int mincols) {
        double yscale;
        this.grid = grid;
        this.scale = 1;
        double xscale = Math.floor((double)mincols / (double)this.getCols());
        this.scale = (int)(xscale >= (yscale = Math.floor((double)minrows / (double)this.getRows())) ? yscale : xscale);
        if (this.scale < 1) {
            this.scale = 1;
        }
        this.img = new BufferedImage(this.getCols(), this.getRows(), 1);
        this.pixels = ((DataBufferInt)this.img.getRaster().getDataBuffer()).getData();
        this.setZoom(-1, -1, -1, -1);
        this.setline();
        if (this.blackandwhite) {
            this.newborder();
        }
    }

    void setSamples(Sample[] s) {
        this.samples = s;
    }

    public void setTestSamples(Sample[] s) {
        this.testsamples = s;
    }

    double max(double x, double y) {
        return x <= y ? y : x;
    }

    public void setTime(int maxTimeFrames, int timeFrame, String initialTimeLabel, String currentTimeLabel) {
        this.maxTimeIntervals = maxTimeFrames;
        this.timeIndex = timeFrame;
        this.initialTimeLabel = initialTimeLabel;
        this.timeLabel = currentTimeLabel;
    }

    GridDimension viewDimension() {
        GridDimension dim = this.grid.getDimension();
        double cs = dim.getcellsize() / (double)this.scale;
        return new GridDimension(dim.getxllcorner() + this.max(this.minx, 0.0) * cs, dim.getyllcorner() + (double)(this.maxy != -1 ? this.getRows() - this.maxy : 0) * cs, cs * (this.maxx != -1 ? (double)(this.maxx - this.minx) / (double)this.getCols() : 1.0), this.getRows(), this.getCols());
    }

    int getRows() {
        if (this.grid != null) {
            return this.scale * this.grid.getDimension().nrows;
        }
        return this.scale * 480;
    }

    int getCols() {
        if (this.grid != null) {
            return this.scale * this.grid.getDimension().ncols;
        }
        return this.scale * 640;
    }

    boolean inBounds(int r, int c) {
        return r >= 0 && r < this.getRows() && c >= 0 && c < this.getCols();
    }

    public WorldImageProducer(Grid grid, int minrows, int mincols) {
        this.setGrid(grid, minrows, mincols);
    }

    public WorldImageProducer(Grid grid) {
        if (grid != null) {
            this.setGrid(grid, 1200, 1600);
        } else {
            this.gridnull = true;
        }
    }

    boolean nozoom() {
        return this.minx == -1 || this.maxx == -1 || this.miny == -1 || this.maxy == -1;
    }

    int windowx2imgx(int x) {
        return (int)((double)this.getCols() / (double)this.getSize().width * (double)x);
    }

    int windowy2imgy(int y) {
        return (int)((double)this.getRows() / (double)this.getSize().height * (double)y);
    }

    int gridrow(int r) {
        if (this.nozoom()) {
            return r / this.scale;
        }
        int rr = (int)((double)this.miny + (double)r / (double)this.getRows() * (double)(this.maxy - this.miny));
        return rr / this.scale;
    }

    int gridcol(int c) {
        if (this.nozoom()) {
            return c / this.scale;
        }
        int cc = (int)((double)this.minx + (double)c / (double)this.getCols() * (double)(this.maxx - this.minx));
        return cc / this.scale;
    }

    boolean hasData(int r, int c) {
        if (!this.gridnull) {
            return this.grid.hasData(this.gridrow(r), this.gridcol(c));
        }
        return false;
    }

    float eval(int r, int c) {
        return this.grid.eval(this.gridrow(r), this.gridcol(c));
    }

    public void makeImage() {
        int j;
        int i;
        boolean start = true;
        int n = this.redandyellow ? 0x8080FF : (this.background = this.blackandwhite ? this.white : -16777216);
        if (this.minval != -1.0 || this.maxval != -1.0) {
            this.min = this.minval;
            this.max = this.maxval;
        } else {
            for (i = 0; i < this.getRows(); ++i) {
                for (j = 0; j < this.getCols(); ++j) {
                    if (!this.hasData(i, j)) continue;
                    if (start) {
                        this.min = this.max = (double)this.eval(i, j);
                        start = false;
                        continue;
                    }
                    float val = this.eval(i, j);
                    if ((double)val < this.min && (this.mode != 0 || val > 0.0f) || this.min <= 0.0 && this.mode == 0) {
                        this.min = val;
                    }
                    if (!((double)val > this.max)) continue;
                    this.max = val;
                }
            }
            if (this.grid instanceof LazyGrid) {
                try {
                    ((LazyGrid)this.grid).initialize();
                }
                catch (IOException e) {
                    Utils.fatalException((String)("Error initializing file " + this.grid.name), null);
                }
            }
        }
        if (this.max == 100.0 && this.min >= 0.0 && this.min < 1.0E-5) {
            this.min = 1.0E-5;
        }
        if (this.max == 100.0 && this.min >= 0.0 && this.min < 0.001 && this.blackandwhite) {
            this.min = 0.01;
        }
        if (this.min > 0.0 && this.max / this.min > 1.0E15) {
            this.min = this.max / 1.0E15;
        }
        if (this.min >= 0.0 && this.min <= 0.1 && this.max >= 0.7 && this.max <= 1.0 && this.mode != 0 && this.maxval == -1.0) {
            this.min = 0.0;
            this.max = 1.0;
            numCategories = 11;
        }
        for (i = 0; i < this.getRows(); ++i) {
            Utils.reportProgress((double)((double)(i * 100) / (double)this.getRows()));
            for (j = 0; j < this.getCols(); ++j) {
                int n2 = i != this.linerow ? (j != this.linecol ? (this.hasData(i, j) ? this.showColor(this.eval(i, j), this.min, this.max) : (!this.blackandwhite || !this.isborder(i, j) ? this.background : this.black)) : this.white) : (this.pixels[i * this.getCols() + j] = this.white);
                if (this.pixels[i * this.getCols() + j] != this.black || this.blackandwhite) continue;
                this.pixels[i * this.getCols() + j] = Color.LIGHT_GRAY.getRGB();
            }
        }
        int sr = this.sampleRadius;
        int rr = this.getRows() * this.scale;
        int cc = this.getCols() * this.scale;
        if (this.scale > 1) {
            sr = (int)Math.ceil((double)sr / (double)this.scale);
        }
        if (rr < 900 && cc < 900 && sr * this.scale >= 5 && sr > 2) {
            sr -= 2;
        }
        if (rr < 600 && cc < 600 && sr * this.scale >= 5 && sr > 2) {
            sr -= 2;
        }
        if (rr < 300 && cc < 300 && sr * this.scale >= 5 && sr > 2) {
            sr -= 2;
        }
        if (rr > 2000 || cc > 2000) {
            sr += 1 / this.scale;
        }
        if (rr > 4000 || cc > 4000) {
            sr += 1 / this.scale;
        }
        sr += adjustSampleRadius;
        if (this.samples != null) {
            this.showSamples(this.samples, this.sampleColor, sr);
        }
        if (this.testsamples != null) {
            this.showSamples(this.testsamples, this.testSampleColor, sr);
        }
        if (this.makeLegend) {
            this.makeLegend();
        }
        if (makeNorth) {
            this.makeNorth();
        }
        if (this.visible) {
            this.repaint();
        }
        if (this.makeTimeline) {
            this.makeTimeline(this.maxTimeIntervals, this.timeIndex, this.initialTimeLabel, this.timeLabel);
        }
    }

    void newborder() {
        int nr = this.getRows();
        int nc = this.getCols();
        this.bdist = new int[nr][nc];
        for (int i = 0; i < this.getRows(); ++i) {
            for (int j = 0; j < this.getCols(); ++j) {
                this.bdist[i][j] = this.hasData(i, j) ? 0 : 100000;
            }
        }
        for (int iter = 0; iter < this.maxborder; ++iter) {
            for (int i = 0; i < nr; ++i) {
                for (int j = 0; j < nc; ++j) {
                    for (int id = -1; id <= 1; id += 2) {
                        for (int jd = -1; jd <= 1; jd += 2) {
                            int ii = i + id;
                            int jj = j + jd;
                            if (ii < 0 || jj < 0 || ii >= nr || jj >= nc || this.bdist[ii][jj] >= this.bdist[i][j] - 1) continue;
                            this.bdist[i][j] = this.bdist[ii][jj] + 1;
                        }
                    }
                }
            }
        }
    }

    boolean isborder(int i, int j) {
        return this.bdist[i][j] < this.maxborder;
    }

    void showSamples(Sample[] samples, int color, int sr) {
        GridDimension dim = this.viewDimension();
        int[] under = null;
        if (this.blackandwhite && toggleSampleColor) {
            under = (int[])this.pixels.clone();
        }
        for (int i = 0; i < samples.length; ++i) {
            if (samples[i] == null) continue;
            int r = samples[i].getRow(dim);
            int c = samples[i].getCol(dim);
            int color2 = color;
            if (this.blackandwhite && toggleSampleColor) {
                int cnt = 0;
                int tot = 0;
                for (int j = (-sr + 1) * this.scale; j < sr * this.scale; ++j) {
                    for (int k = (-sr + 1) * this.scale; k < sr * this.scale; ++k) {
                        if (!this.inBounds(r + j, c + k)) continue;
                        ++cnt;
                        tot += new Color(under[(r + j) * this.getCols() + (c + k)]).getBlue();
                    }
                }
                if (cnt > 0 && tot / cnt > 128) {
                    color2 = this.black;
                }
            } else if (this.blackandwhite) {
                color2 = this.black;
            }
            for (int j = (-sr + 1) * this.scale; j < sr * this.scale; ++j) {
                for (int k = (-sr + 1) * this.scale; k < sr * this.scale; ++k) {
                    if (!this.inBounds(r + j, c + k)) continue;
                    this.pixels[(r + j) * this.getCols() + (c + k)] = color2;
                }
            }
        }
    }

    void makeTimeline(int maxtimeframes, int timeidx, String initialTimeLabel, String timeLabel) {
        int num = timeidx + 1;
        int fontSize = this.getRows() <= 2000 && this.getCols() <= 2000 ? (this.getRows() <= 1000 && this.getCols() <= 1000 ? 11 : 18) : 24;
        Graphics2D image = (Graphics2D)this.img.getGraphics();
        Font font = new Font("Dialog", 1, fontSize);
        image.setFont(font);
        FontMetrics fm = image.getFontMetrics(font);
        String[] labels = new String[timeidx + 1];
        labels[0] = initialTimeLabel;
        labels[timeidx] = timeLabel;
        int w = fm.stringWidth(labels[timeidx]);
        int width = fm.getWidths()[0] + w;
        int heigh = fm.getWidths()[0];
        int y = this.getRows() - 50;
        int x0 = this.getCols() / 2 - maxtimeframes / 2;
        for (int i = 0; i < num; ++i) {
            String label;
            image.setColor(Color.white);
            int x = i + 1 + x0;
            if (!initialTimeLabel.equals(timeLabel)) {
                image.fill(new Rectangle(x, y, width, heigh));
                image.setColor(Color.white);
            }
            String string = label = labels[i] == null ? "" : labels[i];
            if (i == 0) {
                image.drawString(label, x - width / 2, y + heigh + 15);
                continue;
            }
            image.drawString(label, x + width, y + heigh + 15);
        }
    }

    void makeLegend() {
        int i;
        int fontSize;
        double[] vals;
        int num = setNumCategoriesByMax ? (int)this.max + 1 : numCategories;
        double[] dArray = vals = categories != null ? categories : new double[num];
        int n = this.getRows() <= 2000 && this.getCols() <= 2000 ? (this.getRows() <= 1000 && this.getCols() <= 1000 ? 11 : 18) : (fontSize = 24);
        if (categories == null) {
            if (this.mode == 0) {
                double x = this.max;
                if (this.max > 50.0 && this.max <= 100.0) {
                    for (int i2 = 0; i2 < num; ++i2) {
                        vals[i2] = x;
                        x /= divisor;
                    }
                    if (addTinyVals) {
                        vals[num - 3] = 0.01;
                        vals[num - 2] = 0.001;
                        vals[num - 1] = this.min <= 1.0E-4 ? this.min : 1.0E-4;
                    } else {
                        vals[num - 1] = 0.0;
                    }
                } else {
                    double div = Math.exp(Math.log(this.min >= this.max / 1.0E15 ? this.max / this.min : 1.0E15) / (double)(num - 1));
                    for (int i3 = 0; i3 < num; ++i3) {
                        vals[i3] = x;
                        x /= div;
                    }
                }
            } else {
                for (int i4 = 0; i4 < num; ++i4) {
                    vals[i4] = this.max - (double)i4 * (this.max - this.min) / (double)(num - 1);
                }
                if (vals[num - 1] < 0.01 && vals[num - 2] > 1.0) {
                    vals[num - 1] = 0.0;
                }
            }
            if (this.min == this.max) {
                num = 1;
                vals = new double[]{this.min};
            }
        }
        Graphics2D g = (Graphics2D)this.img.getGraphics();
        Font font = new Font("Dialog", 1, fontSize);
        g.setFont(font);
        FontMetrics fm = g.getFontMetrics(font);
        int height = fm.getHeight() + 2;
        NumberFormat nf = this.max > 1.0 || this.mode == 0 ? NumberFormat.getNumberInstance() : new DecimalFormat();
        nf.setGroupingUsed(false);
        String[] labels = new String[num];
        int legendWidth = 0;
        for (i = 0; i < num; ++i) {
            if (this.max < 0.5 || this.max < 2.0 && this.mode == 0) {
                ((DecimalFormat)nf).applyPattern("0.#E0");
            } else {
                nf.setMaximumFractionDigits(maxFracDigits == -1 ? (vals[i] < 1.0 ? (vals[i] < 0.01 ? (vals[i] < 0.001 ? (vals[i] <= 1.0E-4 ? (vals[i] >= 0.0 ? 5 : 1) : 4) : 3) : 2) : 1) : maxFracDigits);
            }
            labels[i] = this.className != null && (double)this.className.length > vals[i] ? this.className[(int)vals[i]] : nf.format(vals[i]);
            int w = fm.stringWidth(labels[i]);
            if (w <= legendWidth) continue;
            legendWidth = w;
        }
        this.computeOffsets(legendWidth + 6 + 2 * height, (num + 2) * height);
        for (i = 0; i < num; ++i) {
            int y = this.getRows() - (num - i + 1) * height - this.yOffset;
            g.setColor(new Color(this.showColor(vals[i], this.min, this.max)));
            g.fill(new Rectangle(this.xOffset + 4, y, height, height));
            g.setColor(this.blackandwhite ? Color.black : Color.white);
            g.drawString(labels[i], this.xOffset + 6 + height, y + height - 2);
        }
    }

    void computeOffsets(int w, int h) {
        this.xOffset = 0;
        this.yOffset = 0;
        int overlap = this.computeOverlap(0, 0, w, h);
        if (overlap == 0) {
            return;
        }
        int overlap2 = this.computeOverlap(this.getCols() - w, 0, w, h);
        if (overlap2 < overlap) {
            overlap = overlap2;
            this.xOffset = this.getCols() - w;
            this.yOffset = 0;
        }
        if (overlap == 0) {
            return;
        }
        overlap2 = this.computeOverlap(this.getCols() - w, this.getRows() - h, w, h);
        if (overlap2 < overlap) {
            overlap = overlap2;
            this.xOffset = this.getCols() - w;
            this.yOffset = this.getRows() - h;
        }
        if (overlap == 0) {
            return;
        }
        overlap2 = this.computeOverlap(0, this.getRows() - h, w, h);
        if (overlap2 < overlap) {
            overlap = overlap2;
            this.xOffset = 0;
            this.yOffset = this.getRows() - h;
        }
    }

    int computeOverlap(int llx, int lly, int w, int h) {
        int cnt = 0;
        for (int y = lly; y < lly + h; ++y) {
            for (int x = llx; x < llx + w; ++x) {
                if (!this.nonBackground(this.getRows() - y, x)) continue;
                ++cnt;
            }
        }
        return cnt;
    }

    boolean nonBackground(int r, int c) {
        int i = r * this.getCols() + c;
        return i >= 0 && i < this.pixels.length && this.pixels[i] != this.background;
    }

    void makeNorth() {
        Graphics2D g = (Graphics2D)this.img.getGraphics();
        g.setColor(this.blackandwhite ? Color.black : Color.white);
        Font font = new Font("Dialog", 1, 48);
        g.setFont(font);
        FontMetrics fm = g.getFontMetrics(font);
        int height = fm.getHeight() + 2;
        int nx = (int)((double)this.getCols() * 0.95);
        g.drawString("N", nx, (int)((double)this.getRows() * 0.1) + height);
        int x = nx + fm.stringWidth("N") / 2;
        int yb = (int)((double)this.getRows() * 0.1 - (double)height * 1.25);
        int yheight = (int)((double)this.getRows() * 0.05);
        int w = 6;
        g.fillRect(x - w / 2, yb, w, yheight);
        g.fillPolygon(new int[]{x, x + 3 * w, x - 3 * w}, new int[]{yb - w / 2, yb + 3 * w, yb + 3 * w}, 3);
    }

    public void writeImage(String outFile) {
        this.writeImage(outFile, 1);
    }

    public void writeImage(String outFile, int magstep) {
        BufferedImage toWrite;
        int ncols = this.getCols();
        int nrows = this.getRows();
        BufferedImage bufferedImage = toWrite = magstep != 1 ? new BufferedImage(ncols * magstep, nrows * magstep, 1) : this.img;
        if (magstep > 1) {
            int[] p = ((DataBufferInt)toWrite.getRaster().getDataBuffer()).getData();
            for (int r = 0; r < nrows * magstep; ++r) {
                for (int c = 0; c < ncols * magstep; ++c) {
                    p[r * ncols * magstep + c] = this.pixels[r / magstep * ncols + c / magstep];
                }
            }
        }
        try {
            ImageIO.write((RenderedImage)toWrite, "png", new File(outFile));
        }
        catch (IOException e) {
            System.out.println("Error: " + e.toString());
        }
    }

    int showColor(double val, double min, double max) {
        int blue;
        int green;
        int red;
        if (this.mode == 2) {
            return this.classColor[(int)val];
        }
        if (this.mode == 0) {
            val = val > min ? Math.log(val) : Math.log(min);
            min = min > 0.0 ? Math.log(min) : 0.0;
            double d = max = max > 0.0 ? Math.log(max) : 0.0;
        }
        if (val < min) {
            val = min;
        }
        if (val > max) {
            val = max;
        }
        if (this.dichromatic) {
            if (this.breakpoint == -9999.0) {
                this.breakpoint = (max - min) / 2.0;
            }
            double frac = val >= this.breakpoint ? (val - this.breakpoint) / (max - this.breakpoint) : (this.breakpoint - val) / (this.breakpoint - min);
            int end = val >= this.breakpoint ? 1 : 0;
            return this.fadedColor(this.dichromaticColors[end], frac);
        }
        if (this.redandyellow) {
            if (this.breakpoint == -9999.0) {
                this.breakpoint = 50.0;
            }
            int index = (int)((max - val) * 100.0 / (max - min));
            red = 255;
            green = (int)((double)index >= this.breakpoint ? 255.0 : (double)(index * 255) / this.breakpoint);
            blue = (int)((double)index >= this.breakpoint ? ((double)index - this.breakpoint) * 255.0 / (511.0 - this.breakpoint) : 0.0);
        } else if (this.blackandwhite) {
            double index = (max - val) / (max - min);
            green = blue = (int)(220.0 * index) + 30;
            red = blue;
        } else {
            int i = (int)((max - val) * 1020.0 / (max - min));
            int n = i >= 256 ? (i <= 510 ? 510 - i : 0) : (red = 255);
            int n2 = i >= 256 ? (i >= 765 ? 1020 - i : 255) : (green = i);
            blue = i >= 510 ? (i >= 765 ? 255 : i - 510) : 0;
        }
        return 0xFF000000 | red << 16 | green << 8 | blue;
    }

    int fadedColor(Color c, double frac) {
        int[] rgb = new int[]{c.getRed(), c.getGreen(), c.getBlue()};
        for (int i = 0; i < 3; ++i) {
            rgb[i] = rgb[i] + (int)((1.0 - frac) * (double)(255 - rgb[i]));
        }
        return new Color(rgb[0], rgb[1], rgb[2]).getRGB();
    }

    @Override
    public void paint(Graphics g) {
        int w = this.getSize().width;
        int h = this.getSize().height;
        if (this.img != null) {
            g.drawImage(this.img, 0, 0, w, h, this);
        }
    }

    @Override
    public void update(Graphics g) {
        this.paint(g);
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(this.getCols(), this.getRows());
    }
}

