/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataanalysis.geo.vti;

import java.util.ArrayList;
import java.util.List;
import org.gcube.contentmanagement.lexicalmatcher.utils.AnalysisLogger;
import org.gcube.dataanalysis.ecoengine.datatypes.ColumnType;
import org.gcube.dataanalysis.ecoengine.datatypes.DatabaseType;
import org.gcube.dataanalysis.ecoengine.datatypes.InputTable;
import org.gcube.dataanalysis.ecoengine.datatypes.enumtypes.TableTemplates;
import org.gcube.dataanalysis.ecoengine.utils.IOHelper;
import org.gcube.dataanalysis.geo.utils.CSquareCodesConverter;
import org.gcube.dataanalysis.geo.vti.GridCWP2Coordinates;

public class CSquare2Coordinates
extends GridCWP2Coordinates {
    @Override
    protected void setInputParameters() {
        ArrayList<TableTemplates> templates = new ArrayList<TableTemplates>();
        templates.add(TableTemplates.GENERIC);
        InputTable tinput = new InputTable(templates, inputTableParameter, "The table to which the algorithm will add information");
        this.inputs.add(tinput);
        ColumnType Dimension = new ColumnType(inputTableParameter, CodeColumn, "The column containing c-square codes", "GRID", false);
        this.inputs.add(Dimension);
        IOHelper.addStringInput((List)this.inputs, (String)outputTableParameter, (String)"The name of the output table", (String)"csq_");
        DatabaseType.addDefaultDBPars((List)this.inputs);
    }

    @Override
    public String getDescription() {
        return "An algorithm that adds longitude, latitude and resolution columns analysing a column containing c-square codes.";
    }

    @Override
    public void rowToCoords(Object[] rowArray) {
        Object grid = null;
        try {
            grid = rowArray[rowArray.length - 1];
            String gridValue = "" + grid;
            CSquareCodesConverter converter = new CSquareCodesConverter();
            converter.parse(gridValue);
            this.currentLat = converter.getCurrentLat();
            this.currentLong = converter.getCurrentLong();
            this.currentRes = converter.getCurrentResolution();
        }
        catch (Exception e) {
            AnalysisLogger.getLogger().debug((Object)("Error converting grid: " + grid + " - " + e.getLocalizedMessage()));
            this.currentLat = 0.0;
            this.currentLong = 0.0;
            this.currentRes = 0.0;
        }
    }
}

