/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataanalysis.geo.algorithms;

import com.thoughtworks.xstream.XStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.contentmanagement.lexicalmatcher.utils.AnalysisLogger;
import org.gcube.dataanalysis.ecoengine.configuration.ALG_PROPS;
import org.gcube.dataanalysis.ecoengine.configuration.AlgorithmConfiguration;
import org.gcube.dataanalysis.ecoengine.datatypes.DatabaseType;
import org.gcube.dataanalysis.ecoengine.datatypes.PrimitiveType;
import org.gcube.dataanalysis.ecoengine.datatypes.StatisticalType;
import org.gcube.dataanalysis.ecoengine.datatypes.enumtypes.PrimitiveTypes;
import org.gcube.dataanalysis.ecoengine.interfaces.ActorNode;
import org.gcube.dataanalysis.ecoengine.utils.IOHelper;
import org.gcube.dataanalysis.ecoengine.utils.Transformations;
import org.gcube.dataanalysis.ecoengine.utils.Tuple;
import org.gcube.dataanalysis.executor.generators.D4ScienceDistributedProcessing;
import org.gcube.dataanalysis.geo.connectors.netcdf.NetCDFDataExplorer;
import org.gcube.dataanalysis.geo.infrastructure.GeoNetworkInspector;
import org.gcube.dataanalysis.geo.matrixmodel.MatrixExtractor;
import org.gcube.dataanalysis.geo.matrixmodel.XYExtractor;
import org.opengis.metadata.Metadata;
import ucar.nc2.dt.GridDatatype;
import ucar.nc2.dt.grid.GridDataset;

public class MapsComparatorNode
extends ActorNode {
    static String layer1 = "Layer_1";
    static String layer2 = "Layer_2";
    static String resolutionS = "resolution";
    static String x1S = "x1";
    static String y1S = "y1";
    static String x2S = "x2";
    static String y2S = "y2";
    static String zString = "Z";
    static String t1 = "TimeIndex_1";
    static String t2 = "TimeIndex_2";
    static String valuesThr = "ValuesComparisonThreshold";
    float status = 0.0f;
    AlgorithmConfiguration config;
    Tuple<Double> extent;
    public int prevbroadcastTimePeriod;
    public int prevmaxNumberOfStages;
    public int prevmaxMessages;
    int numberofslices = 0;
    public List<StatisticalType> inputs = new ArrayList<StatisticalType>();
    public LinkedHashMap<String, String> outputParameters = new LinkedHashMap();
    static long elapsedt = 0L;

    public String getDescription() {
        return "An algorithm for comparing two OGC/NetCDF maps in seamless way to the user. Supported maps can only be in WFS, Opendap or ASC formats. The algorithm assesses the similarities between two geospatial maps by comparing them in a point-to-point fashion. It accepts as input the two geospatial maps (via their UUIDs in the infrastructure spatial data repository - recoverable through the Geoexplorer portlet) and some parameters affecting the comparison such as the z-index, the time index, the comparison threshold.";
    }

    public List<StatisticalType> getInputParameters() {
        IOHelper.addStringInput(this.inputs, (String)layer1, (String)"First Layer Title or UUID: The title or the UUID (preferred) of a layer indexed in the e-Infrastructure on GeoNetwork - You can retrieve it from GeoExplorer", (String)"");
        IOHelper.addStringInput(this.inputs, (String)layer2, (String)"Second Layer Title or UUID: The title or the UUID (preferred)  of a second layer indexed in the e-Infrastructure on GeoNetwork - You can retrieve it from GeoExplorer", (String)"");
        IOHelper.addIntegerInput(this.inputs, (String)zString, (String)"value of Z. Default is 0, that means comparison will be at surface level", (String)"0");
        IOHelper.addDoubleInput(this.inputs, (String)valuesThr, (String)"A comparison threshold for the values in the map. Null equals to 0.1", (String)"0.1");
        IOHelper.addIntegerInput(this.inputs, (String)t1, (String)"First Layer Time Index. The default is the first", (String)"0");
        IOHelper.addIntegerInput(this.inputs, (String)t2, (String)"Second Layer Time Index. The default is the first", (String)"0");
        IOHelper.addDoubleInput(this.inputs, (String)"KThreshold", (String)"Threshold for K-Statistic: over this threshold values will be considered 1 for agreement calculation. Default is 0.5", (String)"0.5");
        DatabaseType.addDefaultDBPars(this.inputs);
        return this.inputs;
    }

    public StatisticalType getOutput() {
        AnalysisLogger.getLogger().debug((Object)"MapsComparator: Producing Gaussian Distribution for the errors");
        HashMap producedImages = new HashMap();
        double mean = Double.parseDouble(this.outputParameters.get("MEAN"));
        double variance = Double.parseDouble(this.outputParameters.get("VARIANCE"));
        PrimitiveType images = new PrimitiveType("Images", producedImages, PrimitiveTypes.IMAGES, "Distribution of the Error", "The distribution of the error along with variance");
        LinkedHashMap<String, PrimitiveType> map = new LinkedHashMap<String, PrimitiveType>();
        for (String key : this.outputParameters.keySet()) {
            String value = this.outputParameters.get(key);
            PrimitiveType val = new PrimitiveType(String.class.getName(), (Object)("" + value), PrimitiveTypes.STRING, key, key);
            map.put(key, val);
        }
        map.put("Images", images);
        PrimitiveType output = new PrimitiveType(HashMap.class.getName(), map, PrimitiveTypes.MAP, "ResultsMap", "Results Map");
        return output;
    }

    public ALG_PROPS[] getProperties() {
        ALG_PROPS[] p = new ALG_PROPS[]{ALG_PROPS.PHENOMENON_VS_PARALLEL_PHENOMENON};
        return p;
    }

    public String getName() {
        return "MAPS_COMPARISON";
    }

    public void initSingleNode(AlgorithmConfiguration config) {
    }

    public float getInternalStatus() {
        return this.status;
    }

    private double calcResolution(String layerT1, String layerT2) throws Exception {
        String scope = this.config.getGcubeScope();
        if (scope == null) {
            scope = ScopeProvider.instance.get();
            this.config.setGcubeScope(scope);
        }
        MatrixExtractor intersector = new MatrixExtractor(this.config);
        AnalysisLogger.getLogger().debug((Object)"MapsComparator: GeoIntersector initialized");
        double x1 = -180.0;
        double x2 = 180.0;
        double y1 = -90.0;
        double y2 = 90.0;
        this.status = 10.0f;
        GeoNetworkInspector fm = intersector.getFeaturer();
        AnalysisLogger.getLogger().debug((Object)("MapsComparator: Taking info for the layer: " + layerT1));
        Metadata meta1 = fm.getGNInfobyUUIDorName(layerT1);
        if (meta1 == null) {
            throw new Exception("No Correspondence with Layer 1");
        }
        double resolution1 = 0.0;
        try {
            resolution1 = GeoNetworkInspector.getResolution(meta1);
        }
        catch (Exception e) {
            AnalysisLogger.getLogger().debug((Object)"MapsComparator: Undefined resolution");
        }
        AnalysisLogger.getLogger().debug((Object)("MapsComparator: Resolution: " + resolution1));
        if (fm.isNetCDFFile(meta1)) {
            AnalysisLogger.getLogger().debug((Object)"MapsComparator: recalculating the spatial extent of the comparison");
            String fileurl = fm.getOpenDapLink(meta1);
            GridDataset gds = GridDataset.open((String)fileurl);
            List gridTypes = gds.getGrids();
            GridDatatype gdt = (GridDatatype)gridTypes.get(0);
            x1 = NetCDFDataExplorer.getMinX(gdt.getCoordinateSystem());
            x2 = NetCDFDataExplorer.getMaxX(gdt.getCoordinateSystem());
            y1 = NetCDFDataExplorer.getMinY(gdt.getCoordinateSystem());
            y2 = NetCDFDataExplorer.getMaxY(gdt.getCoordinateSystem());
        }
        AnalysisLogger.getLogger().debug((Object)("MapsComparator: Spatial extent of the comparison: x1: " + x1 + " x2: " + x2 + " y1: " + y1 + " y2: " + y2));
        AnalysisLogger.getLogger().debug((Object)("MapsComparator: Taking info for the layer: " + layerT2));
        AnalysisLogger.getLogger().debug((Object)("MapsComparator: Trying with UUID..." + layerT2));
        Metadata meta2 = fm.getGNInfobyUUIDorName(layerT2);
        if (meta2 == null) {
            throw new Exception("No Correspondence with Layer 2");
        }
        double resolution2 = 0.0;
        try {
            resolution2 = GeoNetworkInspector.getResolution(meta2);
        }
        catch (Exception e) {
            AnalysisLogger.getLogger().debug((Object)"MapsComparator: Undefined resolution");
        }
        AnalysisLogger.getLogger().debug((Object)("MapsComparator: Resolution: " + resolution2));
        double resolution = Math.max(resolution1, resolution2);
        AnalysisLogger.getLogger().debug((Object)("MapsComparator: Theoretical Resolution: " + resolution));
        if (resolution == 0.0) {
            resolution = 0.5;
        }
        if (resolution < 0.5 && resolution > 0.01) {
            resolution = 0.5;
        } else if (resolution < 0.01) {
            resolution = 0.01;
        }
        AnalysisLogger.getLogger().debug((Object)("MapsComparator: Evaluation Indeed at Resolution: " + resolution));
        this.extent = new Tuple((Object[])new Double[]{x1, y1, x2, y2});
        return resolution;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int executeNode(int leftStartIndex, int numberOfLeftElementsToProcess, int rightStartIndex, int numberOfRightElementsToProcess, boolean duplicate, String sandboxFolder, String nodeConfigurationFileObject, String logfileNameToProduce) {
        try {
            double slicey1;
            this.status = 0.0f;
            System.out.println("Restoring configuration");
            AlgorithmConfiguration config = Transformations.restoreConfig((String)new File(sandboxFolder, nodeConfigurationFileObject).getAbsolutePath());
            config.setConfigPath(sandboxFolder);
            AnalysisLogger.setLogger((String)(config.getConfigPath() + AlgorithmConfiguration.defaultLoggerFile));
            long t0 = System.currentTimeMillis();
            String layerT1 = IOHelper.getInputParameter((AlgorithmConfiguration)config, (String)layer1);
            String layerT2 = IOHelper.getInputParameter((AlgorithmConfiguration)config, (String)layer2);
            String z$ = IOHelper.getInputParameter((AlgorithmConfiguration)config, (String)zString);
            String valuesthr$ = IOHelper.getInputParameter((AlgorithmConfiguration)config, (String)valuesThr);
            String time1$ = IOHelper.getInputParameter((AlgorithmConfiguration)config, (String)t1);
            String time2$ = IOHelper.getInputParameter((AlgorithmConfiguration)config, (String)t2);
            int time1 = time1$ != null && time1$.trim().length() > 0 ? Integer.parseInt(time1$) : 0;
            int time2 = time2$ != null && time2$.trim().length() > 0 ? Integer.parseInt(time2$) : 0;
            double resolution = Double.parseDouble(IOHelper.getInputParameter((AlgorithmConfiguration)config, (String)resolutionS));
            double x1 = Double.parseDouble(IOHelper.getInputParameter((AlgorithmConfiguration)config, (String)x1S));
            double y1 = Double.parseDouble(IOHelper.getInputParameter((AlgorithmConfiguration)config, (String)y1S));
            double x2 = Double.parseDouble(IOHelper.getInputParameter((AlgorithmConfiguration)config, (String)x2S));
            double y2 = Double.parseDouble(IOHelper.getInputParameter((AlgorithmConfiguration)config, (String)y2S));
            if (time1 < 0) {
                time1 = 0;
            }
            if (time2 < 0) {
                time2 = 0;
            }
            double valuesthreshold = 0.1;
            if (valuesthr$ != null && valuesthr$.trim().length() > 0) {
                try {
                    valuesthreshold = Double.parseDouble(valuesthr$);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            double z = 0.0;
            if (z$ != null && z$.trim().length() > 0) {
                try {
                    z = Double.parseDouble(z$);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            String scope = config.getGcubeScope();
            double slicey2 = slicey1 = y1 + (double)rightStartIndex * resolution;
            if (IOHelper.getInputParameter((AlgorithmConfiguration)config, (String)"full") != null) {
                slicey1 = y1;
                slicey2 = y2;
            }
            int positivescount = 0;
            if (slicey1 <= y2) {
                XYExtractor intersector = new XYExtractor(config);
                AnalysisLogger.getLogger().debug((Object)"MapsComparator: GeoIntersector initialized");
                AnalysisLogger.getLogger().debug((Object)("MapsComparator: ****Rasterizing map 1 in the range: (" + x1 + " , " + slicey1 + "; " + x2 + " , " + slicey2 + ") with res " + resolution));
                double[][] slice1 = intersector.extractXYGrid(layerT1, time1, x1, x2, slicey1, slicey2, z, resolution, resolution);
                AnalysisLogger.getLogger().debug((Object)("MapsComparator: ****Rasterizing map 2 in the range: (" + x1 + " , " + slicey1 + "; " + x2 + " , " + slicey2 + ") with res " + resolution));
                double[][] slice2 = intersector.extractXYGrid(layerT2, time1, x1, x2, slicey1, slicey2, z, resolution, resolution);
                int xsize = slice1[0].length;
                int ysize = slice1.length;
                AnalysisLogger.getLogger().debug((Object)"Comparing maps...");
                for (int j = 0; j < ysize; ++j) {
                    for (int i = 0; i < xsize; ++i) {
                        double discrepancy = Math.abs(slice1[j][i] - slice2[j][i]);
                        if (!(discrepancy < valuesthreshold)) continue;
                        ++positivescount;
                    }
                }
            } else {
                AnalysisLogger.getLogger().debug((Object)("MapsComparator: warning - Y out of range : " + slicey1 + " max:" + y2));
            }
            elapsedt += System.currentTimeMillis() - t0;
            AnalysisLogger.getLogger().debug((Object)("MapsComparator: Finished: " + positivescount + " in " + (System.currentTimeMillis() - t0)));
        }
        catch (Exception e) {
            e.printStackTrace();
            AnalysisLogger.getLogger().debug((Object)("MapsComparator: ERROR!: " + e.getLocalizedMessage()));
        }
        finally {
            this.status = 1.0f;
        }
        return 0;
    }

    public void setup(AlgorithmConfiguration config) throws Exception {
        this.config = config;
        String layerT1 = IOHelper.getInputParameter((AlgorithmConfiguration)config, (String)layer1);
        String layerT2 = IOHelper.getInputParameter((AlgorithmConfiguration)config, (String)layer2);
        double resolution = this.calcResolution(layerT1, layerT2);
        config.setParam(resolutionS, "" + resolution);
        config.setParam(x1S, "" + this.extent.getElements().get(0));
        config.setParam(y1S, "" + this.extent.getElements().get(1));
        config.setParam(x2S, "" + this.extent.getElements().get(2));
        config.setParam(y2S, "" + this.extent.getElements().get(3));
        double ymax = (Double)this.extent.getElements().get(3);
        double ymin = (Double)this.extent.getElements().get(1);
        int numberofslices = (int)Math.round((ymax - ymin) / resolution + 1.0);
        this.prevmaxMessages = D4ScienceDistributedProcessing.maxMessagesAllowedPerJob;
        D4ScienceDistributedProcessing.maxMessagesAllowedPerJob = 1;
        AnalysisLogger.getLogger().info((Object)("Destination Table Created! Addressing " + numberofslices + " slices"));
    }

    public int getNumberOfRightElements() {
        return this.numberofslices;
    }

    public int getNumberOfLeftElements() {
        return this.numberofslices;
    }

    public void stop() {
        AnalysisLogger.getLogger().debug((Object)"Shutdown");
    }

    public void postProcess(boolean manageDuplicates, boolean manageFault) {
    }

    public static void main(String[] args) throws Exception {
        AlgorithmConfiguration config = new AlgorithmConfiguration();
        config.setConfigPath("./cfg/");
        String sandbox = "./PARALLEL_PROCESSING";
        String configfile = "testconfig.cfg";
        config.setPersistencePath(sandbox);
        config.setParam(zString, "0");
        config.setParam(valuesThr, "0.1");
        config.setParam(t1, "0");
        config.setParam(t2, "0");
        config.setParam("KThreshold", "0.5");
        config.setGcubeScope("/gcube");
        config.setParam(layer1, "1265fce4-f331-4459-bed5-3747039c7bd9");
        config.setParam(layer2, "1265fce4-f331-4459-bed5-3747039c7bd9");
        config.setParam("full", "true");
        AnalysisLogger.setLogger((String)(config.getConfigPath() + AlgorithmConfiguration.defaultLoggerFile));
        new MapsComparatorNode().setup(config);
        BufferedWriter oos = new BufferedWriter(new FileWriter(new File(sandbox, configfile)));
        oos.write(new XStream().toXML((Object)config));
        oos.close();
        int ncomp = 1;
        int nslices = 361;
        for (int i = 0; i < ncomp; ++i) {
            int randi = (int)(Math.random() * (double)nslices);
            System.out.println("->Comparing for index " + randi);
            new MapsComparatorNode().executeNode(0, 0, randi, randi, false, sandbox, configfile, "test.log");
        }
        float el = (float)elapsedt / (float)ncomp;
        System.out.println("Mean time:" + el);
        System.out.println("Mean time on 21 nodes:" + el * (float)nslices / 21.0f);
    }
}

