/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataanalysis.wps.statisticalmanager.synchserver.utils;

import com.google.common.base.Predicate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import net.opengis.wps.x100.ProcessDescriptionType;
import org.n52.wps.algorithm.annotation.Algorithm;
import org.n52.wps.server.IAlgorithm;
import org.n52.wps.server.IAlgorithmRepository;
import org.reflections.Configuration;
import org.reflections.Reflections;
import org.reflections.util.ClasspathHelper;
import org.reflections.util.ConfigurationBuilder;
import org.reflections.util.FilterBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GcubeAlgorithmRepository
implements IAlgorithmRepository {
    private static long UPDATE_TIME_IN_MILLIS = 60000L;
    private static Logger log = LoggerFactory.getLogger(GcubeAlgorithmRepository.class);
    private static Long lastUpdate = 0L;
    private static Reflections reflection;

    public GcubeAlgorithmRepository() {
        GcubeAlgorithmRepository.updateRepository();
    }

    public ProcessDescriptionType getProcessDescription(String identifier) {
        GcubeAlgorithmRepository.updateRepository();
        log.info("getProcessDescription with identifier {} ", (Object)identifier);
        try {
            Set classes = reflection.getTypesAnnotatedWith(Algorithm.class);
            for (Class _class : classes) {
                if (!_class.getAnnotation(Algorithm.class).identifier().equals(identifier)) continue;
                return ((IAlgorithm)_class.newInstance()).getDescription();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        throw new RuntimeException(String.format("Algorithm with process id %s not found", identifier));
    }

    public boolean containsAlgorithm(String identifier) {
        GcubeAlgorithmRepository.updateRepository();
        log.info("containsAlgorithm with identifier {} ", (Object)identifier);
        Set classes = reflection.getTypesAnnotatedWith(Algorithm.class);
        for (Class _class : classes) {
            if (!_class.getAnnotation(Algorithm.class).identifier().equals(identifier)) continue;
            return true;
        }
        return false;
    }

    public IAlgorithm getAlgorithm(String identifier) {
        GcubeAlgorithmRepository.updateRepository();
        log.info("getAlgorithm with identifier {} ", (Object)identifier);
        try {
            Set classes = reflection.getTypesAnnotatedWith(Algorithm.class);
            for (Class _class : classes) {
                if (!_class.getAnnotation(Algorithm.class).identifier().equals(identifier)) continue;
                if (IAlgorithm.class.isAssignableFrom(_class)) {
                    return (IAlgorithm)_class.newInstance();
                }
                log.warn("found algorothm class {} is no assignable from {}", (Object)_class.getName(), (Object)IAlgorithm.class.getName());
                break;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        throw new RuntimeException(String.format("Algorithm with id %s not found", identifier));
    }

    public static Set<Class<?>> getAllAlgorithms() {
        GcubeAlgorithmRepository.updateRepository();
        return reflection.getTypesAnnotatedWith(Algorithm.class);
    }

    private static synchronized void updateRepository() {
        if (System.currentTimeMillis() - lastUpdate > UPDATE_TIME_IN_MILLIS) {
            log.info("update time passed, updating repository");
            String packageToFind = "org.gcube.dataanalysis.wps.statisticalmanager.synchserver.mappedclasses";
            ConfigurationBuilder confBuilder = new ConfigurationBuilder().filterInputsBy((Predicate)new FilterBuilder().include(FilterBuilder.prefix((String)packageToFind))).setUrls(ClasspathHelper.forClassLoader());
            reflection = new Reflections((Configuration)confBuilder);
            lastUpdate = System.currentTimeMillis();
        }
    }

    public Collection<String> getAlgorithmNames() {
        GcubeAlgorithmRepository.updateRepository();
        ArrayList<String> toReturn = new ArrayList<String>();
        Set classes = reflection.getTypesAnnotatedWith(Algorithm.class);
        for (Class _class : classes) {
            toReturn.add(_class.getAnnotation(Algorithm.class).title());
        }
        return toReturn;
    }

    public void shutdown() {
        lastUpdate = 0L;
        reflection = null;
    }
}

