/*
 * Decompiled with CFR 0.152.
 */
package org.n52.wps.demo;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import org.apache.commons.io.IOUtils;
import org.gcube.dataanalysis.wps.statisticalmanager.synchserver.bindings.D4ScienceFileDataBinding;
import org.gcube.dataanalysis.wps.statisticalmanager.synchserver.bindings.GisLinkDataBinding;
import org.n52.wps.algorithm.annotation.Algorithm;
import org.n52.wps.algorithm.annotation.ComplexDataInput;
import org.n52.wps.algorithm.annotation.ComplexDataOutput;
import org.n52.wps.algorithm.annotation.Execute;
import org.n52.wps.algorithm.annotation.LiteralDataInput;
import org.n52.wps.algorithm.annotation.LiteralDataOutput;
import org.n52.wps.io.data.GenericFileData;
import org.n52.wps.io.data.binding.literal.LiteralStringBinding;
import org.n52.wps.server.AbstractAnnotatedAlgorithm;

@Algorithm(statusSupported=false, title="title of the A.", abstrakt="hello worlds", identifier="org.n52.wps.demo.GPDemoFile", version="1.1.0")
public class GPDemoFile
extends AbstractAnnotatedAlgorithm {
    private String data;
    private GenericFileData file;
    private GenericFileData gis;
    private GenericFileData outfile;
    private String lout;
    private GenericFileData link;

    @LiteralDataInput(allowedValues={"c", "a"}, defaultValue="1", identifier="CHECK", binding=LiteralStringBinding.class)
    public void setLData(String data) {
        this.data = data;
    }

    @ComplexDataInput(abstrakt="", title="", maxOccurs=1, minOccurs=1, identifier="FFF", binding=D4ScienceFileDataBinding.class)
    public void setCDataType(GenericFileData file) {
        this.file = file;
    }

    @ComplexDataInput(identifier="GIS", binding=GisLinkDataBinding.class)
    public void setGisDataType(GenericFileData file) {
        this.gis = file;
    }

    @ComplexDataOutput(identifier="file", binding=D4ScienceFileDataBinding.class)
    public GenericFileData getFile() {
        return this.outfile;
    }

    @LiteralDataOutput(identifier="lout", binding=LiteralStringBinding.class)
    public String getLiteral() {
        return this.lout;
    }

    @ComplexDataOutput(identifier="link", binding=GisLinkDataBinding.class)
    public GenericFileData getGisLink() {
        return this.link;
    }

    @Execute
    public void run() {
        String theString;
        StringWriter writer;
        InputStream is;
        File f;
        if (this.file != null) {
            f = this.file.getBaseFile(false);
            is = this.file.getDataStream();
            System.out.println("We got a Generic File! " + f.getAbsolutePath());
            writer = new StringWriter();
            try {
                IOUtils.copy((InputStream)is, (Writer)writer, (String)"UTF-8");
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            theString = writer.toString();
            System.out.println("Content: " + theString);
            this.lout = "OK";
        }
        if (this.gis != null) {
            f = this.gis.getBaseFile(false);
            is = this.file.getDataStream();
            System.out.println("We got a GIS Link! " + f.getAbsolutePath());
            writer = new StringWriter();
            try {
                IOUtils.copy((InputStream)is, (Writer)writer, (String)"UTF-8");
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            theString = writer.toString();
            System.out.println("Gis Content: " + theString);
        }
        try {
            File of = new File("C:\\Users\\GP\\Desktop\\WorkFolder\\WPS\\WPS.txt");
            System.out.println("File Exists: " + of.exists());
            this.outfile = new GenericFileData(of, "image/png");
            System.out.println("Generating GIS Link binding");
            this.link = new GenericFileData(of, "text/wfs");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

