/*
 * Decompiled with CFR 0.152.
 */
package org.n52.wps.demo;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.n52.wps.io.data.GenericFileData;
import org.n52.wps.io.data.IData;
import org.n52.wps.io.data.binding.complex.FileDataBinding;
import org.n52.wps.io.data.binding.complex.GenericFileDataBinding;
import org.n52.wps.io.data.binding.literal.LiteralStringBinding;
import org.n52.wps.server.AbstractSelfDescribingAlgorithm;
import org.n52.wps.server.ExceptionReport;

public class CopyOfGPDemoFile
extends AbstractSelfDescribingAlgorithm {
    public Class<?> getInputDataType(String identifier) {
        if (identifier.equalsIgnoreCase("CHECK")) {
            return LiteralStringBinding.class;
        }
        if (identifier.equalsIgnoreCase("FFF")) {
            return GenericFileDataBinding.class;
        }
        return null;
    }

    public Class<?> getOutputDataType(String identifier) {
        if (identifier.equalsIgnoreCase("polygons")) {
            return LiteralStringBinding.class;
        }
        if (identifier.equalsIgnoreCase("file")) {
            return GenericFileDataBinding.class;
        }
        return null;
    }

    public Map<String, IData> run(Map<String, List<IData>> inputData) throws ExceptionReport {
        File file;
        FileDataBinding fileDataBinding;
        if (inputData == null || !inputData.containsKey("CHECK")) {
            throw new RuntimeException("Error while allocating input parameters");
        }
        List<IData> dataList = inputData.get("CHECK");
        if (dataList == null || dataList.size() != 1) {
            throw new RuntimeException("Error while allocating input parameters");
        }
        IData data = inputData.get("FFF").get(0);
        if (data instanceof FileDataBinding) {
            System.out.println("We got a standard File! ");
            fileDataBinding = (FileDataBinding)data;
            file = fileDataBinding.getPayload();
            System.out.println("Here ! " + file.getAbsolutePath());
        }
        fileDataBinding = null;
        if (data instanceof GenericFileDataBinding) {
            fileDataBinding = (GenericFileDataBinding)data;
            file = fileDataBinding.getPayload().getBaseFile(false);
            InputStream is = fileDataBinding.getPayload().getDataStream();
            System.out.println("We got a Generic File! " + file.getAbsolutePath());
            StringWriter writer = new StringWriter();
            try {
                IOUtils.copy((InputStream)is, (Writer)writer, (String)"UTF-8");
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            String theString = writer.toString();
            System.out.println("Content! " + theString);
        }
        GenericFileDataBinding binder = null;
        try {
            File of = new File("C:\\Users\\GP\\Desktop\\WorkFolder\\WPS\\WPS.txt");
            System.out.println("File Exists: " + of.exists());
            binder = new GenericFileDataBinding(new GenericFileData(of, "text/plain"));
            System.out.println("File mime: " + binder.getPayload().getMimeType());
            System.out.println("File extension: " + binder.getPayload().getFileExtension());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        HashMap<String, IData> result = new HashMap<String, IData>();
        result.put("polygons", (IData)new LiteralStringBinding("hello world"));
        result.put("file", (IData)binder);
        return result;
    }

    public List<String> getInputIdentifiers() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("CHECK");
        list.add("FFF");
        return list;
    }

    public List<String> getOutputIdentifiers() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("polygons");
        list.add("file");
        return list;
    }
}

