/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataanalysis.wps.statisticalmanager.synchserver.mappedclasses.transducerers;

import java.net.URL;
import org.apache.xmlbeans.XmlObject;
import org.gcube.dataanalysis.wps.statisticalmanager.synchserver.bindings.CsvFileDataBinding;
import org.gcube.dataanalysis.wps.statisticalmanager.synchserver.bindings.D4ScienceFileDataBinding;
import org.gcube.dataanalysis.wps.statisticalmanager.synchserver.mappedclasses.ITransducer;
import org.gcube.dataanalysis.wps.statisticalmanager.synchserver.mapping.AbstractEcologicalEngineMapper;
import org.n52.wps.algorithm.annotation.Algorithm;
import org.n52.wps.algorithm.annotation.ComplexDataInput;
import org.n52.wps.algorithm.annotation.ComplexDataOutput;
import org.n52.wps.algorithm.annotation.Execute;
import org.n52.wps.algorithm.annotation.LiteralDataInput;
import org.n52.wps.algorithm.annotation.LiteralDataOutput;
import org.n52.wps.io.data.GenericFileData;
import org.n52.wps.io.data.binding.complex.GenericFileDataBinding;
import org.n52.wps.io.data.binding.complex.GenericXMLDataBinding;
import org.n52.wps.io.data.binding.literal.LiteralDoubleBinding;
import org.n52.wps.io.data.binding.literal.LiteralIntBinding;
import org.n52.wps.io.data.binding.literal.LiteralStringBinding;

@Algorithm(statusSupported=true, title="MAX_ENT_NICHE_MODELLING", abstrakt="A Maximum-Entropy model for species habitat modeling, based on the implementation by Shapire et al. v 3.3.3k, Princeton University, http://www.cs.princeton.edu/schapire/maxent/. In this adaptation for the D4Science infrastructure, the software accepts a table produced by the Species Product Discovery service and a set of environmental layers in various formats (NetCDF, WFS, WCS, ASC, GeoTiff) via direct links or GeoExplorer UUIDs. The user can also establish the bounding box and the spatial resolution (in decimal deg.) of the training and the projection. The application will adapt the layers to that resolution if this is higher than the native one.The output contains: a thumbnail map of the projected model, the ROC curve, the Omission/Commission chart, a table containing the raw assigned values, a threshold to transform the table into a 0-1 probability distribution, a report of the importance of the used layers in the model, ASCII representations of the input layers to check their alignment.Other processes can be later applied to the raw values to produce a GIS map (e.g. the Statistical Manager Points-to-Map process) and results can be shared. Demo video: http://goo.gl/TYYnTO and instructions http://wiki.i-marine.eu/index.php/MaxEnt", identifier="org.gcube.dataanalysis.wps.statisticalmanager.synchserver.mappedclasses.transducerers.MAX_ENT_NICHE_MODELLING", version="1.1.0")
public class MAX_ENT_NICHE_MODELLING
extends AbstractEcologicalEngineMapper
implements ITransducer {
    @LiteralDataInput(abstrakt="Name of the parameter: OutputTableLabel. The name of the table to produce", defaultValue="maxent_", title="The name of the table to produce", identifier="OutputTableLabel", maxOccurs=1, minOccurs=1, binding=LiteralStringBinding.class)
    public void setOutputTableLabel(String data) {
        this.inputs.put("OutputTableLabel", data);
    }

    @LiteralDataInput(abstrakt="Name of the parameter: SpeciesName. The name of the species to model and the occurrence records refer to", defaultValue="generic_species", title="The name of the species to model and the occurrence records refer to", identifier="SpeciesName", maxOccurs=1, minOccurs=1, binding=LiteralStringBinding.class)
    public void setSpeciesName(String data) {
        this.inputs.put("SpeciesName", data);
    }

    @LiteralDataInput(abstrakt="Name of the parameter: MaxIterations. The number of learning iterations of the MaxEnt algorithm", defaultValue="1000", title="The number of learning iterations of the MaxEnt algorithm", identifier="MaxIterations", maxOccurs=1, minOccurs=1, binding=LiteralIntBinding.class)
    public void setMaxIterations(Integer data) {
        this.inputs.put("MaxIterations", "" + data);
    }

    @LiteralDataInput(abstrakt="Name of the parameter: DefaultPrevalence. A priori probability of presence at ordinary occurrence points", defaultValue="0.5", title="A priori probability of presence at ordinary occurrence points", identifier="DefaultPrevalence", maxOccurs=1, minOccurs=1, binding=LiteralDoubleBinding.class)
    public void setDefaultPrevalence(Double data) {
        this.inputs.put("DefaultPrevalence", "" + data);
    }

    @ComplexDataInput(abstrakt="Name of the parameter: OccurrencesTable. A geospatial table containing occurrence records, following the template of the Species Products Discovery datasets [a http link to a table in UTF-8 encoding following this template: (OCCURRENCE_SPECIES) http://goo.gl/4ExuR5]", title="A geospatial table containing occurrence records, following the template of the Species Products Discovery datasets [a http link to a table in UTF-8 encoding following this template: (OCCURRENCE_SPECIES) http://goo.gl/4ExuR5]", maxOccurs=1, minOccurs=1, identifier="OccurrencesTable", binding=GenericFileDataBinding.class)
    public void setOccurrencesTable(GenericFileData file) {
        this.inputs.put("OccurrencesTable", file);
    }

    @LiteralDataInput(abstrakt="Name of the parameter: LongitudeColumn. The column containing longitude values [the name of a column from OccurrencesTable]", defaultValue="decimallongitude", title="The column containing longitude values [the name of a column from OccurrencesTable]", identifier="LongitudeColumn", maxOccurs=1, minOccurs=1, binding=LiteralStringBinding.class)
    public void setLongitudeColumn(String data) {
        this.inputs.put("LongitudeColumn", data);
    }

    @LiteralDataInput(abstrakt="Name of the parameter: LatitudeColumn. The column containing latitude values [the name of a column from OccurrencesTable]", defaultValue="decimallatitude", title="The column containing latitude values [the name of a column from OccurrencesTable]", identifier="LatitudeColumn", maxOccurs=1, minOccurs=1, binding=LiteralStringBinding.class)
    public void setLatitudeColumn(String data) {
        this.inputs.put("LatitudeColumn", data);
    }

    @LiteralDataInput(abstrakt="Name of the parameter: XResolution. Model projection resolution on the X axis in decimal degrees", defaultValue="1", title="Model projection resolution on the X axis in decimal degrees", identifier="XResolution", maxOccurs=1, minOccurs=1, binding=LiteralDoubleBinding.class)
    public void setXResolution(Double data) {
        this.inputs.put("XResolution", "" + data);
    }

    @LiteralDataInput(abstrakt="Name of the parameter: YResolution. Model projection resolution on the Y axis in decimal degrees", defaultValue="1", title="Model projection resolution on the Y axis in decimal degrees", identifier="YResolution", maxOccurs=1, minOccurs=1, binding=LiteralDoubleBinding.class)
    public void setYResolution(Double data) {
        this.inputs.put("YResolution", "" + data);
    }

    @LiteralDataInput(abstrakt="Name of the parameter: Layers. The list of environmental layers to use for enriching the points. Each entry is a layer Title or UUID or HTTP link. E.g. the title or the UUID (preferred) of a layer indexed in the e-Infrastructure on GeoNetwork - You can retrieve it from GeoExplorer. Otherwise you can supply the direct HTTP link of the layer. The format will be guessed from the link. The default is GeoTiff. Supports several standards (NETCDF, WFS, WCS, ASC, GeoTiff ). E.g. https://dl.dropboxusercontent.com/u/12809149/wind1.tif [a sequence of values separated by | ] (format: String)", defaultValue="", title="The list of environmental layers to use for enriching the points. Each entry is a layer Title or UUID or HTTP link. E.g. the title or the UUID (preferred) of a layer indexed in the e-Infrastructure on GeoNetwork - You can retrieve it from GeoExplorer. Otherwise you can supply the direct HTTP link of the layer. The format will be guessed from the link. The default is GeoTiff. Supports several standards (NETCDF, WFS, WCS, ASC, GeoTiff ). E.g. https://dl.dropboxusercontent.com/u/12809149/wind1.tif [a sequence of values separated by | ] (format: String)", identifier="Layers", maxOccurs=1, minOccurs=1, binding=LiteralStringBinding.class)
    public void setLayers(String data) {
        this.inputs.put("Layers", data);
    }

    @LiteralDataInput(abstrakt="Name of the parameter: Z. Value of Z. Default is 0, that means environmental layers processing will be at surface level or at the first avaliable Z value in the layer", defaultValue="0", title="Value of Z. Default is 0, that means environmental layers processing will be at surface level or at the first avaliable Z value in the layer", identifier="Z", maxOccurs=1, minOccurs=1, binding=LiteralDoubleBinding.class)
    public void setZ(Double data) {
        this.inputs.put("Z", "" + data);
    }

    @LiteralDataInput(abstrakt="Name of the parameter: TimeIndex. Time Index. The default is the first time indexed in the input environmental datasets", defaultValue="0", title="Time Index. The default is the first time indexed in the input environmental datasets", identifier="TimeIndex", maxOccurs=1, minOccurs=1, binding=LiteralIntBinding.class)
    public void setTimeIndex(Integer data) {
        this.inputs.put("TimeIndex", "" + data);
    }

    @LiteralDataOutput(abstrakt="Name of the parameter: Best Threshold. Best threshold for transforming MaxEnt values into 0/1 probability assignments", title="Best threshold for transforming MaxEnt values into 0/1 probability assignments", identifier="Best Threshold", binding=LiteralStringBinding.class)
    public String getBest_Threshold() {
        return (String)this.outputs.get("Best Threshold");
    }

    @LiteralDataOutput(abstrakt="Name of the parameter: Estimated Prevalence. The a posteriori estimated prevalence of the species", title="The a posteriori estimated prevalence of the species", identifier="Estimated Prevalence", binding=LiteralStringBinding.class)
    public String getEstimated_Prevalence() {
        return (String)this.outputs.get("Estimated Prevalence");
    }

    @LiteralDataOutput(abstrakt="Name of the parameter: Variables contributions. The contribution of each variable to the MaxEnt values estimates", title="The contribution of each variable to the MaxEnt values estimates", identifier="Variables contributions", binding=LiteralStringBinding.class)
    public String getVariables_contributions() {
        return (String)this.outputs.get("Variables contributions");
    }

    @LiteralDataOutput(abstrakt="Name of the parameter: Variables Permutations Importance. The importance of the permutations of the variables during the training", title="The importance of the permutations of the variables during the training", identifier="Variables Permutations Importance", binding=LiteralStringBinding.class)
    public String getVariables_Permutations_Importance() {
        return (String)this.outputs.get("Variables Permutations Importance");
    }

    @ComplexDataOutput(abstrakt="Name of the parameter: ASCII Maps of the environmental layers for checking features aligments. ASCII Maps of the environmental layers for checking features aligments", title="ASCII Maps of the environmental layers for checking features aligments", identifier="ASCII Maps of the environmental layers for checking features aligments", binding=D4ScienceFileDataBinding.class)
    public GenericFileData getASCII_Maps_of_the_environmental_layers_for_checking_features_aligments() {
        URL url = null;
        try {
            url = new URL((String)this.outputs.get("ASCII Maps of the environmental layers for checking features aligments"));
            return new GenericFileData(url.openStream(), "application/d4science");
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @ComplexDataOutput(abstrakt="Name of the parameter: OutputTable7. Output table [a http link to a table in UTF-8 ecoding following this template: (GENERIC) A generic comma separated csv file in UTF-8 encoding]", title="Output table [a http link to a table in UTF-8 ecoding following this template: (GENERIC) A generic comma separated csv file in UTF-8 encoding]", identifier="OutputTable7", binding=CsvFileDataBinding.class)
    public GenericFileData getOutputTable7() {
        URL url = null;
        try {
            url = new URL((String)this.outputs.get("OutputTable7"));
            return new GenericFileData(url.openStream(), "text/csv");
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @ComplexDataOutput(abstrakt="Output that is not predetermined", title="NonDeterministicOutput", identifier="non_deterministic_output", binding=GenericXMLDataBinding.class)
    public XmlObject getNon_deterministic_output() {
        return (XmlObject)this.outputs.get("non_deterministic_output");
    }

    @Override
    @Execute
    public void run() throws Exception {
        super.run();
    }
}

