/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataanalysis.wps.statisticalmanager.synchserver.capabilities;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.apache.http.util.EntityUtils;
import org.gcube.contentmanagement.lexicalmatcher.utils.AnalysisLogger;
import org.slf4j.LoggerFactory;

public class GetCapabilitiesChecker {
    private static final char DOT = '.';
    private static final char SLASH = '/';
    private static final String CLASS_SUFFIX = ".class";
    private static final String BAD_PACKAGE_ERROR = "Unable to get resources from path '%s'. Are you sure the package '%s' exists?";
    private static String RUNTIME_RESOURCE_NAME = "ReportsStoreGateway";
    private static String CATEGORY_NAME = "Service";

    public static List<Class<?>> getClassesInSamePackageFromJar(String packageName) throws Exception {
        String scannedPath = packageName.replace(".", "/");
        URL scannedUrl = Thread.currentThread().getContextClassLoader().getResource(scannedPath);
        String jarPath = scannedUrl.getFile();
        AnalysisLogger.getLogger().debug((Object)("Jar Path complete: " + jarPath));
        jarPath = jarPath.substring(jarPath.indexOf("file:/") + 6, jarPath.lastIndexOf("!"));
        if (jarPath.startsWith("home")) {
            jarPath = "/" + jarPath;
        }
        AnalysisLogger.getLogger().debug((Object)("Jar Path: " + jarPath));
        JarFile jarFile = null;
        ArrayList result = new ArrayList();
        try {
            jarFile = new JarFile(jarPath);
            Enumeration<JarEntry> en = jarFile.entries();
            while (en.hasMoreElements()) {
                JarEntry entry = en.nextElement();
                String entryName = entry.getName();
                packageName = packageName.replace('.', '/');
                if (entryName == null || !entryName.endsWith(CLASS_SUFFIX) || !entryName.startsWith(packageName)) continue;
                try {
                    Class<?> entryClass = Class.forName(entryName.substring(0, entryName.length() - 6).replace('/', '.'));
                    if (entryClass == null) continue;
                    result.add(entryClass);
                }
                catch (Throwable e) {}
            }
            ArrayList arrayList = result;
            return arrayList;
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            try {
                if (jarFile != null) {
                    jarFile.close();
                }
            }
            catch (Exception e) {}
        }
    }

    public static List<Class<?>> find(String scannedPackage) {
        String scannedPath = scannedPackage.replace('.', '/');
        URL scannedUrl = Thread.currentThread().getContextClassLoader().getResource(scannedPath);
        if (scannedUrl == null) {
            throw new IllegalArgumentException(String.format(BAD_PACKAGE_ERROR, scannedPath, scannedPackage));
        }
        File scannedDir = new File(scannedUrl.getFile());
        System.out.println("scannedDir:" + scannedDir);
        System.out.println("scannedUrl:" + scannedUrl);
        System.out.println("scannedUrl List:" + scannedDir.listFiles());
        ArrayList classes = new ArrayList();
        for (File file : scannedDir.listFiles()) {
            classes.addAll(GetCapabilitiesChecker.find(file, scannedPackage));
        }
        return classes;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static List<Class<?>> find(File file, String scannedPackage) {
        ArrayList classes = new ArrayList();
        String resource = scannedPackage + '.' + file.getName();
        if (file.isDirectory()) {
            for (File child : file.listFiles()) {
                classes.addAll(GetCapabilitiesChecker.find(child, resource));
            }
            return classes;
        } else {
            if (!resource.endsWith(CLASS_SUFFIX)) return classes;
            int endIndex = resource.length() - CLASS_SUFFIX.length();
            String className = resource.substring(0, endIndex);
            try {
                if (className.contains("IClusterer") || className.contains("IEvaluator") || className.contains("IGenerator") || className.contains("IModeller") || className.contains("ITransducer")) return classes;
                classes.add(Class.forName(className));
                return classes;
            }
            catch (ClassNotFoundException ignore) {
                // empty catch block
            }
        }
        return classes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readPage(URL url) throws Exception {
        DefaultHttpClient httpClient = new DefaultHttpClient();
        HttpParams params = httpClient.getParams();
        HttpConnectionParams.setConnectionTimeout((HttpParams)params, (int)420000);
        HttpConnectionParams.setSoTimeout((HttpParams)params, (int)420000);
        HttpConnectionParams.setStaleCheckingEnabled((HttpParams)params, (boolean)false);
        HttpConnectionParams.setSoKeepalive((HttpParams)params, (boolean)false);
        HttpGet request = new HttpGet(url.toURI());
        HttpResponse response = httpClient.execute((HttpUriRequest)request);
        System.out.println("URL executed!");
        InputStreamReader reader = null;
        try {
            int read;
            reader = new InputStreamReader(response.getEntity().getContent());
            System.out.println("Read input stream!");
            StringBuffer sb = new StringBuffer();
            char[] cbuf = new char[1024];
            while ((read = reader.read(cbuf)) != -1) {
                sb.append(cbuf, 0, read);
            }
            EntityUtils.consume((HttpEntity)response.getEntity());
            httpClient.getConnectionManager().shutdown();
            String string = sb.toString();
            return string;
        }
        finally {
            if (reader != null) {
                try {
                    ((Reader)reader).close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static Charset getConnectionCharset(URLConnection connection) {
        String charsetName;
        String contentType = null;
        try {
            contentType = connection.getContentType();
        }
        catch (Exception e) {
            return Charset.defaultCharset();
        }
        if (contentType != null && contentType.length() > 0 && (charsetName = GetCapabilitiesChecker.extractCharsetName(contentType = contentType.toLowerCase())) != null && charsetName.length() > 0) {
            try {
                return Charset.forName(charsetName);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return Charset.defaultCharset();
    }

    private static String extractCharsetName(String contentType) {
        String[] mediaTypes = contentType.split(":");
        if (mediaTypes.length > 0) {
            String[] params;
            for (String each : params = mediaTypes[0].split(";")) {
                if (!(each = each.trim()).startsWith("charset=")) continue;
                return each.substring(8).trim();
            }
        }
        return null;
    }

    public static String readPageNoHttpClient(URL url) throws Exception {
        String inputLine;
        URLConnection conn = url.openConnection();
        conn.addRequestProperty("User-Agent", "Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.11 (KHTML, like Gecko) Chrome/23.0.1271.95 Safari/537.11");
        conn.setDoOutput(true);
        conn.setAllowUserInteraction(true);
        conn.setConnectTimeout(1500000);
        conn.setReadTimeout(1500000);
        Charset charset = GetCapabilitiesChecker.getConnectionCharset(conn);
        BufferedReader dis = new BufferedReader(new InputStreamReader(conn.getInputStream(), charset));
        StringBuffer pageBuffer = new StringBuffer();
        while ((inputLine = dis.readLine()) != null) {
            pageBuffer.append(inputLine + "\r\n");
        }
        String page = pageBuffer.toString();
        System.out.println(page);
        conn.getInputStream().close();
        return page;
    }

    public static String readPageHTTPHeader(URL url, String token) throws Exception {
        String inputLine;
        URLConnection conn = url.openConnection();
        conn.addRequestProperty("User-Agent", "Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.11 (KHTML, like Gecko) Chrome/23.0.1271.95 Safari/537.11");
        conn.setDoOutput(true);
        conn.setAllowUserInteraction(true);
        conn.setConnectTimeout(1500000);
        conn.setReadTimeout(1500000);
        conn.setRequestProperty("gcube-token", token);
        Charset charset = GetCapabilitiesChecker.getConnectionCharset(conn);
        BufferedReader dis = new BufferedReader(new InputStreamReader(conn.getInputStream(), charset));
        StringBuffer pageBuffer = new StringBuffer();
        while ((inputLine = dis.readLine()) != null) {
            pageBuffer.append(inputLine + "\r\n");
        }
        String page = pageBuffer.toString();
        System.out.println(page);
        conn.getInputStream().close();
        return page;
    }

    public static void main(String[] args) throws Exception {
        String packageS = "org.gcube.dataanalysis.wps.statisticalmanager.synchserver.mappedclasses";
        List<Class<?>> classes = GetCapabilitiesChecker.find(packageS);
        System.out.println(classes + "\n");
        for (Class<?> classfind : classes) {
            System.out.println("<Property name=\"Algorithm\" active=\"true\">" + classfind.getName() + "</Property>");
        }
        System.out.println("\n");
        System.out.println(classes.size() + " algorithms");
    }

    public static void main1(String[] args) throws Exception {
        String packageS = "org.gcube.dataanalysis.wps.statisticalmanager.synchserver.mappedclasses";
        List<Class<?>> classes = GetCapabilitiesChecker.find(packageS);
        System.out.println(classes + "\n");
        for (Class<?> classfind : classes) {
            System.out.println("<Property name=\"Algorithm\" active=\"true\">" + classfind.getName() + "</Property>");
        }
        System.out.println("\n");
        for (Class<?> classfind : classes) {
            System.out.println("http://localhost:8080/wps/WebProcessingService?Request=DescribeProcess&Service=WPS&Version=1.0.0&Identifier=" + classfind.getName() + "\n");
        }
        System.out.println("\n");
        System.out.println("Checking errors in Processes descriptions");
        Logger root = (Logger)LoggerFactory.getLogger((String)"ROOT");
        root.setLevel(Level.OFF);
        int counter = 0;
        for (Class<?> classfind : classes) {
            String httplink = "http://statistical-manager-new.d4science.org:8080/wps/WebProcessingService?Request=DescribeProcess&Service=WPS&Version=1.0.0&Identifier=" + classfind.getName();
            if (httplink.contains("IClusterer") || httplink.contains("IEvaluator") || httplink.contains("IGenerator") || httplink.contains("IModeller") || httplink.contains("ITransducer")) continue;
            String pageCheck = GetCapabilitiesChecker.readPage(new URL(httplink));
            ++counter;
            if (!pageCheck.contains("ows:ExceptionText") && !pageCheck.contains("Exception")) continue;
            System.out.println("Reading Link: " + httplink);
            System.out.println("ERROR:\n" + pageCheck);
        }
        System.out.println("Checked " + counter + " algorithms");
    }
}

