/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataanalysis.wps.statisticalmanager.synchserver.web;

import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.math.BigInteger;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import javax.xml.parsers.DocumentBuilderFactory;
import net.opengis.ows.x11.BoundingBoxType;
import net.opengis.ows.x11.ExceptionReportDocument;
import net.opengis.ows.x11.ExceptionType;
import net.opengis.wps.x100.ComplexDataType;
import net.opengis.wps.x100.DataInputsType;
import net.opengis.wps.x100.DocumentOutputDefinitionType;
import net.opengis.wps.x100.ExecuteDocument;
import net.opengis.wps.x100.InputDescriptionType;
import net.opengis.wps.x100.InputReferenceType;
import net.opengis.wps.x100.InputType;
import net.opengis.wps.x100.LiteralDataType;
import net.opengis.wps.x100.OutputDefinitionType;
import net.opengis.wps.x100.OutputDescriptionType;
import net.opengis.wps.x100.ProcessDescriptionType;
import net.opengis.wps.x100.ResponseDocumentType;
import net.opengis.wps.x100.ResponseFormType;
import net.opengis.wps.x100.StatusType;
import org.apache.commons.collections.map.CaseInsensitiveMap;
import org.apache.commons.io.IOUtils;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.XmlOptions;
import org.gcube.dataanalysis.wps.statisticalmanager.synchserver.web.ExecuteResponse;
import org.gcube.dataanalysis.wps.statisticalmanager.synchserver.web.ExecuteResponseBuilder;
import org.n52.wps.commons.context.ExecutionContext;
import org.n52.wps.commons.context.ExecutionContextFactory;
import org.n52.wps.io.data.IComplexData;
import org.n52.wps.io.data.IData;
import org.n52.wps.server.AbstractTransactionalAlgorithm;
import org.n52.wps.server.ExceptionReport;
import org.n52.wps.server.RepositoryManager;
import org.n52.wps.server.database.DatabaseFactory;
import org.n52.wps.server.observerpattern.IObserver;
import org.n52.wps.server.observerpattern.ISubject;
import org.n52.wps.server.request.InputHandler;
import org.n52.wps.server.request.Request;
import org.n52.wps.server.response.Response;
import org.n52.wps.util.XMLBeansHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class ExecuteRequest
extends Request
implements IObserver {
    private static Logger LOGGER = LoggerFactory.getLogger(ExecuteRequest.class);
    private ExecuteDocument execDom;
    private Map<String, IData> returnResults;
    private ExecuteResponseBuilder execRespType;

    public ExecuteRequest(Document doc) throws ExceptionReport {
        super(doc);
        try {
            System.out.println("Preparing the ExecuteRequest for POST");
            XmlOptions option = new XmlOptions();
            option.setLoadTrimTextBuffer();
            System.out.println("Parsing document");
            this.execDom = ExecuteDocument.Factory.parse((Node)doc, (XmlOptions)option);
            if (this.execDom == null) {
                LOGGER.error("ExecuteDocument is null");
                System.out.println("EXCEPTION ExecuteDocument is null");
                throw new ExceptionReport("Error while parsing post data", "MissingParameterValue");
            }
        }
        catch (XmlException e) {
            System.out.println("EXCEPTION Error while parsing post dataMissingParameterValue" + e.getLocalizedMessage());
            throw new ExceptionReport("Error while parsing post data", "MissingParameterValue", (Throwable)e);
        }
        System.out.println("Validating document");
        System.out.println("Document OK");
        this.execRespType = new ExecuteResponseBuilder(this);
        System.out.println("Response Builder Ready");
        this.storeRequest(this.execDom);
        System.out.println("Request Stored");
    }

    public ExecuteRequest(CaseInsensitiveMap ciMap) throws ExceptionReport {
        super(ciMap);
        this.initForGET(ciMap);
        this.validate();
        this.execRespType = new ExecuteResponseBuilder(this);
        this.storeRequest(ciMap);
    }

    public void getKVPDataInputs() {
    }

    private void initForGET(CaseInsensitiveMap ciMap) throws ExceptionReport {
        String rawData;
        String responseDocument;
        Object encodingAttribute;
        String[] inputs;
        String version = ExecuteRequest.getMapValue((String)"version", (CaseInsensitiveMap)ciMap, (boolean)true);
        if (!version.equals("1.0.0")) {
            throw new ExceptionReport("request version is not supported: " + version, "VersionNegotiationFailed");
        }
        this.execDom = ExecuteDocument.Factory.newInstance();
        ExecuteDocument.Execute execute = this.execDom.addNewExecute();
        String processID = this.getMapValue("Identifier", true);
        if (!RepositoryManager.getInstance().containsAlgorithm(processID)) {
            throw new ExceptionReport("Process does not exist", "InvalidParameterValue");
        }
        execute.addNewIdentifier().setStringValue(processID);
        DataInputsType dataInputs = execute.addNewDataInputs();
        String dataInputString = this.getMapValue("DataInputs", true);
        dataInputString = dataInputString.replace("&amp;", "&");
        String[] stringArray = inputs = dataInputString.split(";");
        int n = inputs.length;
        int n2 = 0;
        while (n2 < n) {
            ProcessDescriptionType description;
            String inputString = stringArray[n2];
            int position = inputString.indexOf("=");
            if (position == -1) {
                throw new ExceptionReport("No \"=\" supplied for attribute: " + inputString, "MissingParameterValue");
            }
            String key = inputString.substring(0, position);
            String value = null;
            if (key.length() + 1 < inputString.length()) {
                int valueDelimiter = inputString.indexOf("@");
                value = valueDelimiter != -1 && position + 1 < valueDelimiter ? inputString.substring(position + 1, valueDelimiter) : inputString.substring(position + 1);
            }
            if ((description = RepositoryManager.getInstance().getProcessDescription(processID)) == null) {
                throw new ExceptionReport("Data Identifier not supported: " + key, "MissingParameterValue");
            }
            InputDescriptionType inputDesc = XMLBeansHelper.findInputByID((String)key, (ProcessDescriptionType.DataInputs)description.getDataInputs());
            if (inputDesc == null) {
                throw new ExceptionReport("Data Identifier not supported: " + key, "MissingParameterValue");
            }
            InputType input = dataInputs.addNewInput();
            input.addNewIdentifier().setStringValue(key);
            encodingAttribute = null;
            String mimeTypeAttribute = null;
            String schemaAttribute = null;
            String hrefAttribute = null;
            String uom = null;
            String dataType = null;
            String[] inputItemstemp = inputString.split("@");
            String[] inputItems = null;
            inputItems = inputItemstemp.length == 2 ? inputItemstemp[1].split("@") : inputString.split("@");
            if (inputItemstemp.length > 1) {
                int i = 0;
                while (i < inputItems.length) {
                    int attributePos = inputItems[i].indexOf("=");
                    if (attributePos != -1 && attributePos + 1 < inputItems[i].length()) {
                        String attributeName = inputItems[i].substring(0, attributePos);
                        String attributeValue = inputItems[i].substring(attributePos + 1);
                        if (!attributeName.equals(key)) {
                            try {
                                attributeValue = URLDecoder.decode(attributeValue, "UTF-8");
                            }
                            catch (UnsupportedEncodingException e) {
                                throw new ExceptionReport("Something went wrong while trying to decode value of " + attributeName, "NoApplicableCode", (Throwable)e);
                            }
                            if (attributeName.equalsIgnoreCase("encoding")) {
                                encodingAttribute = attributeValue;
                            } else if (attributeName.equalsIgnoreCase("mimeType")) {
                                mimeTypeAttribute = attributeValue;
                            } else if (attributeName.equalsIgnoreCase("schema")) {
                                schemaAttribute = attributeValue;
                            } else if (attributeName.equalsIgnoreCase("href") | attributeName.equalsIgnoreCase("xlink:href")) {
                                hrefAttribute = attributeValue;
                            } else if (attributeName.equalsIgnoreCase("uom")) {
                                uom = attributeValue;
                            } else if (attributeName.equalsIgnoreCase("datatype")) {
                                dataType = attributeValue;
                            } else {
                                throw new ExceptionReport("Attribute is not supported: " + attributeName, "InvalidParameterValue");
                            }
                        }
                    }
                    ++i;
                }
            }
            if (inputDesc.isSetComplexData()) {
                if (hrefAttribute != null && !hrefAttribute.equals("")) {
                    InputReferenceType reference = input.addNewReference();
                    reference.setHref(hrefAttribute);
                    if (schemaAttribute != null) {
                        reference.setSchema(schemaAttribute);
                    }
                    if (mimeTypeAttribute != null) {
                        reference.setMimeType(mimeTypeAttribute);
                    }
                    if (encodingAttribute != null) {
                        reference.setEncoding((String)encodingAttribute);
                    }
                } else {
                    ComplexDataType data = input.addNewData().addNewComplexData();
                    ByteArrayInputStream stream = new ByteArrayInputStream(value.getBytes());
                    try {
                        data.set(XmlObject.Factory.parse((InputStream)stream));
                    }
                    catch (Exception e) {
                        LOGGER.warn("Could not parse value: " + value + " as XMLObject. Trying to create text node.");
                        try {
                            Text textNode = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument().createTextNode(value);
                            data.set(XmlObject.Factory.parse((Node)textNode));
                        }
                        catch (Exception e1) {
                            throw new ExceptionReport("Exception while trying to parse value: " + value, "NoApplicableCode", (Throwable)e1);
                        }
                    }
                    if (schemaAttribute != null) {
                        data.setSchema(schemaAttribute);
                    }
                    if (mimeTypeAttribute != null) {
                        data.setMimeType(mimeTypeAttribute);
                    }
                    if (encodingAttribute != null) {
                        data.setEncoding((String)encodingAttribute);
                    }
                }
            } else if (inputDesc.isSetLiteralData()) {
                LiteralDataType data = input.addNewData().addNewLiteralData();
                if (value == null) {
                    throw new ExceptionReport("No value provided for literal: " + inputDesc.getIdentifier().getStringValue(), "MissingParameterValue");
                }
                data.setStringValue(value);
                if (uom != null) {
                    data.setUom(uom);
                }
                if (dataType != null) {
                    data.setDataType(dataType);
                }
            } else if (inputDesc.isSetBoundingBoxData()) {
                BoundingBoxType data = input.addNewData().addNewBoundingBoxData();
                String[] values = value.split(",");
                if (values.length < 4) {
                    throw new ExceptionReport("Invalid Number of BBOX Values: " + inputDesc.getIdentifier().getStringValue(), "MissingParameterValue");
                }
                ArrayList<String> lowerCorner = new ArrayList<String>();
                lowerCorner.add(values[0]);
                lowerCorner.add(values[1]);
                data.setLowerCorner(lowerCorner);
                ArrayList<String> upperCorner = new ArrayList<String>();
                upperCorner.add(values[2]);
                upperCorner.add(values[3]);
                data.setUpperCorner(upperCorner);
                if (values.length > 4) {
                    data.setCrs(values[4]);
                }
                if (values.length > 5) {
                    data.setDimensions(BigInteger.valueOf(Long.valueOf(values[5])));
                }
            }
            ++n2;
        }
        boolean status = false;
        String statusString = this.getMapValue("status", false);
        System.out.println("Incoming Status Request: " + statusString);
        if (statusString != null) {
            status = Boolean.parseBoolean(statusString);
        }
        boolean store = false;
        String storeString = this.getMapValue("storeExecuteResponse", false);
        System.out.println("Incoming storeExecuteResponse Request: " + storeString);
        if (storeString != null) {
            store = Boolean.parseBoolean(storeString);
        }
        if ((responseDocument = this.getMapValue("ResponseDocument", false)) != null) {
            String[] outputs = responseDocument.split(";");
            ResponseDocumentType responseDoc = execute.addNewResponseForm().addNewResponseDocument();
            responseDoc.setStatus(status);
            responseDoc.setStoreExecuteResponse(store);
            encodingAttribute = outputs;
            int input = outputs.length;
            int inputDesc = 0;
            while (inputDesc < input) {
                ProcessDescriptionType description;
                String outputID = encodingAttribute[inputDesc];
                String[] outputDataparameters = outputID.split("@");
                String outputDataInput = "";
                outputDataInput = outputDataparameters.length > 0 ? outputDataparameters[0] : outputID;
                OutputDescriptionType outputDesc = XMLBeansHelper.findOutputByID((String)(outputDataInput = outputDataInput.replace("=", "")), (OutputDescriptionType[])(description = RepositoryManager.getInstance().getProcessDescription(processID)).getProcessOutputs().getOutputArray());
                if (outputDesc == null) {
                    throw new ExceptionReport("Data output Identifier not supported: " + outputDataInput, "MissingParameterValue");
                }
                DocumentOutputDefinitionType output = responseDoc.addNewOutput();
                output.addNewIdentifier().setStringValue(outputDataInput);
                int i = 1;
                while (i < outputDataparameters.length) {
                    int attributePos = outputDataparameters[i].indexOf("=");
                    if (attributePos != -1 && attributePos + 1 < outputDataparameters[i].length()) {
                        String attributeName = outputDataparameters[i].substring(0, attributePos);
                        String attributeValue = outputDataparameters[i].substring(attributePos + 1);
                        try {
                            attributeValue = URLDecoder.decode(attributeValue, "UTF-8");
                        }
                        catch (UnsupportedEncodingException e) {
                            throw new ExceptionReport("Something went wrong while trying to decode value of " + attributeName, "NoApplicableCode", (Throwable)e);
                        }
                        if (attributeName.equalsIgnoreCase("mimeType")) {
                            output.setMimeType(attributeValue);
                        } else if (attributeName.equalsIgnoreCase("schema")) {
                            output.setSchema(attributeValue);
                        } else if (attributeName.equalsIgnoreCase("encoding")) {
                            output.setEncoding(attributeValue);
                        }
                    }
                    ++i;
                }
                ++inputDesc;
            }
        }
        if ((rawData = this.getMapValue("RawDataOutput", false)) != null) {
            ProcessDescriptionType description;
            String[] rawDataparameters = rawData.split("@");
            String rawDataInput = "";
            rawDataInput = rawDataparameters.length > 0 ? rawDataparameters[0] : rawData;
            OutputDescriptionType outputDesc = XMLBeansHelper.findOutputByID((String)rawDataInput, (OutputDescriptionType[])(description = RepositoryManager.getInstance().getProcessDescription(processID)).getProcessOutputs().getOutputArray());
            if (outputDesc == null) {
                throw new ExceptionReport("Data output Identifier not supported: " + rawData, "MissingParameterValue");
            }
            ResponseFormType responseForm = execute.addNewResponseForm();
            OutputDefinitionType output = responseForm.addNewRawDataOutput();
            output.addNewIdentifier().setStringValue(outputDesc.getIdentifier().getStringValue());
            if (rawDataparameters.length > 0) {
                int i = 0;
                while (i < rawDataparameters.length) {
                    int attributePos = rawDataparameters[i].indexOf("=");
                    if (attributePos != -1 && attributePos + 1 < rawDataparameters[i].length()) {
                        String attributeName = rawDataparameters[i].substring(0, attributePos);
                        String attributeValue = rawDataparameters[i].substring(attributePos + 1);
                        try {
                            attributeValue = URLDecoder.decode(attributeValue, "UTF-8");
                        }
                        catch (UnsupportedEncodingException e) {
                            throw new ExceptionReport("Something went wrong while trying to decode value of " + attributeName, "NoApplicableCode", (Throwable)e);
                        }
                        if (attributeName.equalsIgnoreCase("mimeType")) {
                            output.setMimeType(attributeValue);
                        } else if (attributeName.equalsIgnoreCase("schema")) {
                            output.setSchema(attributeValue);
                        } else if (attributeName.equalsIgnoreCase("encoding")) {
                            output.setEncoding(attributeValue);
                        } else {
                            throw new ExceptionReport("Attribute is not supported: " + attributeName, "InvalidParameterValue");
                        }
                    }
                    ++i;
                }
            }
        }
    }

    public boolean validate() throws ExceptionReport {
        if (!this.execDom.getExecute().getVersion().equals("1.0.0")) {
            throw new ExceptionReport("Specified version is not supported.", "InvalidParameterValue", "version=" + this.getExecute().getVersion());
        }
        String identifier = this.getAlgorithmIdentifier();
        if (identifier == null) {
            throw new ExceptionReport("No process identifier supplied.", "MissingParameterValue", "identifier");
        }
        if (!RepositoryManager.getInstance().containsAlgorithm(identifier)) {
            throw new ExceptionReport("Specified process identifier does not exist", "InvalidParameterValue", "identifier=" + identifier);
        }
        ProcessDescriptionType desc = RepositoryManager.getInstance().getProcessDescription(this.getAlgorithmIdentifier());
        if (desc == null) {
            LOGGER.warn("desc == null");
            return false;
        }
        if (desc.getDataInputs() != null) {
            InputDescriptionType[] inputDescs = desc.getDataInputs().getInputArray();
            InputType[] inputs = this.getExecute().getDataInputs() == null ? new InputType[]{} : this.getExecute().getDataInputs().getInputArray();
            InputType[] inputTypeArray = inputs;
            int n = inputs.length;
            int n2 = 0;
            while (n2 < n) {
                InputType input = inputTypeArray[n2];
                boolean identifierMatched = false;
                InputDescriptionType[] inputDescriptionTypeArray = inputDescs;
                int n3 = inputDescs.length;
                int n4 = 0;
                while (n4 < n3) {
                    InputDescriptionType inputDesc = inputDescriptionTypeArray[n4];
                    if (inputDesc.getIdentifier().getStringValue().equals(input.getIdentifier().getStringValue())) {
                        identifierMatched = true;
                        if (input.getData() == null || input.getData().getLiteralData() == null) break;
                        if (inputDesc.getLiteralData() == null) {
                            throw new ExceptionReport("Inputtype LiteralData is not supported", "InvalidParameterValue");
                        }
                        if (input.getData().getLiteralData().getDataType() == null || inputDesc.getLiteralData() == null || inputDesc.getLiteralData().getDataType() == null || inputDesc.getLiteralData().getDataType().getReference() == null || input.getData().getLiteralData().getDataType().equals(inputDesc.getLiteralData().getDataType().getReference())) break;
                        throw new ExceptionReport("Specified dataType is not supported " + input.getData().getLiteralData().getDataType() + " for input " + input.getIdentifier().getStringValue(), "InvalidParameterValue");
                    }
                    ++n4;
                }
                if (!identifierMatched) {
                    throw new ExceptionReport("Input Identifier is not valid: " + input.getIdentifier().getStringValue(), "InvalidParameterValue", "input identifier");
                }
                ++n2;
            }
        }
        return true;
    }

    /*
     * Unable to fully structure code
     */
    public Response call() throws ExceptionReport {
        block20: {
            algorithm = null;
            inputMap = null;
            try {
                try {
                    context = this.getExecute().isSetResponseForm() != false ? (this.getExecute().getResponseForm().isSetRawDataOutput() != false ? new ExecutionContext(this.getExecute().getResponseForm().getRawDataOutput()) : new ExecutionContext(Arrays.asList(this.getExecute().getResponseForm().getResponseDocument().getOutputArray()))) : new ExecutionContext();
                    ExecutionContextFactory.registerContext((ExecutionContext)context);
                    ExecuteRequest.LOGGER.debug("started with execution");
                    this.updateStatusStarted();
                    inputs = new InputType[]{};
                    if (this.getExecute().getDataInputs() != null) {
                        inputs = this.getExecute().getDataInputs().getInputArray();
                    }
                    parser = new InputHandler.Builder(inputs, this.getAlgorithmIdentifier()).build();
                    algorithm = RepositoryManager.getInstance().getAlgorithm(this.getAlgorithmIdentifier());
                    if (algorithm instanceof ISubject) {
                        subject = (ISubject)algorithm;
                        subject.addObserver((IObserver)this);
                    }
                    if (algorithm instanceof AbstractTransactionalAlgorithm) {
                        this.returnResults = ((AbstractTransactionalAlgorithm)algorithm).run(this.execDom);
                    } else {
                        inputMap = parser.getParsedInputData();
                        this.returnResults = algorithm.run(inputMap);
                    }
                    errorList = algorithm.getErrors();
                    if (errorList != null && !errorList.isEmpty()) {
                        errorMessage = (String)errorList.get(0);
                        ExecuteRequest.LOGGER.error("Error reported while handling ExecuteRequest for " + this.getAlgorithmIdentifier() + ": " + errorMessage);
                        this.updateStatusError(errorMessage);
                    }
                    this.updateStatusSuccess();
                }
                catch (Throwable e) {
                    errorMessage = null;
                    if (algorithm != null && algorithm.getErrors() != null && !algorithm.getErrors().isEmpty()) {
                        errorMessage = (String)algorithm.getErrors().get(0);
                    }
                    if (errorMessage == null) {
                        errorMessage = e.toString();
                    }
                    if (errorMessage == null) {
                        errorMessage = "UNKNOWN ERROR";
                    }
                    ExecuteRequest.LOGGER.error("Exception/Error while executing ExecuteRequest for " + this.getAlgorithmIdentifier() + ": " + errorMessage);
                    this.updateStatusError(errorMessage);
                    if (e instanceof Error) {
                        throw (Error)e;
                    }
                    if (e instanceof ExceptionReport) {
                        throw (ExceptionReport)e;
                    }
                    throw new ExceptionReport("Error while executing the embedded process for: " + this.getAlgorithmIdentifier(), "NoApplicableCode", e);
                }
            }
            finally {
                ExecutionContextFactory.unregisterContext();
                if (algorithm instanceof ISubject) {
                    ((ISubject)algorithm).removeObserver((IObserver)this);
                }
                if (inputMap == null) break block20;
                ** for (l : inputMap.values())
            }
lbl-1000:
            // 3 sources

            {
                for (IData d : l) {
                    if (!(d instanceof IComplexData)) continue;
                    ((IComplexData)d).dispose();
                }
                continue;
            }
        }
        if (this.returnResults != null) {
            for (IData d : this.returnResults.values()) {
                if (!(d instanceof IComplexData)) continue;
                ((IComplexData)d).dispose();
            }
        }
        response = new ExecuteResponse(this);
        return response;
    }

    public String getAlgorithmIdentifier() {
        if (this.getExecute().getIdentifier() != null) {
            return this.getExecute().getIdentifier().getStringValue();
        }
        return null;
    }

    public ExecuteDocument.Execute getExecute() {
        return this.execDom.getExecute();
    }

    public Map<String, IData> getAttachedResult() {
        return this.returnResults;
    }

    public boolean isStoreResponse() {
        if (this.execDom.getExecute().getResponseForm() == null) {
            return false;
        }
        if (this.execDom.getExecute().getResponseForm().getRawDataOutput() != null) {
            return false;
        }
        return this.execDom.getExecute().getResponseForm().getResponseDocument().getStoreExecuteResponse();
    }

    public boolean isQuickStatus() {
        if (this.execDom.getExecute().getResponseForm() == null) {
            return false;
        }
        if (this.execDom.getExecute().getResponseForm().getRawDataOutput() != null) {
            return false;
        }
        return this.execDom.getExecute().getResponseForm().getResponseDocument().getStatus();
    }

    public ExecuteResponseBuilder getExecuteResponseBuilder() {
        return this.execRespType;
    }

    public boolean isRawData() {
        if (this.execDom.getExecute().getResponseForm() == null) {
            return false;
        }
        return this.execDom.getExecute().getResponseForm().getRawDataOutput() != null;
    }

    public void update(ISubject subject) {
        Object state = subject.getState();
        LOGGER.info("Update received from Subject, state changed to : " + state);
        StatusType status = StatusType.Factory.newInstance();
        int percentage = 0;
        if (state instanceof Integer) {
            percentage = (Integer)state;
            status.addNewProcessStarted().setPercentCompleted(percentage);
        } else if (state instanceof String) {
            status.addNewProcessStarted().setStringValue((String)state);
        }
        this.updateStatus(status);
    }

    public void updateStatusAccepted() {
        StatusType status = StatusType.Factory.newInstance();
        status.setProcessAccepted("Process Accepted");
        this.updateStatus(status);
    }

    public void updateStatusStarted() {
        StatusType status = StatusType.Factory.newInstance();
        status.addNewProcessStarted().setPercentCompleted(0);
        this.updateStatus(status);
    }

    public void updateStatusSuccess() {
        StatusType status = StatusType.Factory.newInstance();
        status.setProcessSucceeded("Process successful");
        this.updateStatus(status);
    }

    public void updateStatusError(String errorMessage) {
        StatusType status = StatusType.Factory.newInstance();
        ExceptionReportDocument.ExceptionReport excRep = status.addNewProcessFailed().addNewExceptionReport();
        excRep.setVersion("1.0.0");
        ExceptionType excType = excRep.addNewException();
        excType.addNewExceptionText().setStringValue(errorMessage);
        excType.setExceptionCode("NoApplicableCode");
        this.updateStatus(status);
    }

    private void updateStatus(StatusType status) {
        block5: {
            this.getExecuteResponseBuilder().setStatus(status);
            try {
                this.getExecuteResponseBuilder().update();
                if (!this.isStoreResponse()) break block5;
                ExecuteResponse executeResponse = new ExecuteResponse(this);
                InputStream is = null;
                try {
                    is = executeResponse.getAsStream();
                    DatabaseFactory.getDatabase().storeResponse(this.getUniqueId().toString(), is);
                }
                finally {
                    IOUtils.closeQuietly((InputStream)is);
                }
            }
            catch (ExceptionReport e) {
                LOGGER.error("Update of process status failed.", (Throwable)e);
                throw new RuntimeException(e);
            }
        }
    }

    private void storeRequest(ExecuteDocument executeDocument) {
        InputStream is = null;
        try {
            try {
                is = executeDocument.newInputStream();
                DatabaseFactory.getDatabase().insertRequest(this.getUniqueId().toString(), is, true);
            }
            catch (Exception e) {
                LOGGER.error("Exception storing ExecuteRequest", (Throwable)e);
                IOUtils.closeQuietly((InputStream)is);
            }
        }
        finally {
            IOUtils.closeQuietly((InputStream)is);
        }
    }

    private void storeRequest(CaseInsensitiveMap map) {
        block6: {
            BufferedWriter w = null;
            ByteArrayOutputStream os = null;
            ByteArrayInputStream is = null;
            try {
                try {
                    os = new ByteArrayOutputStream();
                    w = new BufferedWriter(new OutputStreamWriter(os));
                    for (Object key : map.keySet()) {
                        Object value = map.get(key);
                        String valueString = "";
                        valueString = value instanceof String[] ? ((String[])value)[0] : value.toString();
                        w.append(key.toString()).append('=').append(valueString);
                        w.newLine();
                    }
                    w.flush();
                    is = new ByteArrayInputStream(os.toByteArray());
                    DatabaseFactory.getDatabase().insertRequest(this.getUniqueId().toString(), (InputStream)is, false);
                }
                catch (Exception e) {
                    LOGGER.error("Exception storing ExecuteRequest", (Throwable)e);
                    IOUtils.closeQuietly(w);
                    IOUtils.closeQuietly((OutputStream)os);
                    IOUtils.closeQuietly(is);
                    break block6;
                }
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(w);
                IOUtils.closeQuietly((OutputStream)os);
                IOUtils.closeQuietly(is);
                throw throwable;
            }
            IOUtils.closeQuietly((Writer)w);
            IOUtils.closeQuietly((OutputStream)os);
            IOUtils.closeQuietly((InputStream)is);
        }
    }
}

