/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataanalysis.dataminer.poolmanager.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.util.EntityUtils;
import org.gcube.common.authorization.client.Constants;
import org.gcube.common.authorization.client.exceptions.ObjectNotFound;
import org.gcube.common.authorization.library.AuthorizationEntry;
import org.gcube.common.authorization.library.provider.SecurityTokenProvider;
import org.gcube.common.encryption.encrypter.StringEncrypter;
import org.gcube.common.resources.gcore.GCoreEndpoint;
import org.gcube.common.resources.gcore.ServiceEndpoint;
import org.gcube.common.resources.gcore.utils.Group;
import org.gcube.dataanalysis.dataminer.poolmanager.clients.configuration.DMPMClientConfiguratorManager;
import org.gcube.dataanalysis.dataminer.poolmanager.util.exception.EMailException;
import org.gcube.resources.discovery.client.api.DiscoveryClient;
import org.gcube.resources.discovery.client.queries.api.Query;
import org.gcube.resources.discovery.client.queries.impl.XQuery;
import org.gcube.resources.discovery.icclient.ICFactory;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SendMail {
    private static final Logger logger = LoggerFactory.getLogger(SendMail.class);
    private static final String WRITE_MESSAGE_ADDRESS_PATH = "2/messages/write-message?gcube-token=";
    private static final String USER_ROLES_ADDRESS_PATH = "2/users/get-usernames-by-role?role-name=DataMiner-Manager&gcube-token=";
    private static final String SOCIAL_SERVICE_QUERY_CONDITION = "$resource/Profile/ServiceName/text() eq 'SocialNetworking'";
    private static final String SOCIAL_SERVICE_URI = "jersey-servlet";
    private static final String JSON_MIME_TYPE = "application/json";
    private static final String DMPOOLMANAGER_SERVICE_QUERY_CONDITION = "$resource/Profile/Name/text() eq 'DMPoolManager'";
    private String socialServiceAddress;
    private String applicationToken;

    public void sendNotification(String subject, String body) throws EMailException {
        logger.debug("SendNotification");
        logger.debug("Notification Subject: " + subject);
        logger.debug("Notification Body: " + body);
        this.applicationToken = this.retrieveApplicationToken();
        this.retrieveSocialService();
        String postBody = this.createPostBody(subject, body);
        this.sendPostRequest(postBody);
    }

    private String createPostBody(String subject, String body) throws EMailException {
        try {
            List recipientsList = this.getRecipients();
            if (recipientsList == null || recipientsList.isEmpty()) {
                logger.error("Invalid recipient list: " + recipientsList);
                throw new EMailException("Unable to send email notification. Invalid recipient list:" + recipientsList);
            }
            JSONObject data = new JSONObject();
            data.put("subject", (Object)subject);
            data.put("body", (Object)body);
            JSONArray recipients = new JSONArray();
            for (String recipient : recipientsList) {
                JSONObject d = new JSONObject();
                d.put("id", (Object)recipient);
                recipients.put((Object)d);
            }
            data.put("recipients", (Object)recipients);
            logger.debug("Post Body: " + data);
            return data.toString();
        }
        catch (EMailException e) {
            throw e;
        }
        catch (Throwable e) {
            logger.error("Error creating the notification body: " + e.getLocalizedMessage(), e);
            throw new EMailException(e);
        }
    }

    private String retrieveApplicationToken() throws EMailException {
        try {
            logger.info("Retrieve Application Token");
            XQuery query = ICFactory.queryFor(ServiceEndpoint.class);
            query.addCondition(DMPOOLMANAGER_SERVICE_QUERY_CONDITION);
            DiscoveryClient client = ICFactory.clientFor(ServiceEndpoint.class);
            List resources = client.submit((Query)query);
            if (resources.isEmpty()) {
                logger.error("No services resource found on IS!");
            } else {
                logger.debug("Retrieved: " + resources.get(0));
            }
            Group accessPoints = ((ServiceEndpoint)resources.get(0)).profile().accessPoints();
            if (!accessPoints.isEmpty()) {
                Iterator iterator = accessPoints.iterator();
                ServiceEndpoint.AccessPoint ap = (ServiceEndpoint.AccessPoint)iterator.next();
                Group props = ap.properties();
                if (!props.isEmpty()) {
                    Iterator iteratorProps = props.iterator();
                    ServiceEndpoint.Property p = (ServiceEndpoint.Property)iteratorProps.next();
                    String applicationToken = StringEncrypter.getEncrypter().decrypt(p.value());
                    logger.debug("Application token found: " + applicationToken);
                    logger.info("Application Token retrieved");
                    return applicationToken;
                }
                String error = "DMPoolManager application token not found in service resource on IS!";
                logger.error(error);
                throw new EMailException(error);
            }
            String error = "DMPoolManager invalid service resource on IS!";
            logger.error(error);
            throw new EMailException(error);
        }
        catch (Throwable e) {
            logger.error("DMPoolManager application token not found: " + e.getLocalizedMessage(), e);
            throw new EMailException("DMPoolManager application token not found: " + e.getLocalizedMessage(), e);
        }
    }

    private void retrieveSocialService() throws EMailException {
        try {
            XQuery query = ICFactory.queryFor(GCoreEndpoint.class);
            query.addCondition(SOCIAL_SERVICE_QUERY_CONDITION);
            DiscoveryClient client = ICFactory.clientFor(GCoreEndpoint.class);
            List resources = client.submit((Query)query);
            this.socialServiceAddress = ((GCoreEndpoint.Profile.Endpoint)((GCoreEndpoint)resources.get(0)).profile().endpointMap().get(SOCIAL_SERVICE_URI)).uri().toString();
            logger.info("Retrieved Social Service Address: " + this.socialServiceAddress);
            if (this.socialServiceAddress == null || this.socialServiceAddress.isEmpty()) {
                throw new EMailException("Unable to send email notification. Invalid address in GCoreEndpoint resource on IS.");
            }
        }
        catch (EMailException e) {
            logger.error(e.getLocalizedMessage(), (Throwable)e);
            throw e;
        }
        catch (Throwable e) {
            logger.error(e.getLocalizedMessage(), e);
            throw new EMailException(e);
        }
    }

    private String username(String token) throws ObjectNotFound, Exception {
        AuthorizationEntry entry = Constants.authorizationService().get(token);
        logger.debug(entry.getClientInfo().getId());
        return entry.getClientInfo().getId();
    }

    private void sendPostRequest(String postBody) throws EMailException {
        try {
            String line;
            logger.info("Execute Post Body:" + postBody);
            StringBuilder requestMessageBuilder = new StringBuilder(this.socialServiceAddress);
            if (!this.socialServiceAddress.endsWith("/")) {
                requestMessageBuilder.append('/');
            }
            requestMessageBuilder.append(WRITE_MESSAGE_ADDRESS_PATH);
            logger.info("Execute Post Request: " + requestMessageBuilder.toString());
            requestMessageBuilder.append(this.applicationToken);
            String endpoint = requestMessageBuilder.toString();
            URL url = new URL(endpoint);
            URLConnection conn = url.openConnection();
            conn.setRequestProperty("Accept", JSON_MIME_TYPE);
            conn.setRequestProperty("Content-Type", JSON_MIME_TYPE);
            conn.setDoOutput(true);
            OutputStreamWriter writer = new OutputStreamWriter(conn.getOutputStream());
            writer.write(postBody);
            writer.flush();
            StringBuffer answer = new StringBuffer();
            BufferedReader reader = new BufferedReader(new InputStreamReader(conn.getInputStream()));
            while ((line = reader.readLine()) != null) {
                answer.append(line);
            }
            writer.close();
            reader.close();
            logger.debug("Operation completed");
            String response = answer.toString();
            logger.info("Notification Response: " + response);
            this.checkResponse(response);
        }
        catch (EMailException e) {
            throw e;
        }
        catch (MalformedURLException e) {
            logger.error("Invalid URL: " + e.getLocalizedMessage(), (Throwable)e);
            throw new EMailException((Throwable)e);
        }
        catch (IOException e) {
            logger.error("Error in the IO process: " + e.getLocalizedMessage(), (Throwable)e);
            throw new EMailException((Throwable)e);
        }
        catch (Throwable e) {
            logger.error("Error executing post:" + e.getLocalizedMessage(), e);
            throw new EMailException(e);
        }
    }

    private void checkResponse(String response) throws EMailException {
        if (response == null) {
            logger.error("Invalid notification response: " + response);
            throw new EMailException();
        }
        try {
            JSONObject res = new JSONObject(response);
            boolean success = res.getBoolean("success");
            if (!success) {
                String message = res.getString("message");
                logger.error("Error in send email notification: " + message);
                throw new EMailException("Error in send email notification: " + message);
            }
        }
        catch (JSONException e) {
            logger.error("Invalid notification response: " + response);
            throw new EMailException((Throwable)e);
        }
    }

    private List<String> getRecipients() {
        try {
            ArrayList<String> recipients = new ArrayList<String>();
            String dataMinerManagers = this.retrieveDataMinerManagers();
            logger.debug("Retrieved DataMiner Managers: " + dataMinerManagers);
            if (dataMinerManagers != null && !dataMinerManagers.isEmpty()) {
                JSONObject obj = new JSONObject(dataMinerManagers);
                JSONArray data = obj.getJSONArray("result");
                if (data != null) {
                    for (int i = 0; i < data.length(); ++i) {
                        recipients.add(data.getString(i));
                    }
                }
            } else {
                logger.info("Use the default admins how workaround ");
                List defaultManagers = DMPMClientConfiguratorManager.getInstance().getDefaultAdmins();
                recipients.addAll(defaultManagers);
            }
            recipients.add(this.username(SecurityTokenProvider.instance.get()));
            logger.info("Retrieved Recipients: " + recipients);
            return recipients;
        }
        catch (Exception e) {
            logger.error("Error retrieving recipients: " + e.getLocalizedMessage(), (Throwable)e);
            logger.info("Use the default admins how workaround ");
            return DMPMClientConfiguratorManager.getInstance().getDefaultAdmins();
        }
    }

    private String retrieveDataMinerManagers() throws Exception {
        StringBuilder requestMessageBuilder = new StringBuilder(this.socialServiceAddress);
        if (!this.socialServiceAddress.endsWith("/")) {
            requestMessageBuilder.append('/');
        }
        requestMessageBuilder.append(USER_ROLES_ADDRESS_PATH);
        logger.info("Request Admins Url: " + requestMessageBuilder.toString());
        requestMessageBuilder.append(this.applicationToken);
        String requestAdminsUrl = requestMessageBuilder.toString();
        CloseableHttpClient client = HttpClientBuilder.create().build();
        HttpGet getReq = new HttpGet(requestAdminsUrl);
        getReq.setHeader("accept", JSON_MIME_TYPE);
        getReq.setHeader("content-type", JSON_MIME_TYPE);
        logger.info("Response: " + EntityUtils.toString((HttpEntity)client.execute((HttpUriRequest)getReq).getEntity()));
        return EntityUtils.toString((HttpEntity)client.execute((HttpUriRequest)getReq).getEntity());
    }
}

