/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataanalysis.dataminer.poolmanager.ansible;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import org.gcube.dataanalysis.dataminer.poolmanager.ansible.model.Inventory;
import org.gcube.dataanalysis.dataminer.poolmanager.ansible.model.Playbook;
import org.gcube.dataanalysis.dataminer.poolmanager.ansible.model.Role;
import org.gcube.dataanalysis.dataminer.poolmanager.ansiblebridge.AnsibleSerializeHelper;

/*
 * Exception performing whole class analysis ignored.
 */
public class AnsibleWorker {
    private static String INVENTORY_NAME = "inventory.yaml";
    private static String ROLES_DIR = "roles";
    private static String PLAYBOOK_NAME = "playbook.yaml";
    private File workerRoot;

    public AnsibleWorker(File root) {
        this.workerRoot = root;
        this.ensureWorkStructure();
    }

    public File getWorkdir() {
        return this.workerRoot;
    }

    public File getRolesDir() {
        return new File(this.getWorkdir(), ROLES_DIR);
    }

    public String getWorkerId() {
        return this.workerRoot.getName();
    }

    public void ensureWorkStructure() {
        this.getWorkdir().mkdirs();
    }

    public void removeWorkStructure() {
        this.getWorkdir().delete();
    }

    public File getPlaybookFile() {
        return new File(this.getWorkdir(), PLAYBOOK_NAME);
    }

    public File getInventoryFile() {
        return new File(this.getWorkdir(), INVENTORY_NAME);
    }

    public void setInventory(Inventory inventory) throws IOException {
        AnsibleSerializeHelper.serialize((Inventory)inventory, (File)this.getInventoryFile());
    }

    public void setPlaybook(Playbook playbook) throws IOException {
        AnsibleSerializeHelper.serialize((Playbook)playbook, (File)this.getPlaybookFile());
    }

    public void addRole(Role r) throws IOException {
        AnsibleSerializeHelper.serializeRole((Role)r, (File)this.getRolesDir());
    }

    public void apply(PrintStream ps) throws IOException {
        System.out.println(this.getWorkdir());
        try {
            Process p = Runtime.getRuntime().exec("ansible-playbook -v -i " + this.getInventoryFile().getAbsolutePath() + " " + this.getPlaybookFile().getAbsolutePath());
            AnsibleWorker.inheritIO((InputStream)p.getInputStream(), (PrintStream)ps);
            AnsibleWorker.inheritIO((InputStream)p.getErrorStream(), (PrintStream)ps);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static void inheritIO(InputStream src, PrintStream dest) {
        new Thread((Runnable)new /* Unavailable Anonymous Inner Class!! */).start();
    }

    public void destroy() {
        this.removeWorkStructure();
    }
}

