/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataanalysis.copernicus.cmems.importer.service.rest.task;

import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.gcube.dataanalysis.copernicus.cmems.importer.service.exception.AlreadyThereException;
import org.gcube.dataanalysis.copernicus.cmems.importer.service.exception.InvalidParameterException;
import org.gcube.dataanalysis.copernicus.cmems.importer.service.exception.MalformedElementException;
import org.gcube.dataanalysis.copernicus.cmems.importer.service.exception.NotThereException;
import org.gcube.dataanalysis.copernicus.cmems.importer.service.exception.StoreException;
import org.gcube.dataanalysis.copernicus.cmems.importer.service.rest.cmems.AbstractImporterResource;
import org.gcube.dataanalysis.copernicus.cmems.importer.service.rest.task.ExecutionResource;
import org.gcube.dataanalysis.copernicus.cmems.importer.service.rest.task.ReportResource;
import org.gcube.dataanalysis.copernicus.cmems.importer.service.service.TaskStore;
import org.gcube.dataanalysis.copernicus.cmems.importer.task.Execution;
import org.gcube.dataanalysis.copernicus.cmems.importer.task.ExecutionReport;

public class ExecutionResource
extends AbstractImporterResource {
    private String taskId;
    private String executionId;

    public ExecutionResource(String taskId, String executionId) {
        this.taskId = taskId;
        try {
            this.executionId = "last".equals(executionId) ? new TaskStore().getLastExecutionId(taskId) : executionId;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @GET
    public Response getExecution() {
        try {
            Execution execution = new TaskStore().getExecution(this.taskId, this.executionId);
            return Response.ok().entity((Object)execution).build();
        }
        catch (InvalidParameterException | MalformedElementException | StoreException e) {
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
        catch (NotThereException e) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
    }

    @GET
    @Path(value="reports")
    public Response getReports() {
        try {
            List reports = new TaskStore().getReports(this.taskId, this.executionId);
            1 out = new /* Unavailable Anonymous Inner Class!! */;
            return Response.ok((Object)out).build();
        }
        catch (InvalidParameterException | MalformedElementException e) {
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
        catch (NotThereException e) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
    }

    @Path(value="reports/{reportId}")
    public ReportResource getReport(@PathParam(value="reportId") String reportId) {
        return new ReportResource(this.taskId, this.executionId, reportId);
    }

    @POST
    @Path(value="reports")
    @Produces(value={"application/xml"})
    @Consumes(value={"application/xml"})
    public Response addReport(ExecutionReport report) {
        try {
            ExecutionReport out = new TaskStore().addReport(this.taskId, this.executionId, report);
            return Response.ok().entity((Object)out).build();
        }
        catch (InvalidParameterException | MalformedElementException | StoreException e) {
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
        catch (NotThereException e) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        catch (AlreadyThereException e) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
    }

    @PUT
    @Produces(value={"application/xml"})
    @Consumes(value={"application/xml"})
    public Response update(Execution execution) {
        try {
            execution.setId(this.executionId);
            Execution out = new TaskStore().update(this.taskId, execution);
            return Response.ok().entity((Object)out).build();
        }
        catch (InvalidParameterException | MalformedElementException | StoreException e) {
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
        catch (NotThereException e) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
    }
}

