/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataanalysis.copernicus.cmems.importer.service.rest.cmems;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.gcube.dataanalysis.copernicus.cmems.client.SearchOptions;
import org.gcube.dataanalysis.copernicus.cmems.importer.service.exception.InvalidParameterException;
import org.gcube.dataanalysis.copernicus.cmems.importer.service.rest.cmems.AbstractImporterResource;
import org.gcube.dataanalysis.copernicus.cmems.importer.service.rest.cmems.CmemsResource;
import org.gcube.dataanalysis.copernicus.cmems.importer.service.rest.cmems.ProductResource;
import org.gcube.dataanalysis.copernicus.cmems.importer.service.service.DatasetBrowser;
import org.gcube.dataanalysis.copernicus.cmems.importer.service.util.ParamUtils;
import org.gcube.dataanalysis.datasetimporter.util.TimeUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/cmems")
public class CmemsResource
extends AbstractImporterResource {
    private static Logger logger = LoggerFactory.getLogger(CmemsResource.class);

    @GET
    @Path(value="products")
    @Produces(value={"application/xml"})
    public Response getProducts(@Context UriInfo uriInfo) {
        MultivaluedMap queryParams = null;
        if (uriInfo != null) {
            queryParams = uriInfo.getQueryParameters();
        }
        SearchOptions options = null;
        try {
            options = ParamUtils.queryParamsToSearchOptions((MultivaluedMap)queryParams);
        }
        catch (InvalidParameterException e) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        try {
            Collection products = new DatasetBrowser().searchProducts(options);
            1 entity = new /* Unavailable Anonymous Inner Class!! */;
            return Response.ok((Object)entity).build();
        }
        catch (Exception e) {
            logger.error(e.toString());
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    @GET
    @Path(value="motu")
    @Produces(value={"application/xml"})
    public Response getMotus() {
        try {
            ArrayList motus = new ArrayList(new DatasetBrowser().getMotuServers());
            2 entity = new /* Unavailable Anonymous Inner Class!! */;
            Response response = Response.ok((Object)entity).build();
            return response;
        }
        catch (Exception e) {
            logger.error(e.getMessage());
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    @GET
    @Path(value="regions")
    @Produces(value={"application/xml"})
    public Response getRegions() {
        try {
            ArrayList regions = new ArrayList(new DatasetBrowser().getRegionalDomains());
            3 entity = new /* Unavailable Anonymous Inner Class!! */;
            Response response = Response.ok((Object)entity).build();
            return response;
        }
        catch (Exception e) {
            logger.error(e.getMessage());
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    @GET
    @Path(value="keywords")
    @Produces(value={"application/xml"})
    public Response getKeywords() {
        try {
            ArrayList keywords = new ArrayList(new DatasetBrowser().getKeywords());
            4 entity = new /* Unavailable Anonymous Inner Class!! */;
            Response response = Response.ok((Object)entity).build();
            return response;
        }
        catch (Exception e) {
            logger.error(e.getMessage());
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    @GET
    @Path(value="variables")
    @Produces(value={"application/xml"})
    public Response getVariables() {
        try {
            ArrayList variables = new ArrayList(new DatasetBrowser().getOceanKeys());
            5 entity = new /* Unavailable Anonymous Inner Class!! */;
            Response response = Response.ok((Object)entity).build();
            return response;
        }
        catch (Exception e) {
            logger.error(e.toString());
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    @Path(value="minTime")
    @GET
    public Response getMinTime() {
        try {
            String time = TimeUtil.toString((Calendar)new DatasetBrowser().getMinTime());
            Response response = Response.ok((Object)time).build();
            return response;
        }
        catch (Exception e) {
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    @Path(value="maxTime")
    @GET
    public Response getMaxTime() {
        try {
            String time = TimeUtil.toString((Calendar)new DatasetBrowser().getMaxTime());
            Response response = Response.ok((Object)time).build();
            return response;
        }
        catch (Exception e) {
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    @Path(value="products/{productId}")
    public ProductResource getProduct(@PathParam(value="productId") String productId) {
        return new ProductResource(productId);
    }

    @GET
    @Path(value="test")
    public String test() {
        return "Hello world!";
    }
}

