/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataanalysis.copernicus.cmems.importer.service.util;

import java.text.ParseException;
import java.util.Calendar;
import java.util.List;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.UriInfo;
import org.gcube.dataanalysis.copernicus.cmems.client.SearchOptions;
import org.gcube.dataanalysis.copernicus.cmems.importer.api.ChunkTimespan;
import org.gcube.dataanalysis.copernicus.cmems.importer.api.ImportOptions;
import org.gcube.dataanalysis.copernicus.cmems.importer.service.exception.InvalidParameterException;
import org.gcube.dataanalysis.copernicus.motu.client.DownloadRequest;
import org.gcube.dataanalysis.datasetimporter.util.TimeUtil;

/*
 * Exception performing whole class analysis ignored.
 */
public class ParamUtils {
    public static Integer getIntegerParameter(MultivaluedMap<String, String> queryParams, String parName) throws InvalidParameterException {
        String par = (String)queryParams.getFirst((Object)parName);
        if (par != null) {
            try {
                Integer out = Integer.parseInt(par);
                return out;
            }
            catch (NumberFormatException e) {
                throw new InvalidParameterException(parName, String.format("bad value '%s' for Integer parameter '%s'", par, parName));
            }
        }
        return null;
    }

    public static Boolean getBoooleanParameter(MultivaluedMap<String, String> queryParams, String parName) throws InvalidParameterException {
        String par = (String)queryParams.getFirst((Object)parName);
        if (par != null) {
            if (par != null) {
                if ("true".equalsIgnoreCase(par.trim())) {
                    return Boolean.TRUE;
                }
                if ("false".equalsIgnoreCase(par.trim())) {
                    return Boolean.FALSE;
                }
            }
            throw new InvalidParameterException(parName, String.format("bad value '%s' for Boolean parameter '%s'", par, parName));
        }
        return null;
    }

    public static Double getDoubleParameter(MultivaluedMap<String, String> queryParams, String parName) throws InvalidParameterException {
        String par = (String)queryParams.getFirst((Object)parName);
        if (par != null) {
            try {
                Double out = Double.parseDouble(par);
                return out;
            }
            catch (NumberFormatException e) {
                throw new InvalidParameterException(parName, String.format("bad value '%s' for Double parameter '%s'", par, parName));
            }
        }
        return null;
    }

    public static Calendar getCalendarParameter(MultivaluedMap<String, String> queryParams, String parName) throws InvalidParameterException {
        String par = (String)queryParams.getFirst((Object)parName);
        if (par != null) {
            try {
                Calendar out = TimeUtil.toCalendar((String)par);
                return out;
            }
            catch (ParseException e) {
                throw new InvalidParameterException(parName, String.format("bad value '%s' for Calendar parameter '%s'", par, parName));
            }
        }
        return null;
    }

    public static ImportOptions queryParamsToImportOptions(UriInfo uriInfo) throws InvalidParameterException {
        MultivaluedMap queryParams = uriInfo.getQueryParameters();
        return ParamUtils.queryParamsToImportOptions((MultivaluedMap)queryParams);
    }

    public static ImportOptions queryParamsToImportOptions(MultivaluedMap<String, String> queryParams) throws InvalidParameterException {
        List variables;
        Double zhi;
        Double zlo;
        Double yhi;
        Double ylo;
        Double xhi;
        Double xlo;
        Calendar thi;
        String par;
        ImportOptions options = new ImportOptions();
        Integer backTime = ParamUtils.getIntegerParameter(queryParams, (String)"b");
        if (backTime != null) {
            options.setBackTime(backTime);
        }
        if ((par = (String)queryParams.getFirst((Object)"s")) != null) {
            try {
                options.setChunkSpan(ChunkTimespan.fromString((String)par));
            }
            catch (Exception e) {
                throw new InvalidParameterException("s", String.format("bad value '%s' for String parameter '%s'", par, "s"));
            }
        }
        par = (String)queryParams.getFirst((Object)"m");
        options.setMotu(par);
        par = (String)queryParams.getFirst((Object)"p");
        options.setProduct(par);
        par = (String)queryParams.getFirst((Object)"d");
        options.setDataset(par);
        par = (String)queryParams.getFirst((Object)"f");
        options.setImportSchedule(par);
        Calendar tlo = ParamUtils.getCalendarParameter(queryParams, (String)"tlo");
        if (tlo != null) {
            options.settLo(tlo);
        }
        if ((thi = ParamUtils.getCalendarParameter(queryParams, (String)"thi")) != null) {
            options.settHi(thi);
        }
        if ((xlo = ParamUtils.getDoubleParameter(queryParams, (String)"xlo")) != null) {
            options.setxLo(xlo);
        }
        if ((xhi = ParamUtils.getDoubleParameter(queryParams, (String)"xhi")) != null) {
            options.setxHi(xhi);
        }
        if ((ylo = ParamUtils.getDoubleParameter(queryParams, (String)"ylo")) != null) {
            options.setyLo(ylo);
        }
        if ((yhi = ParamUtils.getDoubleParameter(queryParams, (String)"yhi")) != null) {
            options.setyHi(yhi);
        }
        if ((zlo = ParamUtils.getDoubleParameter(queryParams, (String)"zlo")) != null) {
            options.setzLo(zlo);
        }
        if ((zhi = ParamUtils.getDoubleParameter(queryParams, (String)"zhi")) != null) {
            options.setzHi(zhi);
        }
        if ((variables = (List)queryParams.get((Object)"v")) != null) {
            for (String v : variables) {
                options.addVariable(v);
            }
        }
        return options;
    }

    public static SearchOptions queryParamsToSearchOptions(UriInfo uriInfo) throws InvalidParameterException {
        MultivaluedMap queryParams = uriInfo.getQueryParameters();
        return ParamUtils.queryParamsToSearchOptions((MultivaluedMap)queryParams);
    }

    public static SearchOptions queryParamsToSearchOptions(MultivaluedMap<String, String> queryParams) throws InvalidParameterException {
        Boolean whole;
        Calendar to;
        Calendar from;
        List variables;
        Boolean ignoreCase;
        SearchOptions options = new SearchOptions();
        if (queryParams == null) {
            return options;
        }
        List keys = (List)queryParams.get((Object)"k");
        if (keys != null) {
            for (String k : keys) {
                options.addMatchedKey(k);
            }
        }
        if ((keys = (List)queryParams.get((Object)"u")) != null) {
            for (String k : keys) {
                options.addUnMatchedKey(k);
            }
        }
        if ((ignoreCase = ParamUtils.getBoooleanParameter(queryParams, (String)"i")) != null) {
            options.setIgnoreCase(ignoreCase.booleanValue());
        }
        if ((variables = (List)queryParams.get((Object)"v")) != null) {
            for (String v : variables) {
                options.addVariable(v);
            }
        }
        if ((from = ParamUtils.getCalendarParameter(queryParams, (String)"f")) != null) {
            options.setFrom(from);
        }
        if ((to = ParamUtils.getCalendarParameter(queryParams, (String)"t")) != null) {
            options.setTo(to);
        }
        if ((whole = ParamUtils.getBoooleanParameter(queryParams, (String)"w")) != null) {
            options.setWholeTimeRange(whole);
        }
        return options;
    }

    public static DownloadRequest importOptionsToDownloadRequest(ImportOptions options) {
        DownloadRequest req = new DownloadRequest();
        req.setService(options.getProduct() + "-TDS");
        req.setProduct(options.getDataset());
        req.setVariables(options.getVariables());
        req.settLo(options.gettLo());
        req.settHi(options.gettHi());
        req.setxLo(options.getxLo());
        req.setxHi(options.getxHi());
        req.setyLo(options.getyLo());
        req.setyHi(options.getyHi());
        req.setzLo(options.getzLo());
        req.setzHi(options.getzHi());
        return req;
    }
}

