/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataanalysis.copernicus.cmems.importer.seplugin;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Calendar;
import org.gcube.dataanalysis.copernicus.cmems.importer.client.TaskManagerClient;
import org.gcube.dataanalysis.copernicus.cmems.importer.task.Execution;
import org.gcube.dataanalysis.copernicus.cmems.importer.task.ExecutionReport;
import org.gcube.dataanalysis.copernicus.cmems.importer.task.ExecutionStatus;
import org.gcube.dataanalysis.datasetimporter.util.ISClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExecutionTracker {
    private static Logger logger = LoggerFactory.getLogger(ExecutionTracker.class);
    private String taskId;
    private Execution execution;
    private TaskManagerClient client;

    public ExecutionTracker(String taskId, String executionId) {
        this.taskId = taskId;
        this.execution = new Execution();
        this.execution.setId(executionId);
    }

    public void checkTaskExists() throws Exception {
        try {
            this.getClient().getTask(this.taskId);
        }
        catch (Exception e) {
            throw new Exception("No such task: " + this.taskId);
        }
    }

    public void executionInit() {
        this.execution.setBegin(Calendar.getInstance());
        this.execution.setProgress(Double.valueOf(0.0));
        this.execution.setStatus(ExecutionStatus.CREATED);
        try {
            this.getClient().addExecution(this.taskId, this.execution);
        }
        catch (Exception e) {
            logger.error(e.toString());
            e.printStackTrace();
        }
    }

    public void executionProgress(int stepsCompleted, int stepsTotal) {
        Double progress = (double)stepsCompleted / (double)stepsTotal;
        BigDecimal bd = new BigDecimal(Double.toString(progress));
        bd = bd.setScale(3, RoundingMode.HALF_UP);
        progress = bd.doubleValue();
        this.execution.setProgress(progress);
        this.execution.setStatus(ExecutionStatus.RUNNING);
        try {
            this.getClient().updateExecution(this.taskId, this.execution);
        }
        catch (Exception e) {
            logger.error(e.toString());
            e.printStackTrace();
        }
    }

    public void executionComplete() {
        this.execution.setProgress(Double.valueOf(1.0));
        this.execution.setStatus(ExecutionStatus.DONE);
        this.execution.setEnd(Calendar.getInstance());
        try {
            this.getClient().updateExecution(this.taskId, this.execution);
        }
        catch (Exception e) {
            logger.error(e.toString());
            e.printStackTrace();
        }
    }

    public void executionError() {
        this.execution.setStatus(ExecutionStatus.FAILED);
        this.execution.setEnd(Calendar.getInstance());
        try {
            this.getClient().updateExecution(this.taskId, this.execution);
        }
        catch (Exception e) {
            logger.error(e.toString());
            e.printStackTrace();
        }
    }

    public void executionReport(ExecutionReport report) {
        try {
            this.getClient().addReport(this.taskId, this.execution.getId(), report);
        }
        catch (Exception e) {
            logger.error(e.toString());
            e.printStackTrace();
        }
    }

    private TaskManagerClient getClient() throws MalformedURLException {
        if (this.client == null) {
            this.client = this.buildTaskManagerClient();
        }
        return this.client;
    }

    private TaskManagerClient buildTaskManagerClient() throws MalformedURLException {
        URL endpoint = new ISClient().getCmemsImporterEndpoint();
        endpoint = new URL(endpoint, "cmems-importer-service/api");
        logger.info("using task tracker at " + endpoint);
        TaskManagerClient client = new TaskManagerClient(endpoint);
        return client;
    }
}

