/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataanalysis.copernicus.cmems.importer.seplugin;

import java.io.File;
import java.net.URL;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import org.apache.commons.io.FileUtils;
import org.gcube.dataanalysis.copernicus.cmems.importer.api.ImportOptions;
import org.gcube.dataanalysis.copernicus.cmems.importer.seplugin.CmemsImporterPluginDeclaration;
import org.gcube.dataanalysis.copernicus.cmems.importer.seplugin.ExecutionTracker;
import org.gcube.dataanalysis.copernicus.cmems.importer.seplugin.thredds.ThreddsClient;
import org.gcube.dataanalysis.copernicus.cmems.importer.seplugin.thredds.ThreddsDataset;
import org.gcube.dataanalysis.copernicus.cmems.importer.seplugin.thredds.ThreddsDatasetChunk;
import org.gcube.dataanalysis.copernicus.cmems.importer.task.ExecutionReport;
import org.gcube.dataanalysis.copernicus.motu.client.DownloadRequest;
import org.gcube.dataanalysis.copernicus.motu.client.MotuClient;
import org.gcube.dataanalysis.datasetimporter.exception.ServiceUnreachableException;
import org.gcube.dataanalysis.datasetimporter.util.ConfigurationUtil;
import org.gcube.dataanalysis.datasetimporter.util.ISClient;
import org.gcube.vremanagement.executor.plugin.Plugin;
import org.gcube.vremanagement.executor.plugin.PluginDeclaration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public class CmemsImporterPlugin
extends Plugin<CmemsImporterPluginDeclaration> {
    private static Logger logger = LoggerFactory.getLogger(CmemsImporterPlugin.class);
    private static final String THREDDS_PERSISTENCY_ID = "thredds";
    private static final String THREDDS_CATALOG_PATH = "public/netcdf/CMEMS";
    private static final String DOWNLOAD_DIR = "/tmp";
    private static final String LOG_DIR = "/tmp/cmems/logs";
    private ExecutionTracker taskTracker;
    private static final String PUBLISHED_REPORT_NAME = "import.log";

    public CmemsImporterPlugin(CmemsImporterPluginDeclaration pluginDeclaration) throws Exception {
        super((PluginDeclaration)pluginDeclaration);
    }

    public void launch(Map<String, Object> inputs) throws Exception {
        String taskId = this.getUUID().toString();
        String executionId = Calendar.getInstance().getTimeInMillis() + "";
        MDC.put((String)"executionId", (String)(taskId + "-" + executionId));
        File logFile = new File("/tmp/cmems/logs/" + this.getUUID().toString() + "-" + executionId + ".log");
        ExecutionReport report = new ExecutionReport();
        report.setName(PUBLISHED_REPORT_NAME);
        this.taskTracker = new ExecutionTracker(taskId, executionId);
        ImportOptions options = this.getImportOptionsFromLaunchParameters(inputs);
        this.taskTracker.checkTaskExists();
        this.taskTracker.executionInit();
        this.taskTracker.executionProgress(0, 1);
        ThreddsClient thredds = this.buildThreddsClient();
        ThreddsDataset publishedDataset = null;
        if (thredds.containsDataset(options)) {
            publishedDataset = thredds.getDataset(options);
        } else {
            publishedDataset = new ThreddsDataset();
            publishedDataset.setOptions(options);
            logger.info("No data yet published for this imported dataset");
        }
        ThreddsDataset expectedDataset = new ThreddsDataset(options);
        Collection<ThreddsDatasetChunk> missingChunks = this.getMissingChunks(publishedDataset, expectedDataset);
        int totalSteps = 2 + missingChunks.size() * 3;
        int stepsCompleted = 2;
        if (missingChunks.size() == 0) {
            logger.info("The dataset on THREDDS is up-to-date. Nothing to do.");
        } else {
            MotuClient motuClient = this.buildMotuClient(options.getMotu());
            for (ThreddsDatasetChunk chunk : missingChunks) {
                DownloadRequest request = this.getRequestForMotu(options, chunk.getChunkStart(), chunk.getChunkEnd());
                File f = motuClient.downloadProduct(request, new File("/tmp/" + chunk.getFileName()));
                logger.debug("downloaded " + f.getAbsolutePath());
                this.taskTracker.executionProgress(stepsCompleted++, totalSteps);
                logger.info("uploading nc file to thredds");
                thredds.upload(f);
                this.taskTracker.executionProgress(stepsCompleted++, totalSteps);
                logger.debug("removing local file " + f.getAbsolutePath());
                f.delete();
                publishedDataset.addChunk(chunk);
                String ncml = publishedDataset.generateNCML();
                File ncmlFile = new File("/tmp/" + options.getHash() + ".ncml");
                FileUtils.writeStringToFile((File)ncmlFile, (String)ncml, (String)"UTF-8");
                logger.info("uploading ncml file to thredds");
                thredds.upload(ncmlFile);
                this.taskTracker.executionProgress(stepsCompleted++, totalSteps);
                logger.debug("removing " + ncmlFile.getAbsolutePath());
                ncmlFile.delete();
                logger.info("Uploading reports.");
                report.setText(FileUtils.readFileToString((File)logFile, (String)"UTF-8"));
                this.taskTracker.executionReport(report);
            }
        }
        logger.info("Uploading reports.");
        report.setText(FileUtils.readFileToString((File)logFile, (String)"UTF-8"));
        this.taskTracker.executionReport(report);
        logger.info("Remove logs locally");
        logFile.delete();
        this.taskTracker.executionComplete();
    }

    protected void onStop() throws Exception {
        logger.debug("onStop()");
        Thread.currentThread().interrupt();
    }

    private Collection<ThreddsDatasetChunk> getMissingChunks(ThreddsDataset published, ThreddsDataset expected) {
        Vector<ThreddsDatasetChunk> missingChunks = new Vector();
        if (published == null || published.size() == 0) {
            logger.debug("Adding all chunks");
            missingChunks = expected.getChunks();
        } else {
            for (ThreddsDatasetChunk c : expected.getChunks()) {
                if (published.contains(c) && !c.needsUpdate()) continue;
                logger.debug("Adding chunk " + c.getFileName());
                missingChunks.add(c);
            }
        }
        return missingChunks;
    }

    private DownloadRequest getRequestForMotu(ImportOptions options, Calendar from, Calendar to) {
        DownloadRequest request = new DownloadRequest();
        request.setService(options.getProduct());
        request.setProduct(options.getDataset());
        request.setxRange(options.getxLo(), options.getxHi());
        request.setyRange(options.getyLo(), options.getyHi());
        request.setzRange(options.getzLo(), options.getzHi());
        request.settRange(from, to);
        request.setScriptVersion("1.4.00-20170410143941999");
        request.setMode("status");
        request.setOutput("netcdf");
        if (options.getVariables() != null) {
            for (String v : options.getVariables()) {
                request.addVariable(v);
            }
        }
        return request;
    }

    private ThreddsClient buildThreddsClient() throws ServiceUnreachableException {
        URL endpoint = new ISClient().getThreddsEndpoint();
        ThreddsClient client = new ThreddsClient(endpoint, THREDDS_PERSISTENCY_ID, THREDDS_CATALOG_PATH);
        client.checkThreddsIsReachable();
        return client;
    }

    private MotuClient buildMotuClient(String motu) throws Exception {
        ConfigurationUtil cu = new ConfigurationUtil();
        String userHome = System.getenv("HOME");
        cu.setLocalConfigurationFile(userHome + "/.cmems");
        MotuClient mc = new MotuClient(motu);
        mc.setUsername(cu.getProperty("CMEMS_USERNAME"));
        mc.setPassword(cu.getProperty("CMEMS_PASSWORD"));
        return mc;
    }

    private ImportOptions getImportOptionsFromLaunchParameters(Map<String, Object> inputs) throws ParseException {
        HashMap<String, String> map = new HashMap<String, String>();
        for (Map.Entry<String, Object> entry : inputs.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue().toString();
            map.put(key, value);
        }
        return new ImportOptions(map);
    }
}

