/**
 * 
 */
package org.gcube.dataanalysis.copernicus.cmems.importer.task;

import java.util.Calendar;
import java.util.Collection;

import javax.xml.bind.annotation.XmlRootElement;

import org.apache.commons.lang.builder.ToStringBuilder;

/**
 * This class models the execution of a task.
 * 
 * @author Paolo Fabriani
 *
 */
@XmlRootElement
public class Execution {

    /**
     * The start of the execution
     */
    private Calendar begin;
    
    /**
     * The end of the execution
     */
    private Calendar end;
    
    /**
     * When the execution was last updated.
     */
    private Calendar lastUpdate;
    
    /**
     * The status of the execution
     */
    private ExecutionStatus status;
    
    /**
     * The progress of the execution (between 0 and 1)
     */
    private Double progress;
    
    /**
     * The execution id.
     */
    private String id;
    
    /**
     * 
     * @return
     */
    private Collection<ExecutionReport> reports;

    public Execution() {
        this.status=ExecutionStatus.CREATED;
    }
    
    public Calendar getBegin() {
        return begin;
    }

    public void setBegin(Calendar begin) {
        this.begin = begin;
    }

    public Calendar getEnd() {
        return end;
    }

    public void setEnd(Calendar end) {
        this.end = end;
    }

    public ExecutionStatus getStatus() {
        return this.status;
//        int aliveTimeout = 5; // minutes
//        int probablyDeadTimeout = 20; // minutes
//        if(!this.isFinished()) {
//            Long silenceTime = this.getNotUpdatedFor();
//            if(silenceTime > probablyDeadTimeout) {
//                return this.status + " (probably dead)";
//            } else if(silenceTime > aliveTimeout) {
//                return this.status + " (not responding)";
//            } else
//                return this.status;
//        } else {
//            return status;
//        }
    }

    private boolean isFinished() {
        if(ExecutionStatus.DONE.equals(this.status)) {
            return true;
        } else if(ExecutionStatus.FAILED.equals(this.status)) {
            return true;
        } else if(ExecutionStatus.DISCARDED.equals(this.status)) {
            return true;
        } else {
            return false;
        }
    }
    
    // in minutes
//    private Long getNotUpdatedFor() {
//        if(this.getBegin()!=null && this.getLastUpdate()!=null) {
//            return (Calendar.getInstance().getTimeInMillis()-this.getLastUpdate().getTimeInMillis())/1000/60;
//        } else {
//            return 0L;
//        }
//    }

    public void setStatus(ExecutionStatus status) {
        this.status = status;
    }

    public Double getProgress() {
        return progress;
    }

    public void setProgress(Double progress) {
        this.progress = progress;
    }

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Collection<ExecutionReport> getReports() {
        return reports;
    }

    public void setReports(Collection<ExecutionReport> reports) {
        this.reports = reports;
    }

    public Calendar getLastUpdate() {
        return lastUpdate;
    }

    public void setLastUpdate(Calendar lastUpdate) {
        this.lastUpdate = lastUpdate;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }

}
