package org.gcube.dataanalysis.copernicus.motu.client;

import java.util.Calendar;

import org.gcube.dataanalysis.copernicus.motu.model.RequestSize;
import org.gcube.dataanalysis.copernicus.motu.model.StatusModeResponse;

public class DownloadRequestEnvelope extends DownloadRequest {

    /**
     * A link to the original request.
     */
    private DownloadRequest originalRequest;

    /**
     * The status of the request, as reported by the server. Or null, if not yet
     * submitted.
     */
    private StatusModeResponse status;

    /**
     * A flag to mark a chuck whose content has been downloaded.
     */
    private String downloadStatus;

    /**
     *
     */
    private Calendar start;

    /**
     *
     */
    private Calendar end;

    /**
     * The name to be set on the output file.
     */
    private String name;

    /**
     * The estimated size, as reported by the server.
     */
    private RequestSize size;

    public DownloadRequestEnvelope() {
        super();
    }

    public DownloadRequestEnvelope(DownloadRequest other) {
        super(other);
    }

    public DownloadRequest getOriginalRequest() {
        return originalRequest;
    }

    public void setOriginalRequest(DownloadRequest originalRequest) {
        this.originalRequest = originalRequest;
    }

    public StatusModeResponse getStatus() {
        return status;
    }

    public void setStatus(StatusModeResponse status) {
        this.status = status;
    }

    public String getDownloadStatus() {
        return this.downloadStatus;
    }

    /**
     * 
     * @param status
     */
    public void setDownloadStatus(String status) {
        this.downloadStatus = status;
    }

    /**
     * 
     * @return
     */
    public Calendar getStart() {
        return start;
    }

    /**
     * 
     * @param s
     */
    public void setStart(final Calendar start) {
        this.start = start;
    }

    public Calendar getEnd() {
        return end;
    }

    /**
     *
     * @param e
     */
    public void setEnd(final Calendar end) {
        this.end = end;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public RequestSize getSize() {
        return size;
    }

    public void setSize(RequestSize size) {
        this.size = size;
    }

}
