package org.gcube.dataanalysis.copernicus.motu.model;

import java.text.ParseException;

import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;

import org.apache.commons.lang.builder.ToStringBuilder;
import org.gcube.dataanalysis.datasetimporter.util.SizeUtils;

@XmlRootElement
public class RequestSize {

    private String code;
    private String message;
    private String unit;
    private String size;
    private String maxAllowedSize;

    @XmlAttribute
    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    @XmlAttribute
    public String getMessage() {
        return message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    @XmlAttribute
    public String getUnit() {
        return unit;
    }

    public void setUnit(String unit) {
        this.unit = unit;
    }

    @XmlAttribute
    public String getSize() {
        return size;
    }

    public void setSize(String size) {
        this.size = size;
    }

    @XmlAttribute
    public String getMaxAllowedSize() {
        return maxAllowedSize;
    }

    public void setMaxAllowedSize(String maxAllowedSize) {
        this.maxAllowedSize = maxAllowedSize;
    }

    public Long getSizeInBytes() throws ParseException {
        return SizeUtils
                .parse(this.getSize() + " " + this.getUnit().toUpperCase());
    }

    public Long getMaxAllowedSizeInBytes() throws ParseException {
        return SizeUtils.parse(
                this.getMaxAllowedSize() + " " + this.getUnit().toUpperCase());
    }

    /**
     * Return how much the request has to be scaled to fit the max allowed size
     * 
     * @return
     */
    public Double getFitRatio() throws ParseException {
        return (1d * this.getMaxAllowedSizeInBytes())
                / (1d * this.getSizeInBytes());
    }

    public boolean isValid() throws ParseException {
        return this.getSizeInBytes() < this.getMaxAllowedSizeInBytes();
    }

    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }

}
