package org.gcube.dataanalysis.copernicus.motu.model;

import java.io.StringWriter;

import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;

/**
 * Helper class to marshal xml representations to java objects.
 * 
 * @author Paolo Fabriani
 *
 */
public class MotuMarshaller {

    public static String toXml(ProductMetadataInfo metadata)
            throws JAXBException {
        JAXBContext jaxbContext = JAXBContext
                .newInstance(ProductMetadataInfo.class);
        Marshaller jaxbMarshaller = jaxbContext.createMarshaller();
        jaxbMarshaller.setProperty(Marshaller.JAXB_FORMATTED_OUTPUT, true);
        StringWriter writer = new StringWriter();
        jaxbMarshaller.marshal(metadata, writer);
        return writer.toString();
    }

    public static String toXml(ServiceMetadata metadata)
            throws JAXBException {
        JAXBContext jaxbContext = JAXBContext
                .newInstance(ServiceMetadata.class);
        Marshaller jaxbMarshaller = jaxbContext.createMarshaller();
        jaxbMarshaller.setProperty(Marshaller.JAXB_FORMATTED_OUTPUT, true);
        StringWriter writer = new StringWriter();
        jaxbMarshaller.marshal(metadata, writer);
        return writer.toString();
    }

    public static String toXml(MotuCatalogue server)
            throws JAXBException {
        JAXBContext jaxbContext = JAXBContext
                .newInstance(MotuCatalogue.class);
        Marshaller jaxbMarshaller = jaxbContext.createMarshaller();
        jaxbMarshaller.setProperty(Marshaller.JAXB_FORMATTED_OUTPUT, true);
        StringWriter writer = new StringWriter();
        jaxbMarshaller.marshal(server, writer);
        return writer.toString();
    }

}
