/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataanalysis.executor.nodes.algorithms;

import java.io.File;
import java.io.FileWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Timer;
import java.util.TimerTask;
import org.gcube.contentmanagement.graphtools.utils.MathFunctions;
import org.gcube.contentmanagement.lexicalmatcher.utils.AnalysisLogger;
import org.gcube.dataanalysis.ecoengine.configuration.ALG_PROPS;
import org.gcube.dataanalysis.ecoengine.configuration.AlgorithmConfiguration;
import org.gcube.dataanalysis.ecoengine.datatypes.OutputTable;
import org.gcube.dataanalysis.ecoengine.datatypes.StatisticalType;
import org.gcube.dataanalysis.ecoengine.datatypes.enumtypes.TableTemplates;
import org.gcube.dataanalysis.ecoengine.interfaces.SpatialProbabilityDistributionNode;
import org.gcube.dataanalysis.ecoengine.spatialdistributions.AquamapsAlgorithmCore;
import org.gcube.dataanalysis.ecoengine.spatialdistributions.AquamapsSuitable;
import org.gcube.dataanalysis.ecoengine.user.GeneratorT;
import org.gcube.dataanalysis.ecoengine.utils.DatabaseFactory;
import org.gcube.dataanalysis.ecoengine.utils.DatabaseUtils;
import org.gcube.dataanalysis.ecoengine.utils.Operations;
import org.gcube.dataanalysis.executor.nodes.algorithms.AquamapsSuitableFunctions;
import org.hibernate.SessionFactory;

public class AquamapsSuitableNode1v
extends SpatialProbabilityDistributionNode {
    protected String countSpeciesQuery;
    protected String countCellsQuery;
    protected String createTableStatement;
    protected String destinationTable;
    protected String destinationTableLabel;
    protected String type;
    protected AquamapsAlgorithmCore core;
    protected AlgorithmConfiguration currentconfig;
    protected AquamapsSuitableFunctions operations;
    protected SessionFactory dbHibConnection;
    private int lastProcessed;
    Timer databasecheckScheduler;
    private static int refreshTime = 10000;

    public void setup(AlgorithmConfiguration config) throws Exception {
        long t00 = System.currentTimeMillis();
        this.initSingleNode(config);
        long t0 = System.currentTimeMillis();
        String distributionTable = config.getParam("DistributionTable");
        boolean createTable = config.getParam("CreateTable") != null ? Boolean.parseBoolean(config.getParam("CreateTable")) : false;
        System.out.println("Creating table " + distributionTable + " " + createTable);
        if (createTable) {
            try {
                DatabaseUtils.dropTableStatement((String)distributionTable);
            }
            catch (Exception exception) {
                // empty catch block
            }
            DatabaseUtils.createBigTable((boolean)createTable, (String)distributionTable, (String)config.getDatabaseDriver(), (String)config.getDatabaseUserName(), (String)config.getDatabasePassword(), (String)config.getDatabaseURL(), (String)this.createTableStatement, (SessionFactory)this.dbHibConnection);
        }
        this.createMaxMinHspen(config);
        System.out.println("Preparation phase finished in " + (System.currentTimeMillis() - t00) + " ms");
    }

    private void createMaxMinHspen(AlgorithmConfiguration config) {
        String hspenMinMaxLat = "";
        if (config.getParam("PreprocessedTable") != null && config.getParam("PreprocessedTable").length() > 0) {
            hspenMinMaxLat = config.getParam("PreprocessedTable");
        }
        if (hspenMinMaxLat == null || hspenMinMaxLat.length() == 0) {
            String hspenTable = config.getParam("EnvelopeTable");
            String supposedminmaxlattable = "maxminlat_" + hspenTable;
            List select = null;
            try {
                select = DatabaseFactory.executeSQLQuery((String)("select * from " + supposedminmaxlattable + " limit 1"), (SessionFactory)this.dbHibConnection);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (select != null) {
                hspenMinMaxLat = supposedminmaxlattable;
                System.out.println("Aquamaps Algorithm Node Init ->the min max latitudes table yet exists " + hspenMinMaxLat);
            } else {
                System.out.println("Aquamaps Algorithm Node Init ->the min max latitudes table does not exist! - generating");
                hspenMinMaxLat = AquamapsSuitable.generateMaxMinHspec((String)supposedminmaxlattable, (String)hspenTable, (String)config.getParam("OccurrencePointsTable"), (SessionFactory)this.dbHibConnection);
                System.out.println("Aquamaps Algorithm Node Init ->min max latitudes table created in " + hspenMinMaxLat);
            }
        }
        config.setParam("PreprocessedTable", hspenMinMaxLat);
    }

    public void initSingleNode(AlgorithmConfiguration config) {
        this.initCore(config);
        System.out.println("Aquamaps Algorithm Init ->Taking all species records");
        this.operations.numberOfSpecies = Integer.parseInt("" + DatabaseFactory.executeSQLQuery((String)this.countSpeciesQuery, (SessionFactory)this.dbHibConnection).get(0));
        System.out.println("Aquamaps Algorithm Init ->Count all csquares");
        this.operations.numberOfCells = Integer.parseInt("" + DatabaseFactory.executeSQLQuery((String)this.countCellsQuery, (SessionFactory)this.dbHibConnection).get(0));
        System.out.println("Aquamaps Algorithm Init ->init finished");
    }

    private void initCore(AlgorithmConfiguration config) {
        this.currentconfig = config;
        System.out.println("Aquamaps Algorithm-> Initializing DB connection");
        this.dbHibConnection = DatabaseUtils.initDBSession((AlgorithmConfiguration)config);
        System.out.println("Aquamaps Algorithm-> Initializing DB connection OK");
        this.countSpeciesQuery = String.format(AquamapsSuitableFunctions.countAllSpeciesQuery, config.getParam("EnvelopeTable"));
        this.countCellsQuery = String.format(AquamapsSuitableFunctions.countCsquareCodeQuery, config.getParam("CsquarecodesTable"));
        this.createTableStatement = String.format(AquamapsSuitableFunctions.createTableStatement, config.getParam("DistributionTable"));
        this.createTableStatement = config.getTableSpace() != null ? this.createTableStatement.replace("#TABLESPACE#", "TABLESPACE " + config.getTableSpace()) : this.createTableStatement.replace("#TABLESPACE#", "");
        this.destinationTable = config.getParam("DistributionTable");
        this.destinationTableLabel = config.getParam("DistributionTableLabel");
        System.out.println("Aquamaps Algorithm-> Initializing Core Algorithm");
        this.core = new AquamapsAlgorithmCore();
        this.operations = new AquamapsSuitableFunctions(this.core, this.type, config);
        System.out.println("Aquamaps Algorithm-> Core Initializiation OK ");
    }

    public int executeNode(int cellOrdinal, int chunksize, int speciesOrdinal, int speciesChunkSize, boolean duplicate, String pathToFiles, String nodeConfigurationFileObject, String logfile) {
        long t00;
        block12: {
            t00 = System.currentTimeMillis();
            try {
                try {
                    System.out.println("Aquamaps Suitable: " + cellOrdinal + " Node Started");
                    this.core = new AquamapsAlgorithmCore();
                    this.operations = new AquamapsSuitableFunctions(new AquamapsAlgorithmCore(), this.type, null);
                    System.out.println("Aquamaps Suitable: " + cellOrdinal + " Rebuilding objects");
                    long t0 = System.currentTimeMillis();
                    this.operations.rebuildConfig(new File(pathToFiles, nodeConfigurationFileObject).getAbsolutePath());
                    this.operations.currentconfig.setConfigPath(pathToFiles);
                    this.currentconfig = this.operations.currentconfig;
                    System.out.println("Aquamaps Suitable: " + speciesOrdinal + " Objects Rebuilt in " + (System.currentTimeMillis() - t0) + " ms");
                    String SpeciesQuery = String.format(AquamapsSuitableFunctions.selectAllSpeciesQuery, this.currentconfig.getParam("EnvelopeTable"), "" + speciesChunkSize, "" + speciesOrdinal);
                    String CellsQuery = String.format(AquamapsSuitableFunctions.csquareCodeQuery, this.currentconfig.getParam("CsquarecodesTable"), "" + chunksize, "" + cellOrdinal);
                    System.out.println("Aquamaps Algorithm-> Initializing DB connection with parameters: " + this.currentconfig.getConfigPath() + AlgorithmConfiguration.defaultConnectionFile + " " + this.currentconfig.getParam("DatabaseDriver") + " " + this.currentconfig.getParam("DatabaseUserName") + " " + this.currentconfig.getParam("DatabasePassword") + " " + this.currentconfig.getParam("DatabaseURL"));
                    System.out.println("Aquamaps Algorithm-> File Exists: " + new File(String.valueOf(this.currentconfig.getConfigPath()) + AlgorithmConfiguration.defaultConnectionFile).exists());
                    System.out.println("Aquamaps Algorithm-> File IS READABLE: " + new File(String.valueOf(this.currentconfig.getConfigPath()) + AlgorithmConfiguration.defaultConnectionFile).canRead());
                    this.dbHibConnection = DatabaseUtils.initDBSession((AlgorithmConfiguration)this.currentconfig);
                    System.out.println("Aquamaps Algorithm-> Building Species Observations Max-Min Latitutes");
                    this.operations.allSpeciesObservations = new HashMap();
                    String hspenMinMaxLat = this.currentconfig.getParam("PreprocessedTable");
                    System.out.println("Aquamaps Algorithm-> Preprocessed Table is " + hspenMinMaxLat);
                    System.out.println("Aquamaps Algorithm-> Query: " + String.format(AquamapsSuitableFunctions.selectAllSpeciesObservationQuery, hspenMinMaxLat));
                    System.out.println("Aquamaps Algorithm-> DB CONNECTION " + this.dbHibConnection);
                    ArrayList SpeciesObservations = DatabaseFactory.executeSQLQuery((String)String.format(AquamapsSuitableFunctions.selectAllSpeciesObservationQuery, hspenMinMaxLat), (SessionFactory)this.dbHibConnection);
                    System.out.println("Aquamaps Algorithm-> Queried");
                    if (SpeciesObservations == null) {
                        SpeciesObservations = new ArrayList();
                    }
                    System.out.println("Aquamaps Algorithm-> Obtained Observations " + SpeciesObservations.size());
                    int lenObservations = SpeciesObservations.size();
                    int i = 0;
                    while (i < lenObservations) {
                        Object[] maxminArray = (Object[])SpeciesObservations.get(i);
                        String speciesid = (String)maxminArray[0];
                        ArrayList<Object[]> maxminInfo = new ArrayList<Object[]>();
                        maxminInfo.add(maxminArray);
                        this.operations.allSpeciesObservations.put(speciesid, maxminInfo);
                        ++i;
                    }
                    System.out.println("Aquamaps Algorithm ->Taking species records");
                    this.operations.speciesVectors = DatabaseFactory.executeSQLQuery((String)SpeciesQuery, (SessionFactory)this.dbHibConnection);
                    System.out.println("Aquamaps Algorithm ->Taking csquares");
                    if (this.operations.environmentVectors == null) {
                        this.operations.environmentVectors = DatabaseFactory.executeSQLQuery((String)CellsQuery, (SessionFactory)this.dbHibConnection);
                    }
                    int maxSpecies = this.operations.speciesVectors.size();
                    int maxCells = this.operations.environmentVectors.size();
                    System.out.println("Aquamaps Algorithm ->Processing " + maxCells + " cells VS " + maxSpecies + " species");
                    System.out.println("Aquamaps Algorithm ->Focus On Table: " + this.currentconfig.getParam("DistributionTable"));
                    int j = 0;
                    while (j < maxSpecies) {
                        System.out.println("Aquamaps Suitable: calculating elements from " + cellOrdinal + " to " + maxCells + " for species " + j);
                        Object speciesV = this.operations.speciesVectors.get(j);
                        System.out.println("Aquamaps Suitable: " + cellOrdinal + " calculating probabilities");
                        this.singleStepPreprocess(speciesV, duplicate);
                        int i2 = 0;
                        while (i2 < maxCells) {
                            Object area = this.operations.environmentVectors.get(i2);
                            this.operations.calcProb(speciesV, area);
                            ++i2;
                        }
                        System.out.println("Aquamaps Suitable: " + cellOrdinal + " probabilities calculated!");
                        System.out.println("Aquamaps Suitable: " + cellOrdinal + " writing on DB");
                        this.singleStepPostprocess(speciesV);
                        System.out.println("Aquamaps Suitable: " + cellOrdinal + " write on DB OK");
                        ++j;
                    }
                    try {
                        FileWriter fw = new FileWriter(new File(logfile));
                        fw.write("OK");
                        fw.close();
                    }
                    catch (Exception exception) {}
                }
                catch (Exception e) {
                    System.err.println("ERROR " + e);
                    e.printStackTrace();
                    DatabaseUtils.closeDBConnection((SessionFactory)this.dbHibConnection);
                    System.out.println("Aquamaps Suitable: " + cellOrdinal + " Database Closed!");
                    break block12;
                }
            }
            catch (Throwable throwable) {
                DatabaseUtils.closeDBConnection((SessionFactory)this.dbHibConnection);
                System.out.println("Aquamaps Suitable: " + cellOrdinal + " Database Closed!");
                throw throwable;
            }
            DatabaseUtils.closeDBConnection((SessionFactory)this.dbHibConnection);
            System.out.println("Aquamaps Suitable: " + cellOrdinal + " Database Closed!");
        }
        System.out.println("Aquamaps Suitable: " + cellOrdinal + " Node Ended in " + (float)(System.currentTimeMillis() - t00) / 1000.0f + " s");
        return 0;
    }

    public List<StatisticalType> getInputParameters() {
        List parameters = new AquamapsSuitable().getInputParameters();
        return parameters;
    }

    public Queue<String> filterProbabilitySet(Queue<String> probabiltyRows) {
        return probabiltyRows;
    }

    public float getInternalStatus() {
        return 100.0f;
    }

    public ALG_PROPS[] getProperties() {
        ALG_PROPS[] p = new ALG_PROPS[]{ALG_PROPS.PARALLEL_SPECIES_VS_CSQUARE_FROM_DATABASE};
        return p;
    }

    public String getName() {
        return "AQUAMAPS_SUITABLE";
    }

    public String getDescription() {
        return "Algorithm by Aquamaps on a single node";
    }

    public void postProcess(boolean manageDuplicates, boolean manageFault) {
        if (this.databasecheckScheduler != null) {
            this.databasecheckScheduler.cancel();
        }
        if (manageFault) {
            try {
                DatabaseFactory.executeSQLUpdate((String)("drop table " + this.currentconfig.getParam("DistributionTable")), (SessionFactory)this.dbHibConnection);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void postProcess4(boolean manageDuplicates) {
        if (this.databasecheckScheduler != null) {
            this.databasecheckScheduler.cancel();
        }
        if (manageDuplicates) {
            try {
                long t0 = System.currentTimeMillis();
                System.out.println("Deleting duplicates ... this can require very much time");
                String distributionTable = this.currentconfig.getParam("DistributionTable");
                String countQuery = String.format("select count(*) from %1$s ", distributionTable);
                System.out.println("Taking number of elements ... ");
                long t00 = System.currentTimeMillis();
                int nElements = Integer.parseInt("" + DatabaseFactory.executeSQLQuery((String)countQuery, (SessionFactory)this.dbHibConnection).get(0));
                System.out.println("Calculated " + nElements + " elements in " + (System.currentTimeMillis() - t00));
                int maxRounds = 100;
                int[] chunkSizes = Operations.takeChunks((int)nElements, (int)maxRounds);
                String selectChunk = "select speciesid,csquarecode, CAST( ctid AS text ) from %1$s limit %2$s offset %3$s";
                int offset = 0;
                HashMap<String, String> mapSpecies = new HashMap<String, String>();
                ArrayList<String> duplicates = new ArrayList<String>();
                t00 = System.currentTimeMillis();
                int i = 0;
                while (i < maxRounds) {
                    String query = String.format(selectChunk, distributionTable, "" + chunkSizes[i], "" + offset);
                    System.out.println("Selecting " + chunkSizes[i] + " from " + (offset += chunkSizes[i]) + " : " + query);
                    long t01 = System.currentTimeMillis();
                    List objs = DatabaseFactory.executeSQLQuery((String)query, (SessionFactory)this.dbHibConnection);
                    System.out.println("Selected in " + (System.currentTimeMillis() - t01));
                    for (Object rowO : objs) {
                        Object[] row = (Object[])rowO;
                        String species = "" + row[0];
                        String csquareCode = "" + row[1];
                        String ctid = "" + row[2];
                        String key = String.valueOf(species) + ":" + csquareCode;
                        if (mapSpecies.containsKey(key)) {
                            duplicates.add(ctid);
                            continue;
                        }
                        mapSpecies.put(key, ctid);
                    }
                    System.out.println("Status " + (float)i / (float)maxRounds * 100.0f);
                    ++i;
                }
                System.out.println("Finished map calculation in " + (System.currentTimeMillis() - t00));
                t00 = System.currentTimeMillis();
                StringBuffer toDelete = new StringBuffer();
                toDelete.append("delete * from %1$s where ctid in (");
                int size = duplicates.size();
                if (size > 0) {
                    System.out.println("Building Deleting Statement ...");
                    int j = 0;
                    while (j < size) {
                        toDelete.append((String)duplicates.get(j));
                        if (j != size - 1) {
                            toDelete.append(",");
                        }
                        ++j;
                    }
                    toDelete.append(")");
                    System.out.println("Finished Building Deleting Statement in " + (System.currentTimeMillis() - t00));
                    System.out.println("Deleting ...");
                    t00 = System.currentTimeMillis();
                    DatabaseFactory.executeSQLUpdate((String)toDelete.toString(), (SessionFactory)this.dbHibConnection);
                    System.out.println("... Deleted in " + (System.currentTimeMillis() - t00));
                } else {
                    System.out.println("No Duplications to delete");
                }
                System.out.println("Deleted All duplicates in " + (System.currentTimeMillis() - t0));
            }
            catch (Exception e) {
                System.out.println("An Error Occurred");
                e.printStackTrace();
            }
        }
    }

    public void postProcess1(boolean manageDuplicates) {
        if (this.databasecheckScheduler != null) {
            this.databasecheckScheduler.cancel();
        }
        if (manageDuplicates) {
            long t0 = System.currentTimeMillis();
            System.out.println("Deleting duplicates ... this can require very much time");
            String distributionTable = this.currentconfig.getParam("DistributionTable");
            String deletecommand = String.format("select * into testtable from %1$s where exists (select  * from %1$s i where i.speciesid = %1$s.speciesid and i.csquarecode = %1$s.csquarecode and i.ctid < %1$s.ctid)", this.currentconfig.getParam("DistributionTable"));
            try {
                DatabaseFactory.executeSQLQuery((String)deletecommand, (SessionFactory)this.dbHibConnection);
                System.out.println("Deleted duplicates in " + (System.currentTimeMillis() - t0));
            }
            catch (Exception e) {
                System.out.println("An Error Occurred");
                e.printStackTrace();
            }
        }
    }

    public void postProcess2(boolean manageDuplicates) {
        if (this.databasecheckScheduler != null) {
            this.databasecheckScheduler.cancel();
        }
        if (manageDuplicates) {
            long t0 = System.currentTimeMillis();
            System.out.println("Deleting duplicates ... this can require very much time");
            String deletecommand = String.format("select * from %1$s where exists (select  * from %1$s i where i.speciesid = %1$s.speciesid and i.csquarecode = %1$s.csquarecode and i.ctid < %1$s.ctid)", this.currentconfig.getParam("DistributionTable"));
            try {
                DatabaseFactory.executeSQLQuery((String)deletecommand, (SessionFactory)this.dbHibConnection);
                System.out.println("Deleted duplicates in " + (System.currentTimeMillis() - t0));
            }
            catch (Exception e) {
                System.out.println("An Error Occurred");
                e.printStackTrace();
            }
        }
    }

    public static void main2(String[] args) throws Exception {
        String configPath = "./cfg/";
        String csquareTable = "hcaf_d";
        String preprocessedTable = "maxminlat_hspen";
        String envelopeTable = "hspen";
        int numberOfResources = 1;
        String userName = "gianpaolo.coro";
        String generatorName = "AQUAMAPS_SUITABLE";
        String scope = "/gcube";
        String finalDistributionTable = "hspec_suitable_executor_all1";
        AlgorithmConfiguration config = GeneratorT.getGenerationConfig((int)numberOfResources, (String)generatorName, (String)envelopeTable, (String)preprocessedTable, (String)"", (String)userName, (String)csquareTable, (String)finalDistributionTable, (String)configPath);
        config.setPersistencePath("./");
        config.setGcubeScope(scope);
        config.setParam("ServiceUserName", "gianpaolo.coro");
        config.setParam("CreateTable", "false");
        config.setParam("DatabaseUserName", "utente");
        config.setParam("DatabasePassword", "d4science");
        config.setParam("DatabaseURL", "jdbc:postgresql://dbtest.research-infrastructures.eu/aquamapsorgupdated");
        config.setParam("DatabaseDriver", "org.hibernate.dialect.PostgreSQLDialect");
        config.setTableSpace("tbsp_1");
        AquamapsSuitableNode1v node = new AquamapsSuitableNode1v();
        node.setup(config);
        node.postProcess(true, false);
    }

    public void singleStepPreprocess(Object species, boolean duplicate) throws Exception {
        List<Object> speciesObservations = this.operations.allSpeciesObservations.get(AquamapsSuitableFunctions.getMainInfoID(species));
        if (speciesObservations == null || speciesObservations.size() == 0) {
            Object[] defaultmaxmin = new Object[]{"90", "-90"};
            speciesObservations = new ArrayList<Object>();
            speciesObservations.add(defaultmaxmin);
        }
        String speciesID = AquamapsSuitableFunctions.getMainInfoID(species);
        if (duplicate) {
            System.out.println("Deleting Duplicates for species " + speciesID);
            long t0 = System.currentTimeMillis();
            DatabaseFactory.executeSQLUpdate((String)String.format(AquamapsSuitableFunctions.deleteDuplicates, this.currentconfig.getParam("DistributionTable"), speciesID), (SessionFactory)this.dbHibConnection);
            System.out.println("Duplicates deleted in " + (System.currentTimeMillis() - t0));
        }
        this.operations.getBoundingBoxInformation((Object[])species, (Object[])speciesObservations.get(0));
    }

    public void singleStepPostprocess(Object species) {
        ArrayList<String> toWrite = new ArrayList<String>();
        String speciesID = AquamapsSuitableFunctions.getMainInfoID(species);
        Map<String, Float> csquaresMap = this.operations.completeDistribution.get(speciesID);
        if (csquaresMap != null) {
            for (String singleCsquare : csquaresMap.keySet()) {
                String additionalInformation = this.operations.getAdditionalInformation(species, this.operations.processedAreas.get(singleCsquare));
                if (additionalInformation == null) {
                    additionalInformation = "";
                } else if (additionalInformation.length() > 0) {
                    additionalInformation = "," + additionalInformation.trim();
                }
                float prob = 0.0f;
                try {
                    prob = csquaresMap.get(singleCsquare).floatValue();
                }
                catch (Exception e) {
                    System.out.println("Aquamaps Algorithm Single Step PostProcess ->Error in getting probability value at " + speciesID + " , " + singleCsquare);
                }
                if (!(prob > 0.0f)) continue;
                toWrite.add("'" + speciesID + "','" + singleCsquare + "','" + MathFunctions.roundDecimal((double)prob, (int)2) + "'" + additionalInformation);
            }
            AquamapsSuitableFunctions.writeOnDB(toWrite, this.currentconfig.getParam("DistributionTable"), this.dbHibConnection);
        }
    }

    public StatisticalType getOutput() {
        ArrayList<TableTemplates> templateHspec = new ArrayList<TableTemplates>();
        templateHspec.add(TableTemplates.HSPEC);
        OutputTable p = new OutputTable(templateHspec, this.destinationTableLabel, this.destinationTable, "Output hspec table");
        return p;
    }

    public int getNumberOfSpecies() {
        return this.operations.numberOfSpecies;
    }

    public int getNumberOfGeoInfo() {
        return this.operations.numberOfCells;
    }

    public int getNumberOfProcessedSpecies() {
        return this.lastProcessed;
    }

    public void stop() {
        try {
            this.databasecheckScheduler.cancel();
        }
        catch (Exception exception) {
            // empty catch block
        }
        DatabaseUtils.closeDBConnection((SessionFactory)this.dbHibConnection);
    }

    private class DatabaseController
    extends TimerTask {
        private DatabaseController() {
        }

        @Override
        public void run() {
            try {
                List explain = DatabaseFactory.executeSQLQuery((String)String.format(AquamapsSuitableFunctions.countAll, AquamapsSuitableNode1v.this.currentconfig.getParam("DistributionTable")), (SessionFactory)AquamapsSuitableNode1v.this.dbHibConnection);
                String explained = "" + explain.get(0);
                explained = explained.substring(explained.lastIndexOf("rows="));
                explained = explained.substring(explained.indexOf(61) + 1, explained.indexOf(32));
                AnalysisLogger.getLogger().debug((Object)("ESTIMATED ROWS: " + explained));
                AquamapsSuitableNode1v.this.lastProcessed = Integer.parseInt(explained);
            }
            catch (Exception e) {
                try {
                    e.printStackTrace();
                }
                catch (Exception e2) {
                    e.printStackTrace();
                }
            }
        }
    }
}

