/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataanalysis.executor.messagequeue;

import javax.jms.ExceptionListener;
import javax.jms.JMSException;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import org.gcube.dataanalysis.executor.messagequeue.QueueManager;

public class Consumer {
    public QueueManager manager;
    public MessageConsumer consumer;
    private MessageListener consumerCallback;
    private ExceptionListener errorCallback;
    private String topic;

    public Consumer(QueueManager manager, MessageListener consumerCallback, ExceptionListener errorCallback, String topic) throws JMSException, InterruptedException {
        this.manager = manager;
        this.consumerCallback = consumerCallback;
        this.errorCallback = errorCallback;
        this.topic = topic;
        this.create();
    }

    private void create() throws JMSException, InterruptedException {
        MessageConsumer consumer = this.manager.session.createConsumer(this.manager.destination);
        this.manager.connection.setExceptionListener(this.errorCallback);
        consumer.setMessageListener(this.consumerCallback);
    }

    public void standBy() throws JMSException {
        if (this.consumer != null) {
            this.consumer.close();
        }
    }

    public void wake() throws Exception {
        this.create();
    }

    public void stop() throws JMSException {
        if (this.consumer != null) {
            this.consumer.close();
        }
    }

    public void closeSession() throws JMSException {
        try {
            this.manager.closeSession();
            this.manager.connection.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

