/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataanalysis.executor.tests;

import org.gcube.dataanalysis.ecoengine.configuration.AlgorithmConfiguration;
import org.gcube.dataanalysis.ecoengine.interfaces.ComputationalAgent;
import org.gcube.dataanalysis.ecoengine.test.regression.Regressor;
import org.gcube.dataanalysis.executor.generators.D4ScienceDistributedProcessing;
import org.gcube.dataanalysis.executor.tests.TestGenerator;

public class TestD4ScienceQueueMaps2_2 {
    public static void main(String[] args) throws Exception {
        String configPath = "./cfg/";
        String csquareTable = "hcaf_d";
        String preprocessedTable = "maxminlat_hspen";
        String occurrencesTable = "occurrencecells";
        String envelopeTable = "hspen_micro_1";
        int numberOfResources = 1;
        String userName = "gianpaolo.coro";
        String generatorName = "AQUAMAPS_SUITABLE";
        String scope = "/gcube";
        String finalDistributionTable = "hspec_suitable_executorsingle_t";
        AlgorithmConfiguration config = Regressor.getConfig();
        config.setConfigPath(configPath);
        config.setNumberOfResources(Integer.valueOf(numberOfResources));
        config.setModel(generatorName);
        config.setParam("EnvelopeTable", envelopeTable);
        config.setParam("CsquarecodesTable", csquareTable);
        config.setParam("DistributionTable", finalDistributionTable);
        config.setParam("CreateTable", "true");
        config.setParam("UserName", userName);
        config.setPersistencePath("./");
        config.setParam("OccurrencePointsTable", occurrencesTable);
        config.setGcubeScope(scope);
        config.setParam("ServiceUserName", "gianpaolo.coro");
        TestD4ScienceQueueMaps2_2.generate(config);
    }

    public static void generate(AlgorithmConfiguration config) throws Exception {
        D4ScienceDistributedProcessing generator = new D4ScienceDistributedProcessing(config);
        generator.init();
        if (generator != null) {
            long t0 = System.currentTimeMillis();
            TestGenerator tgs = new TestGenerator((ComputationalAgent)generator);
            Thread t = new Thread(tgs);
            t.start();
            while (generator.getStatus() < 100.0f) {
                String resLoad = generator.getResourceLoad();
                String ress = generator.getResources();
                String species = generator.getLoad();
                System.out.println("LOAD: " + resLoad);
                System.out.println("RESOURCES: " + ress);
                System.out.println("SPECIES: " + species);
                System.out.println("STATUS: " + generator.getStatus());
                Thread.sleep(20000L);
            }
            System.out.println("FINAL STATUS: " + generator.getStatus() + " ELAPSED " + (System.currentTimeMillis() - t0));
        } else {
            System.out.println("Generator Algorithm Not Supported");
        }
    }
}

